/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.unixusersync.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.apache.ranger.credentialapi.CredentialReader;
import org.apache.ranger.usergroupsync.UserGroupSink;
import org.apache.ranger.usergroupsync.UserGroupSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UserGroupSyncConfig {
    public static final String CONFIG_FILE = "ranger-ugsync-site.xml";
    private static final Logger LOG = Logger.getLogger(UserGroupSyncConfig.class);
    public static final String DEFAULT_CONFIG_FILE = "ranger-ugsync-default-site.xml";
    private static final String CORE_SITE_CONFIG_FILE = "core-site.xml";
    public static final String UGSYNC_ENABLED_PROP = "ranger.usersync.enabled";
    public static final String UGSYNC_PM_URL_PROP = "ranger.usersync.policymanager.baseURL";
    public static final String UGSYNC_MIN_USERID_PROP = "ranger.usersync.unix.minUserId";
    public static final String UGSYNC_MIN_GROUPID_PROP = "ranger.usersync.unix.minGroupId";
    public static final String DEFAULT_UGSYNC_MIN_GROUPID = "0";
    public static final String UGSYNC_MAX_RECORDS_PER_API_CALL_PROP = "ranger.usersync.policymanager.maxrecordsperapicall";
    public static final String UGSYNC_MOCK_RUN_PROP = "ranger.usersync.policymanager.mockrun";
    public static final String UGSYNC_SOURCE_FILE_PROC = "ranger.usersync.filesource.file";
    public static final String UGSYNC_SOURCE_FILE_DELIMITER = "ranger.usersync.filesource.text.delimiter";
    public static final String UGSYNC_SOURCE_FILE_DELIMITERER = "ranger.usersync.filesource.text.delimiterer";
    private static final String SSL_KEYSTORE_PATH_PARAM = "ranger.usersync.keystore.file";
    private static final String SSL_KEYSTORE_PATH_PASSWORD_PARAM = "ranger.usersync.keystore.password";
    private static final String SSL_TRUSTSTORE_PATH_PARAM = "ranger.usersync.truststore.file";
    private static final String SSL_TRUSTSTORE_PATH_PASSWORD_PARAM = "ranger.usersync.truststore.password";
    private static final String UGSYNC_SLEEP_TIME_IN_MILLIS_BETWEEN_CYCLE_PARAM = "ranger.usersync.sleeptimeinmillisbetweensynccycle";
    private static final long UGSYNC_SLEEP_TIME_IN_MILLIS_BETWEEN_CYCLE_MIN_VALUE = 60000L;
    private static final long UGSYNC_SLEEP_TIME_IN_MILLIS_BETWEEN_CYCLE_UNIX_DEFAULT_VALUE = 60000L;
    private static final long UGSYNC_SLEEP_TIME_IN_MILLIS_BETWEEN_CYCLE_LDAP_DEFAULT_VALUE = 3600000L;
    private static final String UGSYNC_SOURCE_CLASS_PARAM = "ranger.usersync.source.impl.class";
    private static final String UGSYNC_SINK_CLASS_PARAM = "ranger.usersync.sink.impl.class";
    private static final String UGSYNC_SOURCE_CLASS = "org.apache.ranger.unixusersync.process.UnixUserGroupBuilder";
    private static final String UGSYNC_SINK_CLASS = "org.apache.ranger.unixusersync.process.PolicyMgrUserGroupBuilder";
    private static final String LGSYNC_SOURCE_CLASS = "org.apache.ranger.ldapusersync.process.LdapUserGroupBuilder";
    private static final String LGSYNC_LDAP_URL = "ranger.usersync.ldap.url";
    private static final String LGSYNC_LDAP_STARTTLS_ENABLED = "ranger.usersync.ldap.starttls";
    private static final boolean DEFAULT_LGSYNC_LDAP_STARTTLS_ENABLED = false;
    private static final String LGSYNC_LDAP_BIND_DN = "ranger.usersync.ldap.binddn";
    private static final String LGSYNC_LDAP_BIND_KEYSTORE = "ranger.usersync.credstore.filename";
    private static final String LGSYNC_LDAP_BIND_ALIAS = "ranger.usersync.ldap.bindalias";
    private static final String LGSYNC_LDAP_BIND_PASSWORD = "ranger.usersync.ldap.ldapbindpassword";
    private static final String LGSYNC_LDAP_AUTHENTICATION_MECHANISM = "ranger.usersync.ldap.authentication.mechanism";
    private static final String DEFAULT_AUTHENTICATION_MECHANISM = "simple";
    private static final String LGSYNC_SEARCH_BASE = "ranger.usersync.ldap.searchBase";
    private static final String LGSYNC_USER_SEARCH_BASE = "ranger.usersync.ldap.user.searchbase";
    private static final String LGSYNC_USER_SEARCH_SCOPE = "ranger.usersync.ldap.user.searchscope";
    private static final String LGSYNC_USER_OBJECT_CLASS = "ranger.usersync.ldap.user.objectclass";
    private static final String DEFAULT_USER_OBJECT_CLASS = "person";
    private static final String LGSYNC_USER_SEARCH_FILTER = "ranger.usersync.ldap.user.searchfilter";
    private static final String LGSYNC_USER_NAME_ATTRIBUTE = "ranger.usersync.ldap.user.nameattribute";
    private static final String DEFAULT_USER_NAME_ATTRIBUTE = "cn";
    private static final String LGSYNC_USER_GROUP_NAME_ATTRIBUTE = "ranger.usersync.ldap.user.groupnameattribute";
    private static final String DEFAULT_USER_GROUP_NAME_ATTRIBUTE = "memberof,ismemberof";
    public static final String UGSYNC_NONE_CASE_CONVERSION_VALUE = "none";
    public static final String UGSYNC_LOWER_CASE_CONVERSION_VALUE = "lower";
    public static final String UGSYNC_UPPER_CASE_CONVERSION_VALUE = "upper";
    private static final String UGSYNC_USERNAME_CASE_CONVERSION_PARAM = "ranger.usersync.ldap.username.caseconversion";
    private static final String DEFAULT_UGSYNC_USERNAME_CASE_CONVERSION_VALUE = "none";
    private static final String UGSYNC_GROUPNAME_CASE_CONVERSION_PARAM = "ranger.usersync.ldap.groupname.caseconversion";
    private static final String DEFAULT_UGSYNC_GROUPNAME_CASE_CONVERSION_VALUE = "none";
    private static final String DEFAULT_USER_GROUP_TEXTFILE_DELIMITER = ",";
    private static final String LGSYNC_PAGED_RESULTS_ENABLED = "ranger.usersync.pagedresultsenabled";
    private static final boolean DEFAULT_LGSYNC_PAGED_RESULTS_ENABLED = true;
    private static final String LGSYNC_PAGED_RESULTS_SIZE = "ranger.usersync.pagedresultssize";
    private static final int DEFAULT_LGSYNC_PAGED_RESULTS_SIZE = 500;
    private static final String LGSYNC_GROUP_SEARCH_ENABLED = "ranger.usersync.group.searchenabled";
    private static final boolean DEFAULT_LGSYNC_GROUP_SEARCH_ENABLED = false;
    private static final String LGSYNC_GROUP_SEARCH_FIRST_ENABLED = "ranger.usersync.group.search.first.enabled";
    private static final boolean DEFAULT_LGSYNC_GROUP_SEARCH_FIRST_ENABLED = false;
    private static final String LGSYNC_USER_SEARCH_ENABLED = "ranger.usersync.user.searchenabled";
    private static final boolean DEFAULT_LGSYNC_USER_SEARCH_ENABLED = false;
    private static final String LGSYNC_GROUP_USER_MAP_SYNC_ENABLED = "ranger.usersync.group.usermapsyncenabled";
    private static final boolean DEFAULT_LGSYNC_GROUP_USER_MAP_SYNC_ENABLED = false;
    private static final String LGSYNC_GROUP_SEARCH_BASE = "ranger.usersync.group.searchbase";
    private static final String LGSYNC_GROUP_SEARCH_SCOPE = "ranger.usersync.group.searchscope";
    private static final String LGSYNC_GROUP_OBJECT_CLASS = "ranger.usersync.group.objectclass";
    private static final String DEFAULT_LGSYNC_GROUP_OBJECT_CLASS = "groupofnames";
    private static final String LGSYNC_GROUP_SEARCH_FILTER = "ranger.usersync.group.searchfilter";
    private static final String LGSYNC_GROUP_NAME_ATTRIBUTE = "ranger.usersync.group.nameattribute";
    private static final String DEFAULT_LGSYNC_GROUP_NAME_ATTRIBUTE = "cn";
    private static final String LGSYNC_GROUP_MEMBER_ATTRIBUTE_NAME = "ranger.usersync.group.memberattributename";
    private static final String DEFAULT_LGSYNC_GROUP_MEMBER_ATTRIBUTE_NAME = "member";
    private static final String UGSYNC_UPDATE_MILLIS_MIN = "ranger.usersync.unix.updatemillismin";
    private static final long DEFAULT_UGSYNC_UPDATE_MILLIS_MIN = 60000L;
    private static final String UGSYNC_UNIX_BACKEND = "ranger.usersync.unix.backend";
    private static final String DEFAULT_UGSYNC_UNIX_BACKEND = "passwd";
    private static final String UGSYNC_GROUP_ENUMERATE_ENABLED = "ranger.usersync.group.enumerate";
    private static final String UGSYNC_GROUP_ENUMERATE_GROUPS = "ranger.usersync.group.enumerategroup";
    private static final String SYNC_POLICY_MGR_KEYSTORE = "ranger.usersync.policymgr.keystore";
    private static final String SYNC_POLICY_MGR_ALIAS = "ranger.usersync.policymgr.alias";
    private static final String SYNC_POLICY_MGR_PASSWORD = "ranger.usersync.policymgr.password";
    private static final String SYNC_POLICY_MGR_USERNAME = "ranger.usersync.policymgr.username";
    private static final String DEFAULT_POLICYMGR_USERNAME = "rangerusersync";
    private static final String DEFAULT_POLICYMGR_PASSWORD = "rangerusersync";
    private static final String SYNC_SOURCE = "ranger.usersync.sync.source";
    private static final String LGSYNC_REFERRAL = "ranger.usersync.ldap.referral";
    private static final String DEFAULT_LGSYNC_REFERRAL = "ignore";
    public static final String SYNC_MAPPING_USERNAME = "ranger.usersync.mapping.username.regex";
    public static final String SYNC_MAPPING_GROUPNAME = "ranger.usersync.mapping.groupname.regex";
    private static final String SYNC_MAPPING_USERNAME_HANDLER = "ranger.usersync.mapping.username.handler";
    private static final String DEFAULT_SYNC_MAPPING_USERNAME_HANDLER = "org.apache.ranger.usergroupsync.RegEx";
    private static final String SYNC_MAPPING_GROUPNAME_HANDLER = "ranger.usersync.mapping.groupname.handler";
    private static final String DEFAULT_SYNC_MAPPING_GROUPNAME_HANDLER = "org.apache.ranger.usergroupsync.RegEx";
    private Properties prop = new Properties();
    private static volatile UserGroupSyncConfig me = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UserGroupSyncConfig getInstance() {
        UserGroupSyncConfig result = me;
        if (result != null) return result;
        Class<UserGroupSyncConfig> clazz = UserGroupSyncConfig.class;
        synchronized (UserGroupSyncConfig.class) {
            result = me;
            if (result != null) return result;
            me = result = new UserGroupSyncConfig();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return result;
        }
    }

    private UserGroupSyncConfig() {
        this.init();
    }

    private void init() {
        this.readConfigFile(CORE_SITE_CONFIG_FILE);
        this.readConfigFile(CONFIG_FILE);
        this.readConfigFile(DEFAULT_CONFIG_FILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readConfigFile(String fileName) {
        block13: {
            try {
                InputStream in = this.getFileInputStream(fileName);
                if (in == null) break block13;
                try {
                    DocumentBuilderFactory xmlDocumentBuilderFactory = DocumentBuilderFactory.newInstance();
                    xmlDocumentBuilderFactory.setIgnoringComments(true);
                    xmlDocumentBuilderFactory.setNamespaceAware(true);
                    DocumentBuilder xmlDocumentBuilder = xmlDocumentBuilderFactory.newDocumentBuilder();
                    Document xmlDocument = xmlDocumentBuilder.parse(in);
                    xmlDocument.getDocumentElement().normalize();
                    NodeList nList = xmlDocument.getElementsByTagName("property");
                    for (int temp = 0; temp < nList.getLength(); ++temp) {
                        Node nNode = nList.item(temp);
                        if (nNode.getNodeType() != 1) continue;
                        Element eElement = (Element)nNode;
                        String propertyName = "";
                        String propertyValue = "";
                        if (eElement.getElementsByTagName("name").item(0) != null) {
                            propertyName = eElement.getElementsByTagName("name").item(0).getTextContent().trim();
                        }
                        if (eElement.getElementsByTagName("value").item(0) != null) {
                            propertyValue = eElement.getElementsByTagName("value").item(0).getTextContent().trim();
                        }
                        if (this.prop.get(propertyName) != null) {
                            this.prop.remove(propertyName);
                        }
                        this.prop.put(propertyName, propertyValue);
                    }
                }
                finally {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (Throwable e) {
                throw new RuntimeException("Unable to load configuration file [ranger-ugsync-site.xml]", e);
            }
        }
    }

    private InputStream getFileInputStream(String path) throws FileNotFoundException {
        InputStream ret = null;
        File f = new File(path);
        if (f.exists()) {
            ret = new FileInputStream(f);
        } else {
            ret = this.getClass().getResourceAsStream(path);
            if (ret == null && !path.startsWith("/")) {
                ret = this.getClass().getResourceAsStream("/" + path);
            }
            if (ret == null && (ret = ClassLoader.getSystemClassLoader().getResourceAsStream(path)) == null && !path.startsWith("/")) {
                ret = ClassLoader.getSystemResourceAsStream("/" + path);
            }
        }
        return ret;
    }

    public String getUserSyncFileSource() {
        String val = this.prop.getProperty(UGSYNC_SOURCE_FILE_PROC);
        return val;
    }

    public String getUserSyncFileSourceDelimiter() {
        String val = this.prop.getProperty(UGSYNC_SOURCE_FILE_DELIMITER);
        if (val == null) {
            val = this.prop.getProperty(UGSYNC_SOURCE_FILE_DELIMITERER);
        }
        if (val == null) {
            val = DEFAULT_USER_GROUP_TEXTFILE_DELIMITER;
        }
        return val;
    }

    public String getUnixBackend() {
        String val = this.prop.getProperty(UGSYNC_UNIX_BACKEND);
        if (val == null) {
            val = DEFAULT_UGSYNC_UNIX_BACKEND;
        }
        return val;
    }

    public boolean isUserSyncEnabled() {
        String val = this.prop.getProperty(UGSYNC_ENABLED_PROP);
        return val != null && val.trim().equalsIgnoreCase("true");
    }

    public String getEnumerateGroups() {
        return this.prop.getProperty(UGSYNC_GROUP_ENUMERATE_GROUPS);
    }

    public boolean isGroupEnumerateEnabled() {
        String val = this.prop.getProperty(UGSYNC_GROUP_ENUMERATE_ENABLED);
        return val != null && val.trim().equalsIgnoreCase("true");
    }

    public boolean isMockRunEnabled() {
        String val = this.prop.getProperty(UGSYNC_MOCK_RUN_PROP);
        return val != null && val.trim().equalsIgnoreCase("true");
    }

    public String getPolicyManagerBaseURL() {
        return this.prop.getProperty(UGSYNC_PM_URL_PROP);
    }

    public String getMinUserId() {
        return this.prop.getProperty(UGSYNC_MIN_USERID_PROP);
    }

    public String getMinGroupId() {
        String mgid = this.prop.getProperty(UGSYNC_MIN_GROUPID_PROP);
        if (mgid == null) {
            mgid = DEFAULT_UGSYNC_MIN_GROUPID;
        }
        return mgid;
    }

    public String getMaxRecordsPerAPICall() {
        return this.prop.getProperty(UGSYNC_MAX_RECORDS_PER_API_CALL_PROP);
    }

    public String getSSLKeyStorePath() {
        return this.prop.getProperty(SSL_KEYSTORE_PATH_PARAM);
    }

    public String getSSLKeyStorePathPassword() {
        return this.prop.getProperty(SSL_KEYSTORE_PATH_PASSWORD_PARAM);
    }

    public String getSSLTrustStorePath() {
        return this.prop.getProperty(SSL_TRUSTSTORE_PATH_PARAM);
    }

    public String getSSLTrustStorePathPassword() {
        return this.prop.getProperty(SSL_TRUSTSTORE_PATH_PASSWORD_PARAM);
    }

    public long getUpdateMillisMin() {
        String val = this.prop.getProperty(UGSYNC_UPDATE_MILLIS_MIN);
        if (val == null) {
            return 60000L;
        }
        long ret = Long.parseLong(val);
        if (ret < 60000L) {
            return 60000L;
        }
        return ret;
    }

    public long getSleepTimeInMillisBetweenCycle() throws Throwable {
        long min_interval;
        String val = this.prop.getProperty(UGSYNC_SLEEP_TIME_IN_MILLIS_BETWEEN_CYCLE_PARAM);
        if (val == null) {
            if (LGSYNC_SOURCE_CLASS.equals(this.getUserGroupSource().getClass().getName())) {
                return 3600000L;
            }
            return 60000L;
        }
        long ret = Long.parseLong(val);
        if (ret < (min_interval = LGSYNC_SOURCE_CLASS.equals(this.getUserGroupSource().getClass().getName()) ? 3600000L : (UGSYNC_SOURCE_CLASS.equals(this.getUserGroupSource().getClass().getName()) ? 60000L : 60000L))) {
            LOG.info((Object)("Sleep Time Between Cycle can not be lower than [" + min_interval + "] millisec. resetting to min value."));
            ret = min_interval;
        }
        return ret;
    }

    public UserGroupSource getUserGroupSource() throws Throwable {
        String val = this.prop.getProperty(UGSYNC_SOURCE_CLASS_PARAM);
        String syncSource = null;
        syncSource = val == null || val.trim().isEmpty() ? this.getSyncSource() : val;
        String className = val;
        if (syncSource != null && syncSource.equalsIgnoreCase("UNIX")) {
            className = UGSYNC_SOURCE_CLASS;
        } else if (syncSource != null && syncSource.equalsIgnoreCase("LDAP")) {
            className = LGSYNC_SOURCE_CLASS;
        }
        Class<?> ugSourceClass = Class.forName(className);
        UserGroupSource ret = (UserGroupSource)ugSourceClass.newInstance();
        return ret;
    }

    public UserGroupSink getUserGroupSink() throws Throwable {
        String val = this.prop.getProperty(UGSYNC_SINK_CLASS_PARAM);
        if (val == null || val.trim().isEmpty()) {
            val = UGSYNC_SINK_CLASS;
        }
        Class<?> ugSinkClass = Class.forName(val);
        UserGroupSink ret = (UserGroupSink)ugSinkClass.newInstance();
        return ret;
    }

    public String getLdapUrl() throws Throwable {
        String val = this.prop.getProperty(LGSYNC_LDAP_URL);
        if (val == null || val.trim().isEmpty()) {
            throw new Exception("ranger.usersync.ldap.url for LdapGroupSync is not specified");
        }
        return val;
    }

    public String getLdapBindDn() throws Throwable {
        String val = this.prop.getProperty(LGSYNC_LDAP_BIND_DN);
        if (val == null || val.trim().isEmpty()) {
            throw new Exception("ranger.usersync.ldap.binddn for LdapGroupSync is not specified");
        }
        return val;
    }

    public String getLdapBindPassword() {
        if (this.prop == null) {
            return null;
        }
        if (this.prop.containsKey(LGSYNC_LDAP_BIND_KEYSTORE)) {
            String password;
            String path = this.prop.getProperty(LGSYNC_LDAP_BIND_KEYSTORE);
            String alias = LGSYNC_LDAP_BIND_ALIAS;
            if (!(path == null || alias == null || path.trim().isEmpty() || alias.trim().isEmpty() || (password = CredentialReader.getDecryptedString((String)path.trim(), (String)alias.trim())) == null || password.trim().isEmpty() || password.trim().equalsIgnoreCase("none"))) {
                this.prop.setProperty(LGSYNC_LDAP_BIND_PASSWORD, password);
            }
        }
        return this.prop.getProperty(LGSYNC_LDAP_BIND_PASSWORD);
    }

    public String getLdapAuthenticationMechanism() {
        String val = this.prop.getProperty(LGSYNC_LDAP_AUTHENTICATION_MECHANISM);
        if (val == null || val.trim().isEmpty()) {
            return DEFAULT_AUTHENTICATION_MECHANISM;
        }
        return val;
    }

    public String getUserSearchBase() throws Throwable {
        String val = this.prop.getProperty(LGSYNC_USER_SEARCH_BASE);
        if (val == null || val.trim().isEmpty()) {
            val = this.getSearchBase();
        }
        if (val == null || val.trim().isEmpty()) {
            throw new Exception("ranger.usersync.ldap.user.searchbase for LdapGroupSync is not specified");
        }
        return val;
    }

    public int getUserSearchScope() {
        String val = this.prop.getProperty(LGSYNC_USER_SEARCH_SCOPE);
        if (val == null || val.trim().isEmpty()) {
            return 2;
        }
        if ((val = val.trim().toLowerCase()).equals(DEFAULT_UGSYNC_MIN_GROUPID) || val.startsWith("base")) {
            return 0;
        }
        if (val.equals("1") || val.startsWith("one")) {
            return 1;
        }
        return 2;
    }

    public String getUserObjectClass() {
        String val = this.prop.getProperty(LGSYNC_USER_OBJECT_CLASS);
        if (val == null || val.trim().isEmpty()) {
            return DEFAULT_USER_OBJECT_CLASS;
        }
        return val;
    }

    public String getUserSearchFilter() {
        return this.prop.getProperty(LGSYNC_USER_SEARCH_FILTER);
    }

    public String getUserNameAttribute() {
        String val = this.prop.getProperty(LGSYNC_USER_NAME_ATTRIBUTE);
        if (val == null || val.trim().isEmpty()) {
            return "cn";
        }
        return val;
    }

    public String getUserGroupNameAttribute() {
        String val = this.prop.getProperty(LGSYNC_USER_GROUP_NAME_ATTRIBUTE);
        if (val == null || val.trim().isEmpty()) {
            return DEFAULT_USER_GROUP_NAME_ATTRIBUTE;
        }
        return val;
    }

    public Set<String> getUserGroupNameAttributeSet() {
        String uga = this.getUserGroupNameAttribute();
        StringTokenizer st = new StringTokenizer(uga, DEFAULT_USER_GROUP_TEXTFILE_DELIMITER);
        HashSet<String> userGroupNameAttributeSet = new HashSet<String>();
        while (st.hasMoreTokens()) {
            userGroupNameAttributeSet.add(st.nextToken().trim());
        }
        return userGroupNameAttributeSet;
    }

    public String getUserNameCaseConversion() {
        String ret = this.prop.getProperty(UGSYNC_USERNAME_CASE_CONVERSION_PARAM, "none");
        return ret.trim().toLowerCase();
    }

    public String getGroupNameCaseConversion() {
        String ret = this.prop.getProperty(UGSYNC_GROUPNAME_CASE_CONVERSION_PARAM, "none");
        return ret.trim().toLowerCase();
    }

    public String getSearchBase() {
        return this.prop.getProperty(LGSYNC_SEARCH_BASE);
    }

    public boolean isPagedResultsEnabled() {
        String val = this.prop.getProperty(LGSYNC_PAGED_RESULTS_ENABLED);
        boolean pagedResultsEnabled = val == null || val.trim().isEmpty() ? true : Boolean.valueOf(val);
        return pagedResultsEnabled;
    }

    public int getPagedResultsSize() {
        int pagedResultsSize = 500;
        String val = this.prop.getProperty(LGSYNC_PAGED_RESULTS_SIZE);
        pagedResultsSize = val == null || val.trim().isEmpty() ? 500 : Integer.parseInt(val);
        if (pagedResultsSize < 1) {
            pagedResultsSize = 500;
        }
        return pagedResultsSize;
    }

    public boolean isGroupSearchEnabled() {
        String val = this.prop.getProperty(LGSYNC_GROUP_SEARCH_ENABLED);
        boolean groupSearchEnabled = val == null || val.trim().isEmpty() ? false : Boolean.valueOf(val);
        return groupSearchEnabled;
    }

    public boolean isGroupSearchFirstEnabled() {
        String val = this.prop.getProperty(LGSYNC_GROUP_SEARCH_FIRST_ENABLED);
        boolean groupSearchFirstEnabled = val == null || val.trim().isEmpty() ? false : Boolean.valueOf(val);
        return groupSearchFirstEnabled;
    }

    public boolean isUserSearchEnabled() {
        String val = this.prop.getProperty(LGSYNC_USER_SEARCH_ENABLED);
        boolean userSearchEnabled = val == null || val.trim().isEmpty() ? false : Boolean.valueOf(val);
        return userSearchEnabled;
    }

    public boolean isGroupUserMapSyncEnabled() {
        String val = this.prop.getProperty(LGSYNC_GROUP_USER_MAP_SYNC_ENABLED);
        boolean groupUserMapSyncEnabled = val == null || val.trim().isEmpty() ? false : Boolean.valueOf(val);
        return groupUserMapSyncEnabled;
    }

    public String getGroupSearchBase() throws Throwable {
        String val = this.prop.getProperty(LGSYNC_GROUP_SEARCH_BASE);
        if (val == null || val.trim().isEmpty()) {
            val = this.getSearchBase();
        }
        if (val == null || val.trim().isEmpty()) {
            val = this.getUserSearchBase();
        }
        return val;
    }

    public int getGroupSearchScope() {
        String val = this.prop.getProperty(LGSYNC_GROUP_SEARCH_SCOPE);
        if (val == null || val.trim().isEmpty()) {
            return 2;
        }
        if ((val = val.trim().toLowerCase()).equals(DEFAULT_UGSYNC_MIN_GROUPID) || val.startsWith("base")) {
            return 0;
        }
        if (val.equals("1") || val.startsWith("one")) {
            return 1;
        }
        return 2;
    }

    public String getGroupObjectClass() {
        String val = this.prop.getProperty(LGSYNC_GROUP_OBJECT_CLASS);
        if (val == null || val.trim().isEmpty()) {
            return DEFAULT_LGSYNC_GROUP_OBJECT_CLASS;
        }
        return val;
    }

    public String getGroupSearchFilter() {
        return this.prop.getProperty(LGSYNC_GROUP_SEARCH_FILTER);
    }

    public String getUserGroupMemberAttributeName() {
        String val = this.prop.getProperty(LGSYNC_GROUP_MEMBER_ATTRIBUTE_NAME);
        if (val == null || val.trim().isEmpty()) {
            return DEFAULT_LGSYNC_GROUP_MEMBER_ATTRIBUTE_NAME;
        }
        return val;
    }

    public String getGroupNameAttribute() {
        String val = this.prop.getProperty(LGSYNC_GROUP_NAME_ATTRIBUTE);
        if (val == null || val.trim().isEmpty()) {
            return "cn";
        }
        return val;
    }

    public String getProperty(String aPropertyName) {
        return this.prop.getProperty(aPropertyName);
    }

    public String getProperty(String aPropertyName, String aDefaultValue) {
        return this.prop.getProperty(aPropertyName, aDefaultValue);
    }

    public String getPolicyMgrPassword() {
        String password = null;
        if (this.prop != null && this.prop.containsKey(SYNC_POLICY_MGR_KEYSTORE) && (password = this.prop.getProperty(SYNC_POLICY_MGR_PASSWORD)) != null && !password.isEmpty()) {
            return password;
        }
        if (this.prop != null && this.prop.containsKey(SYNC_POLICY_MGR_KEYSTORE) && this.prop.containsKey(SYNC_POLICY_MGR_ALIAS)) {
            String path = this.prop.getProperty(SYNC_POLICY_MGR_KEYSTORE);
            String alias = this.prop.getProperty(SYNC_POLICY_MGR_ALIAS, "policymgr.user.password");
            if (path != null && alias != null && !path.trim().isEmpty() && !alias.trim().isEmpty()) {
                try {
                    password = CredentialReader.getDecryptedString((String)path.trim(), (String)alias.trim());
                }
                catch (Exception ex) {
                    password = null;
                }
                if (password != null && !password.trim().isEmpty() && !password.trim().equalsIgnoreCase("none")) {
                    this.prop.setProperty(SYNC_POLICY_MGR_PASSWORD, password);
                    return password;
                }
            }
        }
        return null;
    }

    public String getPolicyMgrUserName() {
        String userName = null;
        if (this.prop != null && this.prop.containsKey(SYNC_POLICY_MGR_USERNAME) && (userName = this.prop.getProperty(SYNC_POLICY_MGR_USERNAME)) != null && !userName.isEmpty()) {
            return userName;
        }
        return null;
    }

    public String getDefaultPolicyMgrUserName() {
        return "rangerusersync";
    }

    public String getDefaultPolicyMgrPassword() {
        return "rangerusersync";
    }

    public String getSyncSource() {
        String syncSource = null;
        if (this.prop != null && this.prop.containsKey(SYNC_SOURCE)) {
            syncSource = this.prop.getProperty(SYNC_SOURCE);
            syncSource = syncSource == null || syncSource.trim().isEmpty() ? null : syncSource.trim();
        }
        return syncSource;
    }

    public String getContextReferral() {
        String referral = DEFAULT_LGSYNC_REFERRAL;
        if (this.prop != null && this.prop.containsKey(LGSYNC_REFERRAL)) {
            referral = this.prop.getProperty(LGSYNC_REFERRAL);
            referral = referral == null || referral.trim().isEmpty() ? DEFAULT_LGSYNC_REFERRAL : referral.trim().toLowerCase();
        }
        return referral;
    }

    public List<String> getAllRegexPatterns(String baseProperty) throws Throwable {
        ArrayList<String> regexPatterns = new ArrayList<String>();
        if (this.prop != null) {
            String baseRegex = this.prop.getProperty(baseProperty);
            if (baseRegex == null) {
                return regexPatterns;
            }
            regexPatterns.add(baseRegex);
            int i = 1;
            String nextRegex = this.prop.getProperty(baseProperty + "." + i);
            while (nextRegex != null) {
                regexPatterns.add(nextRegex);
                nextRegex = this.prop.getProperty(baseProperty + "." + ++i);
            }
        }
        return regexPatterns;
    }

    public String getUserSyncMappingUserNameHandler() {
        String val = this.prop.getProperty(SYNC_MAPPING_USERNAME_HANDLER);
        if (val == null) {
            val = "org.apache.ranger.usergroupsync.RegEx";
        }
        return val;
    }

    public String getUserSyncMappingGroupNameHandler() {
        String val = this.prop.getProperty(SYNC_MAPPING_GROUPNAME_HANDLER);
        if (val == null) {
            val = "org.apache.ranger.usergroupsync.RegEx";
        }
        return val;
    }

    public boolean isStartTlsEnabled() {
        String val = this.prop.getProperty(LGSYNC_LDAP_STARTTLS_ENABLED);
        boolean starttlsEnabled = val == null || val.trim().isEmpty() ? false : Boolean.valueOf(val);
        return starttlsEnabled;
    }

    public void setUserSearchFilter(String filter) {
        this.prop.setProperty(LGSYNC_USER_SEARCH_FILTER, filter);
    }

    public void setGroupSearchFilter(String filter) {
        this.prop.setProperty(LGSYNC_GROUP_SEARCH_FILTER, filter);
    }

    public void setGroupSearchEnabled(boolean groupSearchEnabled) {
        this.prop.setProperty(LGSYNC_GROUP_SEARCH_ENABLED, String.valueOf(groupSearchEnabled));
    }

    public void setPagedResultsEnabled(boolean pagedResultsEnabled) {
        this.prop.setProperty(LGSYNC_PAGED_RESULTS_ENABLED, String.valueOf(pagedResultsEnabled));
    }

    public void setProperty(String name, String value) {
        this.prop.setProperty(name, value);
    }

    public void setUserSearchBase(String userSearchBase) throws Throwable {
        this.prop.setProperty(LGSYNC_USER_SEARCH_BASE, userSearchBase);
    }

    public void setGroupSearchBase(String groupSearchBase) throws Throwable {
        this.prop.setProperty(LGSYNC_GROUP_SEARCH_BASE, groupSearchBase);
    }

    public void setGroupSearchFirstEnabled(boolean groupSearchFirstEnabled) {
        this.prop.setProperty(LGSYNC_GROUP_SEARCH_FIRST_ENABLED, String.valueOf(groupSearchFirstEnabled));
    }

    public void setUserSearchEnabled(boolean userSearchEnabled) {
        this.prop.setProperty(LGSYNC_USER_SEARCH_ENABLED, String.valueOf(userSearchEnabled));
    }

    public void setUserGroupMemberAttributeName(String groupMemberAttrName) {
        this.prop.setProperty(LGSYNC_GROUP_MEMBER_ATTRIBUTE_NAME, groupMemberAttrName);
    }

    public void setUserObjectClass(String userObjectClass) {
        this.prop.setProperty(LGSYNC_USER_OBJECT_CLASS, userObjectClass);
    }

    public void setGroupObjectClass(String groupObjectClass) {
        this.prop.setProperty(LGSYNC_GROUP_OBJECT_CLASS, groupObjectClass);
    }
}

