/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.ldapusersync.process;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.naming.InvalidNameException;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.PagedResultsControl;
import javax.naming.ldap.PagedResultsResponseControl;
import javax.naming.ldap.StartTlsRequest;
import javax.naming.ldap.StartTlsResponse;
import org.apache.log4j.Logger;
import org.apache.ranger.ldapusersync.process.CustomSSLSocketFactory;
import org.apache.ranger.ldapusersync.process.UserInfo;
import org.apache.ranger.usergroupsync.AbstractUserGroupSource;
import org.apache.ranger.usergroupsync.UserGroupSink;

public class LdapUserGroupBuilder
extends AbstractUserGroupSource {
    private static final Logger LOG = Logger.getLogger(LdapUserGroupBuilder.class);
    private static final int PAGE_SIZE = 500;
    private String ldapUrl;
    private String ldapBindDn;
    private String ldapBindPassword;
    private String ldapAuthenticationMechanism;
    private String ldapReferral;
    private String searchBase;
    private String[] userSearchBase;
    private String userNameAttribute;
    private int userSearchScope;
    private String userObjectClass;
    private String userSearchFilter;
    private String extendedUserSearchFilter;
    private SearchControls userSearchControls;
    private Set<String> userGroupNameAttributeSet;
    private boolean pagedResultsEnabled = true;
    private int pagedResultsSize = 500;
    private boolean groupSearchFirstEnabled = false;
    private boolean userSearchEnabled = false;
    private boolean groupSearchEnabled = true;
    private String[] groupSearchBase;
    private int groupSearchScope;
    private String groupObjectClass;
    private String groupSearchFilter;
    private String extendedGroupSearchFilter;
    private String extendedAllGroupsSearchFilter;
    private SearchControls groupSearchControls;
    private String groupMemberAttributeName;
    private String groupNameAttribute;
    private LdapContext ldapContext;
    StartTlsResponse tls;
    private boolean userNameCaseConversionFlag = false;
    private boolean groupNameCaseConversionFlag = false;
    private boolean userNameLowerCaseFlag = false;
    private boolean groupNameLowerCaseFlag = false;
    private boolean groupUserMapSyncEnabled = false;
    private Map<String, UserInfo> userGroupMap;

    public static void main(String[] args) throws Throwable {
        LdapUserGroupBuilder ugBuilder = new LdapUserGroupBuilder();
        ugBuilder.init();
    }

    public LdapUserGroupBuilder() {
        LOG.info((Object)"LdapUserGroupBuilder created");
        String userNameCaseConversion = this.config.getUserNameCaseConversion();
        if ("none".equalsIgnoreCase(userNameCaseConversion)) {
            this.userNameCaseConversionFlag = false;
        } else {
            this.userNameCaseConversionFlag = true;
            this.userNameLowerCaseFlag = "lower".equalsIgnoreCase(userNameCaseConversion);
        }
        String groupNameCaseConversion = this.config.getGroupNameCaseConversion();
        if ("none".equalsIgnoreCase(groupNameCaseConversion)) {
            this.groupNameCaseConversionFlag = false;
        } else {
            this.groupNameCaseConversionFlag = true;
            this.groupNameLowerCaseFlag = "lower".equalsIgnoreCase(groupNameCaseConversion);
        }
    }

    @Override
    public void init() throws Throwable {
        this.setConfig();
    }

    private void createLdapContext() throws Throwable {
        Properties env = new Properties();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", this.ldapUrl);
        if (this.ldapUrl.startsWith("ldaps") && this.config.getSSLTrustStorePath() != null && !this.config.getSSLTrustStorePath().trim().isEmpty()) {
            env.put("java.naming.ldap.factory.socket", "org.apache.ranger.ldapusersync.process.CustomSSLSocketFactory");
        }
        this.ldapContext = new InitialLdapContext(env, null);
        if (!this.ldapUrl.startsWith("ldaps") && this.config.isStartTlsEnabled()) {
            this.tls = (StartTlsResponse)this.ldapContext.extendedOperation(new StartTlsRequest());
            if (this.config.getSSLTrustStorePath() != null && !this.config.getSSLTrustStorePath().trim().isEmpty()) {
                this.tls.negotiate(CustomSSLSocketFactory.getDefault());
            } else {
                this.tls.negotiate();
            }
            LOG.info((Object)"Starting TLS session...");
        }
        this.ldapContext.addToEnvironment("java.naming.security.principal", this.ldapBindDn);
        this.ldapContext.addToEnvironment("java.naming.security.credentials", this.ldapBindPassword);
        this.ldapContext.addToEnvironment("java.naming.security.authentication", this.ldapAuthenticationMechanism);
        this.ldapContext.addToEnvironment("java.naming.referral", this.ldapReferral);
    }

    private void setConfig() throws Throwable {
        LOG.info((Object)"LdapUserGroupBuilder initialization started");
        this.groupSearchFirstEnabled = this.config.isGroupSearchFirstEnabled();
        this.userSearchEnabled = this.config.isUserSearchEnabled();
        this.groupSearchEnabled = this.config.isGroupSearchEnabled();
        this.ldapUrl = this.config.getLdapUrl();
        this.ldapBindDn = this.config.getLdapBindDn();
        this.ldapBindPassword = this.config.getLdapBindPassword();
        this.ldapAuthenticationMechanism = this.config.getLdapAuthenticationMechanism();
        this.ldapReferral = this.config.getContextReferral();
        this.searchBase = this.config.getSearchBase();
        this.userSearchBase = this.config.getUserSearchBase().split(";");
        this.userSearchScope = this.config.getUserSearchScope();
        this.userObjectClass = this.config.getUserObjectClass();
        this.userSearchFilter = this.config.getUserSearchFilter();
        this.extendedUserSearchFilter = "(objectclass=" + this.userObjectClass + ")";
        if (this.userSearchFilter != null && !this.userSearchFilter.trim().isEmpty()) {
            String customFilter = this.userSearchFilter.trim();
            if (!customFilter.startsWith("(")) {
                customFilter = "(" + customFilter + ")";
            }
            this.extendedUserSearchFilter = "(&" + this.extendedUserSearchFilter + customFilter + ")";
        }
        this.userNameAttribute = this.config.getUserNameAttribute();
        HashSet<String> userSearchAttributes = new HashSet<String>();
        userSearchAttributes.add(this.userNameAttribute);
        if (!this.groupSearchFirstEnabled && !this.groupSearchEnabled) {
            this.userGroupNameAttributeSet = this.config.getUserGroupNameAttributeSet();
            for (String useGroupNameAttribute : this.userGroupNameAttributeSet) {
                userSearchAttributes.add(useGroupNameAttribute);
            }
        }
        this.userSearchControls = new SearchControls();
        this.userSearchControls.setSearchScope(this.userSearchScope);
        this.userSearchControls.setReturningAttributes(userSearchAttributes.toArray(new String[userSearchAttributes.size()]));
        this.pagedResultsEnabled = this.config.isPagedResultsEnabled();
        this.pagedResultsSize = this.config.getPagedResultsSize();
        this.groupSearchBase = this.config.getGroupSearchBase().split(";");
        this.groupSearchScope = this.config.getGroupSearchScope();
        this.groupObjectClass = this.config.getGroupObjectClass();
        this.groupSearchFilter = this.config.getGroupSearchFilter();
        this.groupMemberAttributeName = this.config.getUserGroupMemberAttributeName();
        this.groupNameAttribute = this.config.getGroupNameAttribute();
        this.extendedGroupSearchFilter = "(objectclass=" + this.groupObjectClass + ")";
        if (this.groupSearchFilter != null && !this.groupSearchFilter.trim().isEmpty()) {
            String customFilter = this.groupSearchFilter.trim();
            if (!customFilter.startsWith("(")) {
                customFilter = "(" + customFilter + ")";
            }
            this.extendedGroupSearchFilter = this.extendedGroupSearchFilter + customFilter;
        }
        this.extendedAllGroupsSearchFilter = "(&" + this.extendedGroupSearchFilter + ")";
        if (!this.groupSearchFirstEnabled) {
            this.extendedGroupSearchFilter = "(&" + this.extendedGroupSearchFilter + "(|(" + this.groupMemberAttributeName + "={0})(" + this.groupMemberAttributeName + "={1})))";
        }
        this.groupUserMapSyncEnabled = this.config.isGroupUserMapSyncEnabled();
        this.groupSearchControls = new SearchControls();
        this.groupSearchControls.setSearchScope(this.groupSearchScope);
        HashSet<String> groupSearchAttributes = new HashSet<String>();
        groupSearchAttributes.add(this.groupNameAttribute);
        groupSearchAttributes.add(this.groupMemberAttributeName);
        this.groupSearchControls.setReturningAttributes(groupSearchAttributes.toArray(new String[groupSearchAttributes.size()]));
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("LdapUserGroupBuilder initialization completed with --  ldapUrl: " + this.ldapUrl + ",  ldapBindDn: " + this.ldapBindDn + ",  ldapBindPassword: ***** ,  ldapAuthenticationMechanism: " + this.ldapAuthenticationMechanism + ",  searchBase: " + this.searchBase + ",  userSearchBase: " + Arrays.toString(this.userSearchBase) + ",  userSearchScope: " + this.userSearchScope + ",  userObjectClass: " + this.userObjectClass + ",  userSearchFilter: " + this.userSearchFilter + ",  extendedUserSearchFilter: " + this.extendedUserSearchFilter + ",  userNameAttribute: " + this.userNameAttribute + ",  userSearchAttributes: " + userSearchAttributes + ",  userGroupNameAttributeSet: " + this.userGroupNameAttributeSet + ",  pagedResultsEnabled: " + this.pagedResultsEnabled + ",  pagedResultsSize: " + this.pagedResultsSize + ",  groupSearchEnabled: " + this.groupSearchEnabled + ",  groupSearchBase: " + Arrays.toString(this.groupSearchBase) + ",  groupSearchScope: " + this.groupSearchScope + ",  groupObjectClass: " + this.groupObjectClass + ",  groupSearchFilter: " + this.groupSearchFilter + ",  extendedGroupSearchFilter: " + this.extendedGroupSearchFilter + ",  extendedAllGroupsSearchFilter: " + this.extendedAllGroupsSearchFilter + ",  groupMemberAttributeName: " + this.groupMemberAttributeName + ",  groupNameAttribute: " + this.groupNameAttribute + ", groupSearchAttributes: " + groupSearchAttributes + ",  groupUserMapSyncEnabled: " + this.groupUserMapSyncEnabled + ", groupSearchFirstEnabled: " + this.groupSearchFirstEnabled + ", userSearchEnabled: " + this.userSearchEnabled + ",  ldapReferral: " + this.ldapReferral));
        }
    }

    private void closeLdapContext() throws Throwable {
        if (this.tls != null) {
            this.tls.close();
        }
        if (this.ldapContext != null) {
            this.ldapContext.close();
        }
    }

    @Override
    public boolean isChanged() {
        return true;
    }

    @Override
    public void updateSink(UserGroupSink sink) throws Throwable {
        LOG.info((Object)"LDAPUserGroupBuilder updateSink started");
        this.userGroupMap = new HashMap<String, UserInfo>();
        if (!this.groupSearchFirstEnabled) {
            LOG.info((Object)"Performing user search first");
            this.getUsers(sink);
            LOG.debug((Object)("Total No. of users saved = " + this.userGroupMap.size()));
            for (UserInfo userInfo : this.userGroupMap.values()) {
                String userName = userInfo.getUserName();
                if (this.groupSearchEnabled) {
                    LOG.info((Object)"groupSearch is enabled, would search for groups and compute memberships");
                    this.getGroups(sink, userInfo);
                }
                List<String> groupList = userInfo.getGroups();
                if (this.userNameCaseConversionFlag) {
                    userName = this.userNameLowerCaseFlag ? userName.toLowerCase() : userName.toUpperCase();
                }
                if (this.userNameRegExInst != null) {
                    userName = this.userNameRegExInst.transform(userName);
                }
                try {
                    sink.addOrUpdateUser(userName, groupList);
                }
                catch (Throwable t) {
                    LOG.error((Object)("sink.addOrUpdateUser failed with exception: " + t.getMessage() + ", for user: " + userName + ", groups: " + groupList));
                }
            }
        } else {
            LOG.info((Object)"Performing Group search first");
            this.getGroups(sink, null);
            if (this.userSearchEnabled) {
                LOG.info((Object)"User search is enabled and hence computing user membership.");
                this.getUsers(sink);
            } else {
                LOG.info((Object)"User search is disabled and hence using the group member attribute for username.");
                for (UserInfo userInfo : this.userGroupMap.values()) {
                    String userName = LdapUserGroupBuilder.getShortUserName(userInfo.getUserFullName());
                    List<String> groupList = userInfo.getGroups();
                    if (this.userNameCaseConversionFlag) {
                        userName = this.userNameLowerCaseFlag ? userName.toLowerCase() : userName.toUpperCase();
                    }
                    if (this.userNameRegExInst != null) {
                        userName = this.userNameRegExInst.transform(userName);
                    }
                    try {
                        sink.addOrUpdateUser(userName, groupList);
                    }
                    catch (Throwable t) {
                        LOG.error((Object)("sink.addOrUpdateUser failed with exception: " + t.getMessage() + ", for user: " + userName + ", groups: " + groupList));
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getUsers(UserGroupSink sink) throws Throwable {
        NamingEnumeration<SearchResult> userSearchResultEnum = null;
        NamingEnumeration groupSearchResultEnum = null;
        try {
            this.createLdapContext();
            if (this.pagedResultsEnabled) {
                this.ldapContext.setRequestControls(new Control[]{new PagedResultsControl(this.pagedResultsSize, false)});
            }
            for (int ou = 0; ou < this.userSearchBase.length; ++ou) {
                byte[] cookie = null;
                int counter = 0;
                try {
                    do {
                        userSearchResultEnum = this.ldapContext.search(this.userSearchBase[ou], this.extendedUserSearchFilter, this.userSearchControls);
                        while (userSearchResultEnum.hasMore()) {
                            List<String> groupList;
                            UserInfo userInfo;
                            SearchResult userEntry = userSearchResultEnum.next();
                            if (userEntry == null) {
                                if (!LOG.isInfoEnabled()) continue;
                                LOG.info((Object)"userEntry null, skipping sync for the entry");
                                continue;
                            }
                            Attributes attributes = userEntry.getAttributes();
                            if (attributes == null) {
                                if (!LOG.isInfoEnabled()) continue;
                                LOG.info((Object)("attributes  missing for entry " + userEntry.getNameInNamespace() + ", skipping sync"));
                                continue;
                            }
                            Attribute userNameAttr = attributes.get(this.userNameAttribute);
                            if (userNameAttr == null) {
                                if (!LOG.isInfoEnabled()) continue;
                                LOG.info((Object)(this.userNameAttribute + " missing for entry " + userEntry.getNameInNamespace() + ", skipping sync"));
                                continue;
                            }
                            String userName = (String)userNameAttr.get();
                            if (userName == null || userName.trim().isEmpty()) {
                                if (!LOG.isInfoEnabled()) continue;
                                LOG.info((Object)(this.userNameAttribute + " empty for entry " + userEntry.getNameInNamespace() + ", skipping sync"));
                                continue;
                            }
                            if (!this.groupSearchFirstEnabled) {
                                userInfo = new UserInfo(userName, userEntry.getNameInNamespace());
                                HashSet<String> groups = new HashSet<String>();
                                if (!this.groupSearchEnabled) {
                                    for (String useGroupNameAttribute : this.userGroupNameAttributeSet) {
                                        Attribute userGroupfAttribute = userEntry.getAttributes().get(useGroupNameAttribute);
                                        if (userGroupfAttribute == null) continue;
                                        NamingEnumeration<?> groupEnum = userGroupfAttribute.getAll();
                                        while (groupEnum.hasMore()) {
                                            String gName = LdapUserGroupBuilder.getShortGroupName((String)groupEnum.next());
                                            if (this.groupNameCaseConversionFlag) {
                                                gName = this.groupNameLowerCaseFlag ? gName.toLowerCase() : gName.toUpperCase();
                                            }
                                            if (this.groupNameRegExInst != null) {
                                                gName = this.groupNameRegExInst.transform(gName);
                                            }
                                            groups.add(gName);
                                        }
                                    }
                                }
                                userInfo.addGroups(groups);
                                if (this.userGroupMap.containsKey(userName)) {
                                    LOG.warn((Object)("user object with username " + userName + " already exists and is replaced with the latest user object."));
                                }
                                this.userGroupMap.put(userName, userInfo);
                                groupList = userInfo.getGroups();
                                if (++counter <= 2000) {
                                    if (LOG.isInfoEnabled()) {
                                        LOG.info((Object)("Updating user count: " + counter + ", userName: " + userName + ", groupList: " + groupList));
                                    }
                                    if (counter != 2000) continue;
                                    LOG.info((Object)"===> 2000 user records have been synchronized so far. From now on, only a summary progress log will be written for every 100 users. To continue to see detailed log for every user, please enable Trace level logging. <===");
                                    continue;
                                }
                                if (LOG.isTraceEnabled()) {
                                    LOG.trace((Object)("Updating user count: " + counter + ", userName: " + userName + ", groupList: " + groupList));
                                    continue;
                                }
                                if (counter % 100 != 0) continue;
                                LOG.info((Object)("Synced " + counter + " users till now"));
                                continue;
                            }
                            String userFullName = userEntry.getNameInNamespace().toLowerCase();
                            LOG.debug((Object)("Chekcing if the user " + userFullName + " is part of the retrieved groups"));
                            userInfo = this.userGroupMap.get(userFullName);
                            if (userInfo == null) {
                                userInfo = this.userGroupMap.get(userName.toLowerCase());
                            }
                            if (userInfo == null) continue;
                            ++counter;
                            LOG.info((Object)("Updating username for " + userFullName + " with " + userName));
                            userInfo.updateUserName(userName);
                            groupList = userInfo.getGroups();
                            if (this.userNameCaseConversionFlag) {
                                userName = this.userNameLowerCaseFlag ? userName.toLowerCase() : userName.toUpperCase();
                            }
                            if (this.userNameRegExInst != null) {
                                userName = this.userNameRegExInst.transform(userName);
                            }
                            try {
                                sink.addOrUpdateUser(userName, groupList);
                            }
                            catch (Throwable t) {
                                LOG.error((Object)("sink.addOrUpdateUser failed with exception: " + t.getMessage() + ", for user: " + userName + ", groups: " + groupList));
                            }
                        }
                        Control[] controls = this.ldapContext.getResponseControls();
                        if (controls != null) {
                            for (int i = 0; i < controls.length; ++i) {
                                if (!(controls[i] instanceof PagedResultsResponseControl)) continue;
                                PagedResultsResponseControl prrc = (PagedResultsResponseControl)controls[i];
                                int total = prrc.getResultSize();
                                if (total != 0) {
                                    LOG.debug((Object)("END-OF-PAGE total : " + total));
                                } else {
                                    LOG.debug((Object)"END-OF-PAGE total : unknown");
                                }
                                cookie = prrc.getCookie();
                            }
                        } else {
                            LOG.debug((Object)"No controls were sent from the server");
                        }
                        if (!this.pagedResultsEnabled) continue;
                        this.ldapContext.setRequestControls(new Control[]{new PagedResultsControl(500, cookie, true)});
                    } while (cookie != null);
                    LOG.info((Object)("LDAPUserGroupBuilder.getUsers() completed with user count: " + counter));
                    continue;
                }
                catch (Throwable t) {
                    LOG.error((Object)("LDAPUserGroupBuilder.getUsers() failed with exception: " + t));
                    LOG.info((Object)("LDAPUserGroupBuilder.getUsers() user count: " + counter));
                }
            }
        }
        finally {
            if (userSearchResultEnum != null) {
                userSearchResultEnum.close();
            }
            if (groupSearchResultEnum != null) {
                groupSearchResultEnum.close();
            }
            this.closeLdapContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void getGroups(UserGroupSink sink, UserInfo userInfo) throws Throwable {
        NamingEnumeration<SearchResult> groupSearchResultEnum = null;
        try {
            this.createLdapContext();
            if (this.pagedResultsEnabled) {
                this.ldapContext.setRequestControls(new Control[]{new PagedResultsControl(this.pagedResultsSize, false)});
            }
            int ou = 0;
            while (ou < this.groupSearchBase.length) {
                byte[] cookie = null;
                int counter = 0;
                try {
                    do {
                        block30: {
                            Control[] controls;
                            if (!this.groupSearchFirstEnabled) {
                                if (userInfo == null) {
                                    LOG.error((Object)"No user information provided for group search!");
                                    return;
                                }
                                groupSearchResultEnum = this.ldapContext.search(this.groupSearchBase[ou], this.extendedGroupSearchFilter, new Object[]{userInfo.getUserFullName(), userInfo.getUserName()}, this.groupSearchControls);
                            } else {
                                groupSearchResultEnum = this.ldapContext.search(this.groupSearchBase[ou], this.extendedAllGroupsSearchFilter, this.groupSearchControls);
                            }
                            while (true) {
                                NamingEnumeration<?> userEnum;
                                int userCount;
                                String gName;
                                if (groupSearchResultEnum.hasMore()) {
                                    SearchResult groupEntry = groupSearchResultEnum.next();
                                    if (groupEntry == null) continue;
                                    ++counter;
                                    Attribute groupNameAttr = groupEntry.getAttributes().get(this.groupNameAttribute);
                                    if (groupNameAttr == null) {
                                        if (!LOG.isInfoEnabled()) continue;
                                        LOG.info((Object)(this.groupNameAttribute + " empty for entry " + groupEntry.getNameInNamespace() + ", skipping sync"));
                                        continue;
                                    }
                                    gName = (String)groupNameAttr.get();
                                    if (this.groupNameCaseConversionFlag) {
                                        gName = this.groupNameLowerCaseFlag ? gName.toLowerCase() : gName.toUpperCase();
                                    }
                                    if (this.groupNameRegExInst != null) {
                                        gName = this.groupNameRegExInst.transform(gName);
                                    }
                                    if (!this.groupSearchFirstEnabled) {
                                        if (LOG.isInfoEnabled()) {
                                            LOG.info((Object)("computed groups for user: " + userInfo.getUserName() + ", groups: " + gName));
                                        }
                                        userInfo.addGroup(gName);
                                        continue;
                                    }
                                    Attribute groupMemberAttr = groupEntry.getAttributes().get(this.groupMemberAttributeName);
                                    LOG.debug((Object)("Update Ranger admin with " + gName));
                                    sink.addOrUpdateGroup(gName);
                                    userCount = 0;
                                    if (groupMemberAttr == null || groupMemberAttr.size() <= 0) {
                                        LOG.info((Object)("No members available for " + gName));
                                        continue;
                                    }
                                    userEnum = groupMemberAttr.getAll();
                                } else {
                                    controls = this.ldapContext.getResponseControls();
                                    if (controls != null) {
                                        break;
                                    }
                                    LOG.debug((Object)"No controls were sent from the server");
                                    break block30;
                                }
                                while (userEnum.hasMore()) {
                                    String originalUserFullName = (String)userEnum.next();
                                    if (originalUserFullName == null || originalUserFullName.trim().isEmpty()) continue;
                                    String userFullName = originalUserFullName.toLowerCase();
                                    ++userCount;
                                    if (!this.userGroupMap.containsKey(userFullName)) {
                                        userInfo = new UserInfo(userFullName, originalUserFullName);
                                        this.userGroupMap.put(userFullName, userInfo);
                                    } else {
                                        userInfo = this.userGroupMap.get(userFullName);
                                    }
                                    LOG.info((Object)("Adding " + gName + " to user " + userInfo.getUserFullName()));
                                    userInfo.addGroup(gName);
                                }
                                LOG.info((Object)("No. of members in the group " + gName + " = " + userCount));
                            }
                            for (int i = 0; i < controls.length; ++i) {
                                if (!(controls[i] instanceof PagedResultsResponseControl)) continue;
                                PagedResultsResponseControl prrc = (PagedResultsResponseControl)controls[i];
                                int total = prrc.getResultSize();
                                if (total != 0) {
                                    LOG.debug((Object)("END-OF-PAGE total : " + total));
                                } else {
                                    LOG.debug((Object)"END-OF-PAGE total : unknown");
                                }
                                cookie = prrc.getCookie();
                            }
                        }
                        if (!this.pagedResultsEnabled) continue;
                        this.ldapContext.setRequestControls(new Control[]{new PagedResultsControl(500, cookie, true)});
                    } while (cookie != null);
                    LOG.info((Object)("LDAPUserGroupBuilder.getGroups() completed with group count: " + counter));
                }
                catch (Throwable t) {
                    LOG.error((Object)("LDAPUserGroupBuilder.getGroups() failed with exception: " + t));
                    LOG.info((Object)("LDAPUserGroupBuilder.getGroups() group count: " + counter));
                }
                ++ou;
            }
            return;
        }
        finally {
            if (groupSearchResultEnum != null) {
                groupSearchResultEnum.close();
            }
            this.closeLdapContext();
        }
    }

    private static String getShortGroupName(String longGroupName) throws InvalidNameException {
        if (longGroupName == null) {
            return null;
        }
        StringTokenizer stc = new StringTokenizer(longGroupName, ",");
        String firstToken = stc.nextToken();
        StringTokenizer ste = new StringTokenizer(firstToken, "=");
        String groupName = ste.nextToken();
        if (ste.hasMoreTokens()) {
            groupName = ste.nextToken();
        }
        groupName = groupName.trim();
        LOG.info((Object)("longGroupName: " + longGroupName + ", groupName: " + groupName));
        return groupName;
    }

    private static String getShortUserName(String longUserName) throws InvalidNameException {
        if (longUserName == null) {
            return null;
        }
        StringTokenizer stc = new StringTokenizer(longUserName, ",");
        String firstToken = stc.nextToken();
        StringTokenizer ste = new StringTokenizer(firstToken, "=");
        String userName = ste.nextToken();
        if (ste.hasMoreTokens()) {
            userName = ste.nextToken();
        }
        userName = userName.trim();
        LOG.info((Object)("longUserName: " + longUserName + ", userName: " + userName));
        return userName;
    }
}

