/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authentication;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.log4j.Logger;
import org.apache.ranger.authentication.PasswordValidator;
import org.apache.ranger.credentialapi.CredentialReader;
import org.apache.ranger.plugin.util.XMLUtils;
import org.apache.ranger.usergroupsync.UserGroupSync;

public class UnixAuthenticationService {
    private static final Logger LOG = Logger.getLogger(UnixAuthenticationService.class);
    private static final String serviceName = "UnixAuthenticationService";
    private static final String SSL_ALGORITHM = "TLS";
    private static final String REMOTE_LOGIN_AUTH_SERVICE_PORT_PARAM = "ranger.usersync.port";
    private static final String SSL_KEYSTORE_PATH_PARAM = "ranger.usersync.keystore.file";
    private static final String SSL_TRUSTSTORE_PATH_PARAM = "ranger.usersync.truststore.file";
    private static final String SSL_KEYSTORE_PATH_PASSWORD_ALIAS = "usersync.ssl.key.password";
    private static final String SSL_TRUSTSTORE_PATH_PASSWORD_ALIAS = "usersync.ssl.truststore.password";
    private static final String CRED_VALIDATOR_PROG = "ranger.usersync.passwordvalidator.path";
    private static final String ADMIN_USER_LIST_PARAM = "admin.users";
    private static final String ADMIN_ROLE_LIST_PARAM = "admin.roleNames";
    private static final String SSL_ENABLED_PARAM = "ranger.usersync.ssl";
    private static final String CREDSTORE_FILENAME_PARAM = "ranger.usersync.credstore.filename";
    private String keyStorePath;
    private List<String> enabledProtocolsList;
    private String keyStorePathPassword;
    private String trustStorePath;
    private String trustStorePathPassword;
    private List<String> adminUserList = new ArrayList<String>();
    private String adminRoleNames;
    private int portNum;
    private boolean SSLEnabled = false;
    private static boolean enableUnixAuth = false;
    private static final String[] UGSYNC_CONFIG_XML_FILES = new String[]{"ranger-ugsync-default.xml", "ranger-ugsync-site.xml"};

    public static void main(String[] args) {
        if (args.length > 0) {
            for (String s : args) {
                if (!"-enableUnixAuth".equalsIgnoreCase(s)) continue;
                enableUnixAuth = true;
                break;
            }
        }
        UnixAuthenticationService service = new UnixAuthenticationService();
        service.run();
    }

    public void run() {
        try {
            LOG.info((Object)"Starting User Sync Service!");
            this.startUnixUserGroupSyncProcess();
            Thread.sleep(5000L);
            if (enableUnixAuth) {
                LOG.info((Object)"Enabling Unix Auth Service!");
                this.init();
                this.startService();
            } else {
                LOG.info((Object)"Unix Auth Service Disabled!");
            }
        }
        catch (Throwable t) {
            LOG.error((Object)"ERROR: Service: UnixAuthenticationService", t);
        }
        finally {
            LOG.info((Object)"Service: UnixAuthenticationService - STOPPED.");
        }
    }

    private void startUnixUserGroupSyncProcess() {
        UserGroupSync syncProc = new UserGroupSync();
        Thread newSyncProcThread = new Thread((Runnable)syncProc);
        newSyncProcThread.setName("UnixUserSyncThread");
        newSyncProcThread.setDaemon(false);
        newSyncProcThread.start();
    }

    private void init() throws Throwable {
        String SSLEnabledProp;
        String adminUsers;
        Properties prop = new Properties();
        for (String fn : UGSYNC_CONFIG_XML_FILES) {
            XMLUtils.loadConfig((String)fn, (Map)prop);
        }
        String credStoreFileName = prop.getProperty(CREDSTORE_FILENAME_PARAM);
        this.keyStorePath = prop.getProperty(SSL_KEYSTORE_PATH_PARAM);
        if (credStoreFileName == null) {
            throw new RuntimeException("Credential file is not defined. param = [ranger.usersync.credstore.filename]");
        }
        File credFile = new File(credStoreFileName);
        if (!credFile.exists()) {
            throw new RuntimeException("Credential file [" + credStoreFileName + "]: does not exists.");
        }
        if (!credFile.canRead()) {
            throw new RuntimeException("Credential file [" + credStoreFileName + "]: can not be read.");
        }
        this.keyStorePathPassword = CredentialReader.getDecryptedString((String)credStoreFileName, (String)SSL_KEYSTORE_PATH_PASSWORD_ALIAS);
        this.trustStorePathPassword = CredentialReader.getDecryptedString((String)credStoreFileName, (String)SSL_TRUSTSTORE_PATH_PASSWORD_ALIAS);
        this.trustStorePath = prop.getProperty(SSL_TRUSTSTORE_PATH_PARAM);
        this.portNum = Integer.parseInt(prop.getProperty(REMOTE_LOGIN_AUTH_SERVICE_PORT_PARAM));
        String validatorProg = prop.getProperty(CRED_VALIDATOR_PROG);
        if (validatorProg != null) {
            PasswordValidator.setValidatorProgram(validatorProg);
        }
        if ((adminUsers = prop.getProperty(ADMIN_USER_LIST_PARAM)) != null && adminUsers.trim().length() > 0) {
            for (String u : adminUsers.split(",")) {
                LOG.info((Object)("Adding Admin User:" + u.trim()));
                this.adminUserList.add(u.trim());
            }
            PasswordValidator.setAdminUserList(this.adminUserList);
        }
        this.adminRoleNames = prop.getProperty(ADMIN_ROLE_LIST_PARAM);
        if (this.adminRoleNames != null) {
            LOG.info((Object)("Adding Admin Group:" + this.adminRoleNames));
            PasswordValidator.setAdminRoleNames(this.adminRoleNames);
        }
        this.SSLEnabled = (SSLEnabledProp = prop.getProperty(SSL_ENABLED_PARAM)) != null && SSLEnabledProp.equalsIgnoreCase("true");
        String defaultEnabledProtocols = "SSLv2Hello, TLSv1, TLSv1.1, TLSv1.2";
        String enabledProtocols = prop.getProperty("ranger.usersync.https.ssl.enabled.protocols", defaultEnabledProtocols);
        this.enabledProtocolsList = new ArrayList<String>(Arrays.asList(enabledProtocols.toUpperCase().trim().split("\\s*,\\s*")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startService() throws Throwable {
        ServerSocket socket;
        SSLContext context = SSLContext.getInstance(SSL_ALGORITHM);
        KeyManager[] km = null;
        if (this.keyStorePath != null && !this.keyStorePath.isEmpty()) {
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            InputStream in = null;
            in = this.getFileInputStream(this.keyStorePath);
            try {
                if (this.keyStorePathPassword == null) {
                    this.keyStorePathPassword = "";
                }
                ks.load(in, this.keyStorePathPassword.toCharArray());
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(ks, this.keyStorePathPassword.toCharArray());
            km = kmf.getKeyManagers();
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        KeyStore trustStoreKeyStore = null;
        if (this.trustStorePath != null && !this.trustStorePath.isEmpty()) {
            trustStoreKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            InputStream in = null;
            in = this.getFileInputStream(this.trustStorePath);
            try {
                if (this.trustStorePathPassword == null) {
                    this.trustStorePathPassword = "";
                }
                trustStoreKeyStore.load(in, this.trustStorePathPassword.toCharArray());
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        trustManagerFactory.init(trustStoreKeyStore);
        TrustManager[] tm = trustManagerFactory.getTrustManagers();
        SecureRandom random = new SecureRandom();
        context.init(km, tm, random);
        SSLServerSocketFactory sf = context.getServerSocketFactory();
        ServerSocket serverSocket = socket = this.SSLEnabled ? sf.createServerSocket(this.portNum) : new ServerSocket(this.portNum);
        if (this.SSLEnabled) {
            SSLServerSocket secureSocket = (SSLServerSocket)socket;
            String[] protocols = secureSocket.getEnabledProtocols();
            HashSet<String> allowedProtocols = new HashSet<String>();
            for (String ep : protocols) {
                if (this.enabledProtocolsList.contains(ep.toUpperCase())) {
                    LOG.info((Object)("Enabling Protocol: [" + ep + "]"));
                    allowedProtocols.add(ep);
                    continue;
                }
                LOG.info((Object)("Disabling Protocol: [" + ep + "]"));
            }
            if (!allowedProtocols.isEmpty()) {
                secureSocket.setEnabledProtocols(allowedProtocols.toArray(new String[0]));
            }
        }
        Socket client = null;
        try {
            while ((client = socket.accept()) != null) {
                Thread clientValidatorThread = new Thread(new PasswordValidator(client));
                clientValidatorThread.start();
            }
        }
        catch (IOException e) {
            socket.close();
            throw e;
        }
    }

    private InputStream getFileInputStream(String path) throws FileNotFoundException {
        InputStream ret = null;
        File f = new File(path);
        if (f.exists()) {
            ret = new FileInputStream(f);
        } else {
            ret = this.getClass().getResourceAsStream(path);
            if (ret == null) {
                ret = this.getClass().getResourceAsStream(File.separator + path);
            }
        }
        return ret;
    }
}

