/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.storm.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.io.IOException;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.security.KrbPasswordSaverLoginModule;
import org.apache.hadoop.security.SecureClientLogin;
import org.apache.hadoop.security.authentication.util.KerberosUtil;
import org.apache.log4j.Logger;
import org.apache.ranger.plugin.client.BaseClient;
import org.apache.ranger.plugin.client.HadoopException;
import org.apache.ranger.plugin.util.PasswordUtils;
import org.apache.ranger.services.storm.client.json.model.Topology;
import org.apache.ranger.services.storm.client.json.model.TopologyListResponse;

public class StormClient {
    private static final Logger LOG = Logger.getLogger(StormClient.class);
    private static final String EXPECTED_MIME_TYPE = "application/json";
    private static final String TOPOLOGY_LIST_API_ENDPOINT = "/api/v1/topology/summary";
    private static final String errMessage = " You can still save the repository and start creating policies, but you would not be able to use autocomplete for resource names. Check ranger_admin.log for more info.";
    String stormUIUrl;
    String userName;
    String password;
    String lookupPrincipal;
    String lookupKeytab;
    String nameRules;

    public StormClient(String aStormUIUrl, String aUserName, String aPassword, String lookupPrincipal, String lookupKeytab, String nameRules) {
        this.stormUIUrl = aStormUIUrl;
        this.userName = aUserName;
        this.password = aPassword;
        this.lookupPrincipal = lookupPrincipal;
        this.lookupKeytab = lookupKeytab;
        this.nameRules = nameRules;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Storm Client is build with url [" + aStormUIUrl + "] user: [" + aUserName + "], password: []"));
        }
    }

    public List<String> getTopologyList(final String topologyNameMatching, final List<String> stormTopologyList) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting Storm topology list for topologyNameMatching : " + topologyNameMatching));
        }
        PrivilegedAction<ArrayList<String>> topologyListGetter = new PrivilegedAction<ArrayList<String>>(){

            @Override
            public ArrayList<String> run() {
                ArrayList<String> lret;
                block20: {
                    if (StormClient.this.stormUIUrl == null || StormClient.this.stormUIUrl.trim().isEmpty()) {
                        return null;
                    }
                    String[] stormUIUrls = StormClient.this.stormUIUrl.trim().split("[,;]");
                    if (stormUIUrls == null || stormUIUrls.length == 0) {
                        return null;
                    }
                    Client client = Client.create();
                    ClientResponse response = null;
                    for (String currentUrl : stormUIUrls) {
                        if (currentUrl == null || currentUrl.trim().isEmpty()) continue;
                        String url = currentUrl.trim() + StormClient.TOPOLOGY_LIST_API_ENDPOINT;
                        try {
                            response = this.getTopologyResponse(url, client);
                            if (response == null) continue;
                            if (response.getStatus() == 200) break;
                            response.close();
                        }
                        catch (Throwable t) {
                            String msgDesc = "Exception while getting topology list. URL : " + url;
                            LOG.error((Object)msgDesc, t);
                        }
                    }
                    lret = new ArrayList<String>();
                    try {
                        if (response != null) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("getTopologyList():response.getStatus()= " + response.getStatus()));
                            }
                            if (response.getStatus() == 200) {
                                String jsonString = (String)response.getEntity(String.class);
                                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                                TopologyListResponse topologyListResponse = (TopologyListResponse)gson.fromJson(jsonString, TopologyListResponse.class);
                                if (topologyListResponse != null && topologyListResponse.getTopologyList() != null) {
                                    for (Topology topology : topologyListResponse.getTopologyList()) {
                                        String topologyName = topology.getName();
                                        if (stormTopologyList != null && stormTopologyList.contains(topologyName)) continue;
                                        if (LOG.isDebugEnabled()) {
                                            LOG.debug((Object)("getTopologyList():Found topology " + topologyName));
                                            LOG.debug((Object)("getTopologyList():topology Name=[" + topology.getName() + "], topologyNameMatching=[" + topologyNameMatching + "], existingStormTopologyList=[" + stormTopologyList + "]"));
                                        }
                                        if (topologyName == null || topologyNameMatching != null && !topologyNameMatching.isEmpty() && !FilenameUtils.wildcardMatch((String)topology.getName(), (String)(topologyNameMatching + "*"))) continue;
                                        if (LOG.isDebugEnabled()) {
                                            LOG.debug((Object)("getTopologyList():Adding topology " + topologyName));
                                        }
                                        lret.add(topologyName);
                                    }
                                }
                            }
                            break block20;
                        }
                        String msgDesc = "Unable to get a valid response for expected mime type : [application/json] URL : " + StormClient.this.stormUIUrl + " - got null response.";
                        LOG.error((Object)msgDesc);
                        HadoopException hdpException = new HadoopException(msgDesc);
                        hdpException.generateResponseDataMap(false, msgDesc, msgDesc + StormClient.errMessage, null, null);
                        throw hdpException;
                    }
                    catch (HadoopException he) {
                        throw he;
                    }
                    catch (Throwable t) {
                        String msgDesc = "Exception while getting Storm TopologyList. URL : " + StormClient.this.stormUIUrl;
                        HadoopException hdpException = new HadoopException(msgDesc, t);
                        LOG.error((Object)msgDesc, t);
                        hdpException.generateResponseDataMap(false, BaseClient.getMessage((Throwable)t), msgDesc + StormClient.errMessage, null, null);
                        throw hdpException;
                    }
                    finally {
                        if (response != null) {
                            response.close();
                        }
                        if (client != null) {
                            client.destroy();
                        }
                    }
                }
                return lret;
            }

            private ClientResponse getTopologyResponse(String url, Client client) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("getTopologyResponse():calling " + url));
                }
                WebResource webResource = client.resource(url);
                ClientResponse response = (ClientResponse)webResource.accept(new String[]{StormClient.EXPECTED_MIME_TYPE}).get(ClientResponse.class);
                if (response != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("getTopologyResponse():response.getStatus()= " + response.getStatus()));
                    }
                    if (response.getStatus() != 200) {
                        LOG.info((Object)("getTopologyResponse():response.getStatus()= " + response.getStatus() + " for URL " + url + ", failed to get topology list"));
                        String jsonString = (String)response.getEntity(String.class);
                        LOG.info((Object)jsonString);
                    }
                }
                return response;
            }
        };
        List ret = null;
        try {
            ret = StormClient.executeUnderKerberos(this.userName, this.password, this.lookupPrincipal, this.lookupKeytab, this.nameRules, topologyListGetter);
        }
        catch (IOException e) {
            LOG.error((Object)("Unable to get Topology list from [" + this.stormUIUrl + "]"), (Throwable)e);
        }
        return ret;
    }

    public static <T> T executeUnderKerberos(String userName, String password, String lookupPrincipal, String lookupKeytab, String nameRules, PrivilegedAction<T> action) throws IOException {
        T ret = null;
        Subject subject = null;
        LoginContext loginContext = null;
        try {
            Subject loginSubj = null;
            if (!StringUtils.isEmpty((String)lookupPrincipal) && !StringUtils.isEmpty((String)lookupKeytab)) {
                LOG.info((Object)"Init Lookup Login: security enabled, using lookupPrincipal/lookupKeytab");
                if (StringUtils.isEmpty((String)nameRules)) {
                    nameRules = "DEFAULT";
                }
                loginSubj = SecureClientLogin.loginUserFromKeytab((String)lookupPrincipal, (String)lookupKeytab, (String)nameRules);
            } else {
                subject = new Subject();
                LOG.debug((Object)("executeUnderKerberos():user=" + userName + ",pass="));
                LOG.debug((Object)"executeUnderKerberos():Creating config..");
                MySecureClientLoginConfiguration loginConf = new MySecureClientLoginConfiguration(userName, password);
                LOG.debug((Object)"executeUnderKerberos():Creating Context..");
                loginContext = new LoginContext("hadoop-keytab-kerberos", subject, null, loginConf);
                LOG.debug((Object)"executeUnderKerberos():Logging in..");
                loginContext.logout();
                loginContext.login();
                LOG.info((Object)"Init Login: using username/password");
                loginSubj = loginContext.getSubject();
            }
            if (loginSubj != null) {
                ret = Subject.doAs(loginSubj, action);
            }
        }
        catch (LoginException le) {
            String msgDesc = "executeUnderKerberos: Login failure using given configuration parameters, username : `" + userName + "`.";
            HadoopException hdpException = new HadoopException(msgDesc, (Throwable)le);
            LOG.error((Object)msgDesc, (Throwable)le);
            hdpException.generateResponseDataMap(false, BaseClient.getMessage((Throwable)le), msgDesc + errMessage, null, null);
            throw hdpException;
        }
        catch (SecurityException se) {
            String msgDesc = "executeUnderKerberos: Exception while getting Storm TopologyList.";
            HadoopException hdpException = new HadoopException(msgDesc, (Throwable)se);
            LOG.error((Object)msgDesc, (Throwable)se);
            hdpException.generateResponseDataMap(false, BaseClient.getMessage((Throwable)se), msgDesc + errMessage, null, null);
            throw hdpException;
        }
        finally {
            if (loginContext != null && subject != null) {
                try {
                    loginContext.logout();
                }
                catch (LoginException e) {
                    throw new IOException("logout failure", e);
                }
            }
        }
        return ret;
    }

    public static Map<String, Object> connectionTest(String serviceName, Map<String, String> configs) {
        String errMsg = errMessage;
        boolean connectivityStatus = false;
        HashMap<String, Object> responseData = new HashMap<String, Object>();
        StormClient stormClient = StormClient.getStormClient(serviceName, configs);
        List<String> strList = StormClient.getStormResources(stormClient, "", null);
        if (strList != null) {
            connectivityStatus = true;
        }
        if (connectivityStatus) {
            String successMsg = "ConnectionTest Successful";
            BaseClient.generateResponseDataMap((boolean)connectivityStatus, (String)successMsg, (String)successMsg, null, null, responseData);
        } else {
            String failureMsg = "Unable to retrieve any topologies using given parameters.";
            BaseClient.generateResponseDataMap((boolean)connectivityStatus, (String)failureMsg, (String)(failureMsg + errMsg), null, null, responseData);
        }
        return responseData;
    }

    public static StormClient getStormClient(String serviceName, Map<String, String> configs) {
        StormClient stormClient = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting StormClient for datasource: " + serviceName));
            LOG.debug((Object)("configMap: " + configs));
        }
        String errMsg = errMessage;
        if (configs == null || configs.isEmpty()) {
            String msgDesc = "Could not connect as Connection ConfigMap is empty.";
            LOG.error((Object)msgDesc);
            HadoopException hdpException = new HadoopException(msgDesc);
            hdpException.generateResponseDataMap(false, msgDesc, msgDesc + errMsg, null, null);
            throw hdpException;
        }
        String stormUrl = configs.get("nimbus.url");
        String stormAdminUser = configs.get("username");
        String stormAdminPassword = configs.get("password");
        String lookupPrincipal = configs.get("lookupprincipal");
        String lookupKeytab = configs.get("lookupkeytab");
        String nameRules = configs.get("namerules");
        stormClient = new StormClient(stormUrl, stormAdminUser, stormAdminPassword, lookupPrincipal, lookupKeytab, nameRules);
        return stormClient;
    }

    public static List<String> getStormResources(StormClient stormClient, String topologyName, List<String> stormTopologyList) {
        List<String> resultList = new ArrayList<String>();
        String errMsg = errMessage;
        try {
            String finalTopologyNameMatching;
            if (stormClient == null) {
                String msgDesc = "Unable to get Storm resources: StormClient is null.";
                LOG.error((Object)msgDesc);
                HadoopException hdpException = new HadoopException(msgDesc);
                hdpException.generateResponseDataMap(false, msgDesc, msgDesc + errMsg, null, null);
                throw hdpException;
            }
            if (topologyName != null && (resultList = stormClient.getTopologyList(finalTopologyNameMatching = topologyName.trim(), stormTopologyList)) != null) {
                LOG.debug((Object)("Returning list of " + resultList.size() + " topologies"));
            }
        }
        catch (HadoopException he) {
            throw he;
        }
        catch (Exception e) {
            String msgDesc = "getStormResources: Unable to get Storm resources.";
            LOG.error((Object)msgDesc, (Throwable)e);
            HadoopException hdpException = new HadoopException(msgDesc);
            hdpException.generateResponseDataMap(false, BaseClient.getMessage((Throwable)e), msgDesc + errMsg, null, null);
            throw hdpException;
        }
        return resultList;
    }

    private static class MySecureClientLoginConfiguration
    extends Configuration {
        private String userName;
        private String password;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        MySecureClientLoginConfiguration(String aUserName, String password) {
            this.userName = aUserName;
            String decryptedPwd = null;
            try {
                decryptedPwd = PasswordUtils.decryptPassword((String)password);
            }
            catch (Exception ex) {
                LOG.info((Object)"Password decryption failed; trying Storm connection with received password string");
                decryptedPwd = null;
            }
            finally {
                if (decryptedPwd == null) {
                    decryptedPwd = password;
                }
            }
            this.password = decryptedPwd;
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String appName) {
            HashMap<String, String> kerberosOptions = new HashMap<String, String>();
            kerberosOptions.put("principal", this.userName);
            kerberosOptions.put("debug", "true");
            kerberosOptions.put("useKeyTab", "false");
            kerberosOptions.put("javax.security.auth.login.name", this.userName);
            kerberosOptions.put("javax.security.auth.login.password", this.password);
            kerberosOptions.put("doNotPrompt", "false");
            kerberosOptions.put("useFirstPass", "true");
            kerberosOptions.put("tryFirstPass", "false");
            kerberosOptions.put("storeKey", "true");
            kerberosOptions.put("refreshKrb5Config", "true");
            AppConfigurationEntry KEYTAB_KERBEROS_LOGIN = null;
            AppConfigurationEntry KERBEROS_PWD_SAVER = null;
            try {
                KEYTAB_KERBEROS_LOGIN = new AppConfigurationEntry(KerberosUtil.getKrb5LoginModuleName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, kerberosOptions);
                KERBEROS_PWD_SAVER = new AppConfigurationEntry(KrbPasswordSaverLoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, kerberosOptions);
            }
            catch (IllegalArgumentException e) {
                String msgDesc = "executeUnderKerberos: Exception while getting Storm TopologyList.";
                HadoopException hdpException = new HadoopException(msgDesc, (Throwable)e);
                LOG.error((Object)msgDesc, (Throwable)e);
                hdpException.generateResponseDataMap(false, BaseClient.getMessage((Throwable)e), msgDesc + StormClient.errMessage, null, null);
                throw hdpException;
            }
            LOG.debug((Object)("getAppConfigurationEntry():" + (String)kerberosOptions.get("principal")));
            return new AppConfigurationEntry[]{KERBEROS_PWD_SAVER, KEYTAB_KERBEROS_LOGIN};
        }
    }
}

