/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.storm.authorizer;

import com.google.common.collect.Sets;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.ranger.audit.provider.MiscUtil;
import org.apache.ranger.authorization.storm.StormRangerPlugin;
import org.apache.ranger.authorization.utils.StringUtil;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.util.RangerPerfTracer;
import org.apache.storm.security.auth.IAuthorizer;
import org.apache.storm.security.auth.ReqContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerStormAuthorizer
implements IAuthorizer {
    private static final Logger LOG = LoggerFactory.getLogger(RangerStormAuthorizer.class);
    private static final Log PERF_STORMAUTH_REQUEST_LOG = RangerPerfTracer.getPerfLogger((String)"stormauth.request");
    private static final String STORM_CLIENT_JASS_CONFIG_SECTION = "StormClient";
    private static volatile StormRangerPlugin plugin = null;
    static final Set<String> noAuthzOperations = Sets.newHashSet((Object[])new String[]{"getNimbusConf", "getClusterInfo"});

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean permit(ReqContext aRequestContext, String aOperationName, Map aTopologyConfigMap) {
        RangerPerfTracer perf;
        String topologyName;
        boolean isAuditEnabled;
        boolean accessAllowed;
        block18: {
            accessAllowed = false;
            isAuditEnabled = false;
            topologyName = null;
            perf = null;
            try {
                if (RangerPerfTracer.isPerfTraceEnabled((Log)PERF_STORMAUTH_REQUEST_LOG)) {
                    perf = RangerPerfTracer.getPerfTracer((Log)PERF_STORMAUTH_REQUEST_LOG, (String)"RangerStormAuthorizer.permit()");
                }
                String string = topologyName = aTopologyConfigMap == null ? "" : (String)aTopologyConfigMap.get("topology.name");
                if (LOG.isDebugEnabled()) {
                    LOG.debug("[req " + aRequestContext.requestID() + "] Access  from: [" + aRequestContext.remoteAddress() + "] user: [" + aRequestContext.principal() + "], op:   [" + aOperationName + "],topology: [" + topologyName + "]");
                    if (aTopologyConfigMap != null) {
                        for (Object keyObj : aTopologyConfigMap.keySet()) {
                            Object valObj = aTopologyConfigMap.get(keyObj);
                            LOG.debug("TOPOLOGY CONFIG MAP [" + keyObj + "] => [" + valObj + "]");
                        }
                    } else {
                        LOG.debug("TOPOLOGY CONFIG MAP is passed as null.");
                    }
                }
                if (noAuthzOperations.contains(aOperationName)) {
                    accessAllowed = true;
                    break block18;
                }
                if (plugin == null) {
                    LOG.info("Ranger plugin not initialized yet! Skipping authorization;  allowedFlag => [" + accessAllowed + "], Audit Enabled:" + isAuditEnabled);
                    break block18;
                }
                String userName = null;
                String[] groups = null;
                Principal user = aRequestContext.principal();
                if (user != null && (userName = user.getName()) != null) {
                    UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)userName);
                    userName = ugi.getShortUserName();
                    groups = ugi.getGroupNames();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("User found from principal [" + user.getName() + "] => user:[" + userName + "], groups:[" + StringUtil.toString((String[])groups) + "]");
                    }
                }
                if (userName != null) {
                    String clientIp = aRequestContext.remoteAddress() == null ? null : aRequestContext.remoteAddress().getHostAddress();
                    String clusterName = plugin.getClusterName();
                    RangerAccessRequest accessRequest = plugin.buildAccessRequest(userName, groups, clientIp, topologyName, aOperationName, clusterName);
                    RangerAccessResult result = plugin.isAccessAllowed(accessRequest);
                    accessAllowed = result != null && result.getIsAllowed();
                    boolean bl = isAuditEnabled = result != null && result.getIsAudited();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("User found from principal [" + userName + "], groups [" + StringUtil.toString((String[])groups) + "]: verifying using [" + ((Object)((Object)plugin)).getClass().getName() + "], allowedFlag => [" + accessAllowed + "], Audit Enabled:" + isAuditEnabled);
                    }
                    break block18;
                }
                LOG.info("NULL User found from principal [" + user + "]: Skipping authorization;  allowedFlag => [" + accessAllowed + "], Audit Enabled:" + isAuditEnabled);
            }
            catch (Throwable t) {
                try {
                    LOG.error("RangerStormAuthorizer found this exception", t);
                }
                catch (Throwable throwable) {
                    RangerPerfTracer.log(perf);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("[req " + aRequestContext.requestID() + "] Access  from: [" + aRequestContext.remoteAddress() + "] user: [" + aRequestContext.principal() + "], op:   [" + aOperationName + "],topology: [" + topologyName + "] => returns [" + accessAllowed + "], Audit Enabled:" + isAuditEnabled);
                    }
                    throw throwable;
                }
                RangerPerfTracer.log((RangerPerfTracer)perf);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("[req " + aRequestContext.requestID() + "] Access  from: [" + aRequestContext.remoteAddress() + "] user: [" + aRequestContext.principal() + "], op:   [" + aOperationName + "],topology: [" + topologyName + "] => returns [" + accessAllowed + "], Audit Enabled:" + isAuditEnabled);
                }
            }
        }
        RangerPerfTracer.log((RangerPerfTracer)perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("[req " + aRequestContext.requestID() + "] Access  from: [" + aRequestContext.remoteAddress() + "] user: [" + aRequestContext.principal() + "], op:   [" + aOperationName + "],topology: [" + topologyName + "] => returns [" + accessAllowed + "], Audit Enabled:" + isAuditEnabled);
        }
        return accessAllowed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void prepare(Map aStormConfigMap) {
        StormRangerPlugin me = plugin;
        if (me != null) return;
        Class<RangerStormAuthorizer> clazz = RangerStormAuthorizer.class;
        synchronized (RangerStormAuthorizer.class) {
            me = plugin;
            if (me != null) return;
            try {
                MiscUtil.setUGIFromJAASConfig((String)STORM_CLIENT_JASS_CONFIG_SECTION);
                LOG.info("LoginUser=" + MiscUtil.getUGILoginUser());
            }
            catch (Throwable t) {
                LOG.error("Error while setting UGI for Storm Plugin...", t);
            }
            LOG.info("Creating StormRangerPlugin");
            plugin = new StormRangerPlugin();
            plugin.init();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }
}

