/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.test.utils;

import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.core.annotations.ApplyLdifFiles;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.factory.DSAnnotationProcessor;
import org.apache.directory.server.factory.ServerAnnotationProcessor;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.qpid.test.utils.TestUtils;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateLdapServerExtension
implements BeforeAllCallback,
AfterAllCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateLdapServerExtension.class);
    private LdapServer _ldapServer;
    private DirectoryService _directoryService;

    public void beforeAll(ExtensionContext ctx) {
        if (this._ldapServer != null) {
            return;
        }
        Class<?> testClass = TestUtils.getTestClass(ctx);
        CreateLdapServer createLdapServer = testClass.getAnnotation(CreateLdapServer.class);
        CreateDS createDS = testClass.getAnnotation(CreateDS.class);
        LOGGER.trace("Creating directory service");
        this._directoryService = this.createDirectoryService(createDS);
        ApplyLdifFiles applyLdifFiles = testClass.getAnnotation(ApplyLdifFiles.class);
        if (applyLdifFiles != null) {
            try {
                DSAnnotationProcessor.injectLdifFiles((Class)applyLdifFiles.clazz(), (DirectoryService)this._directoryService, (String[])applyLdifFiles.value());
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to inject LDIF files", e);
            }
        }
        LOGGER.trace("Creating ldap server");
        this._ldapServer = this.createLdapServer(createLdapServer, this._directoryService);
        try {
            this._directoryService.startup();
        }
        catch (LdapException e) {
            throw new RuntimeException("Failed to start directory service", e);
        }
        try {
            this._ldapServer.start();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to start LDAP server", e);
        }
    }

    public void afterAll(ExtensionContext ctx) {
        if (this._ldapServer != null) {
            LOGGER.trace("Stopping ldap server");
            this._ldapServer.stop();
        }
        if (this._directoryService != null) {
            try {
                LOGGER.trace("Stopping directory service");
                this._directoryService.shutdown();
            }
            catch (LdapException e) {
                throw new RuntimeException("Failed to stop directory service", e);
            }
        }
    }

    public LdapServer createLdapServer(CreateLdapServer createLdapServer, DirectoryService directoryService) {
        return ServerAnnotationProcessor.instantiateLdapServer((CreateLdapServer)createLdapServer, (DirectoryService)directoryService);
    }

    public DirectoryService createDirectoryService(CreateDS createDS) {
        try {
            return DSAnnotationProcessor.createDS((CreateDS)createDS);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create embedded Directory Service", e);
        }
    }

    public LdapServer getLdapServer() {
        return this._ldapServer;
    }

    public DirectoryService getDirectoryService() {
        return this._directoryService;
    }
}

