/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.virtualhostnode.jdbc;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.store.DurableConfigurationStore;
import org.apache.qpid.server.store.jdbc.GenericJDBCConfigurationStore;
import org.apache.qpid.server.virtualhostnode.AbstractStandardVirtualHostNode;
import org.apache.qpid.server.virtualhostnode.jdbc.JDBCVirtualHostNode;

@ManagedObject(type="JDBC", category=false, validChildTypes="org.apache.qpid.server.virtualhostnode.jdbc.JDBCVirtualHostNodeImpl#getSupportedChildTypes()")
public class JDBCVirtualHostNodeImpl
extends AbstractStandardVirtualHostNode<JDBCVirtualHostNodeImpl>
implements JDBCVirtualHostNode<JDBCVirtualHostNodeImpl> {
    public static final String VIRTUAL_HOST_NODE_TYPE = "JDBC";
    @ManagedAttributeField
    private String _connectionUrl;
    @ManagedAttributeField
    private String _connectionPoolType;
    @ManagedAttributeField
    private String _username;
    @ManagedAttributeField
    private String _password;

    @ManagedObjectFactoryConstructor
    public JDBCVirtualHostNodeImpl(Map<String, Object> attributes, Broker<?> parent) {
        super(attributes, parent);
    }

    protected void writeLocationEventLog() {
    }

    protected DurableConfigurationStore createConfigurationStore() {
        return new GenericJDBCConfigurationStore(VirtualHost.class);
    }

    @Override
    public String getConnectionUrl() {
        return this._connectionUrl;
    }

    @Override
    public String getConnectionPoolType() {
        return this._connectionPoolType;
    }

    @Override
    public String getUsername() {
        return this._username;
    }

    @Override
    public String getPassword() {
        return this._password;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [id=" + this.getId() + ", name=" + this.getName() + ", connectionUrl=" + this.getConnectionUrl() + ", connectionPoolType=" + this.getConnectionPoolType() + ", username=" + this.getUsername() + "]";
    }

    public static Map<String, Collection<String>> getSupportedChildTypes() {
        return Collections.singletonMap(VirtualHost.class.getSimpleName(), JDBCVirtualHostNodeImpl.getSupportedVirtualHostTypes((boolean)true));
    }
}

