/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.reactor.impl;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.engine.BaseHandler;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.Handler;
import org.apache.qpid.proton.engine.Record;
import org.apache.qpid.proton.engine.Sasl;
import org.apache.qpid.proton.engine.Transport;
import org.apache.qpid.proton.engine.impl.RecordImpl;
import org.apache.qpid.proton.reactor.Acceptor;
import org.apache.qpid.proton.reactor.Reactor;
import org.apache.qpid.proton.reactor.Selectable;
import org.apache.qpid.proton.reactor.impl.Address;
import org.apache.qpid.proton.reactor.impl.IOHandler;
import org.apache.qpid.proton.reactor.impl.ReactorImpl;
import org.apache.qpid.proton.reactor.impl.ReactorInternalException;
import org.apache.qpid.proton.reactor.impl.SelectableImpl;

public class AcceptorImpl
implements Acceptor {
    private Record attachments = new RecordImpl();
    private final SelectableImpl sel;
    protected static final String CONNECTION_ACCEPTOR_KEY = "pn_reactor_connection_acceptor";

    protected AcceptorImpl(Reactor reactor, String host, int port, Handler handler) throws IOException {
        ServerSocketChannel ssc = ((ReactorImpl)reactor).getIO().serverSocketChannel();
        ssc.bind(new InetSocketAddress(host, port));
        this.sel = ((ReactorImpl)reactor).selectable(this);
        this.sel.setChannel(ssc);
        this.sel.onReadable(new AcceptorReadable());
        this.sel.onFree(new AcceptorFree());
        this.sel.setReactor(reactor);
        BaseHandler.setHandler(this, handler);
        this.sel.setReading(true);
        reactor.update(this.sel);
    }

    @Override
    public void close() {
        if (!this.sel.isTerminal()) {
            Reactor reactor = this.sel.getReactor();
            try {
                this.sel.getChannel().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.sel.setChannel(null);
            this.sel.terminate();
            reactor.update(this.sel);
        }
    }

    public int getPortNumber() throws IOException {
        ServerSocketChannel ssc = (ServerSocketChannel)this.sel.getChannel();
        return ((InetSocketAddress)ssc.getLocalAddress()).getPort();
    }

    @Override
    public void free() {
        this.sel.free();
    }

    @Override
    public Record attachments() {
        return this.attachments;
    }

    private class AcceptorReadable
    implements Selectable.Callback {
        private AcceptorReadable() {
        }

        @Override
        public void run(Selectable selectable) {
            Reactor reactor = selectable.getReactor();
            try {
                SocketChannel socketChannel = ((ServerSocketChannel)selectable.getChannel()).accept();
                if (socketChannel == null) {
                    throw new ReactorInternalException("Selectable readable, but no socket to accept");
                }
                Handler handler = BaseHandler.getHandler(AcceptorImpl.this);
                if (handler == null) {
                    handler = reactor.getHandler();
                }
                Connection conn = reactor.connection(handler);
                Record conn_recs = conn.attachments();
                conn_recs.set(AcceptorImpl.CONNECTION_ACCEPTOR_KEY, Acceptor.class, AcceptorImpl.this);
                InetSocketAddress peerAddr = (InetSocketAddress)socketChannel.getRemoteAddress();
                if (peerAddr != null) {
                    Address addr = new Address();
                    addr.setHost(peerAddr.getHostString());
                    addr.setPort(Integer.toString(peerAddr.getPort()));
                    conn_recs.set("pn_reactor_connection_peer_address", Address.class, addr);
                }
                Transport trans = Proton.transport();
                int maxFrameSizeOption = reactor.getOptions().getMaxFrameSize();
                if (maxFrameSizeOption != 0) {
                    trans.setMaxFrameSize(maxFrameSizeOption);
                }
                if (reactor.getOptions().isEnableSaslByDefault()) {
                    Sasl sasl = trans.sasl();
                    sasl.server();
                    sasl.setMechanisms("ANONYMOUS");
                    sasl.done(Sasl.SaslOutcome.PN_SASL_OK);
                }
                trans.bind(conn);
                IOHandler.selectableTransport(reactor, socketChannel.socket(), trans);
            }
            catch (IOException ioException) {
                AcceptorImpl.this.sel.error();
            }
        }
    }

    private static class AcceptorFree
    implements Selectable.Callback {
        private AcceptorFree() {
        }

        @Override
        public void run(Selectable selectable) {
            try {
                if (selectable.getChannel() != null) {
                    selectable.getChannel().close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

