/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp.builders;

import java.io.IOException;
import org.apache.qpid.jms.meta.JmsResource;
import org.apache.qpid.jms.provider.AsyncResult;
import org.apache.qpid.jms.provider.amqp.AmqpEventSink;
import org.apache.qpid.jms.provider.amqp.AmqpProvider;
import org.apache.qpid.jms.provider.amqp.AmqpResource;
import org.apache.qpid.jms.provider.amqp.AmqpResourceParent;
import org.apache.qpid.jms.provider.amqp.AmqpSupport;
import org.apache.qpid.proton.engine.Endpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AmqpResourceBuilder<TARGET extends AmqpResource, PARENT extends AmqpResourceParent, INFO extends JmsResource, ENDPOINT extends Endpoint>
implements AmqpEventSink {
    private static final Logger LOG = LoggerFactory.getLogger(AmqpResourceBuilder.class);
    protected AsyncResult request;
    protected TARGET resource;
    protected ENDPOINT endpoint;
    protected final PARENT parent;
    protected final INFO resourceInfo;

    public AmqpResourceBuilder(PARENT parent, INFO resourceInfo) {
        this.parent = parent;
        this.resourceInfo = resourceInfo;
    }

    public void buildResource(AsyncResult request) {
        this.request = request;
        this.endpoint = this.createEndpoint(this.resourceInfo);
        this.endpoint.setContext((Object)this);
        this.endpoint.open();
        this.resource = this.createResource(this.parent, this.resourceInfo, this.endpoint);
    }

    @Override
    public void processRemoteOpen(AmqpProvider provider) throws IOException {
        this.handleOpened(provider);
    }

    @Override
    public void processRemoteClose(AmqpProvider provider) throws IOException {
        this.handleClosed(provider);
    }

    @Override
    public void processRemoteDetach(AmqpProvider provider) throws IOException {
    }

    @Override
    public void processDeliveryUpdates(AmqpProvider provider) throws IOException {
    }

    @Override
    public void processFlowUpdates(AmqpProvider provider) throws IOException {
    }

    protected void handleOpened(AmqpProvider provider) throws IOException {
        if (this.isClosePending()) {
            return;
        }
        if (this.isOpenedEndpointValid()) {
            this.afterOpened();
            this.getEndpoint().setContext(this.resource);
            this.getParent().addChildResource((AmqpResource)this.resource);
            this.getRequest().onSuccess();
        } else {
            this.getEndpoint().close();
            this.getEndpoint().free();
            this.getEndpoint().setContext(null);
            this.getRequest().onFailure(new IOException("Failed to open requested endpoint"));
        }
    }

    protected void handleClosed(AmqpProvider provider) throws IOException {
        Exception openError = this.hasRemoteError() ? AmqpSupport.convertToException(this.getEndpoint().getRemoteCondition()) : this.getOpenAbortException();
        LOG.warn("Open of resource:({}) failed: {}", this.resourceInfo, (Object)openError.getMessage());
        this.getEndpoint().close();
        this.getEndpoint().free();
        this.getEndpoint().setContext(null);
        this.getRequest().onFailure(openError);
    }

    protected abstract ENDPOINT createEndpoint(INFO var1);

    protected abstract TARGET createResource(PARENT var1, INFO var2, ENDPOINT var3);

    protected abstract boolean isClosePending();

    protected boolean isOpenedEndpointValid() {
        return true;
    }

    protected void afterOpened() {
    }

    protected boolean hasRemoteError() {
        return this.getEndpoint().getRemoteCondition().getCondition() != null;
    }

    protected Exception getOpenAbortException() {
        return new IOException("Open failed unexpectedly.");
    }

    public ENDPOINT getEndpoint() {
        return this.endpoint;
    }

    public AsyncResult getRequest() {
        return this.request;
    }

    public TARGET getResource() {
        return this.resource;
    }

    public PARENT getParent() {
        return this.parent;
    }

    public INFO getResourceInfo() {
        return this.resourceInfo;
    }
}

