/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp.builders;

import javax.jms.InvalidDestinationException;
import org.apache.qpid.jms.JmsDestination;
import org.apache.qpid.jms.meta.JmsProducerInfo;
import org.apache.qpid.jms.provider.amqp.AmqpFixedProducer;
import org.apache.qpid.jms.provider.amqp.AmqpProducer;
import org.apache.qpid.jms.provider.amqp.AmqpSession;
import org.apache.qpid.jms.provider.amqp.builders.AmqpResourceBuilder;
import org.apache.qpid.jms.provider.amqp.message.AmqpDestinationHelper;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Accepted;
import org.apache.qpid.proton.amqp.messaging.Rejected;
import org.apache.qpid.proton.amqp.messaging.Source;
import org.apache.qpid.proton.amqp.messaging.Target;
import org.apache.qpid.proton.amqp.transport.ReceiverSettleMode;
import org.apache.qpid.proton.amqp.transport.SenderSettleMode;
import org.apache.qpid.proton.engine.Sender;
import org.apache.qpid.proton.engine.Session;

public class AmqpProducerBuilder
extends AmqpResourceBuilder<AmqpProducer, AmqpSession, JmsProducerInfo, Sender> {
    public AmqpProducerBuilder(AmqpSession parent, JmsProducerInfo resourceInfo) {
        super(parent, resourceInfo);
    }

    @Override
    protected Sender createEndpoint(JmsProducerInfo resourceInfo) {
        JmsDestination destination = resourceInfo.getDestination();
        String targetAddress = AmqpDestinationHelper.INSTANCE.getDestinationAddress(destination, ((AmqpSession)this.getParent()).getConnection());
        Symbol[] outcomes = new Symbol[]{Accepted.DESCRIPTOR_SYMBOL, Rejected.DESCRIPTOR_SYMBOL};
        String sourceAddress = resourceInfo.getId().toString();
        Source source = new Source();
        source.setAddress(sourceAddress);
        source.setOutcomes(outcomes);
        Target target = new Target();
        target.setAddress(targetAddress);
        Symbol typeCapability = AmqpDestinationHelper.INSTANCE.toTypeCapability(destination);
        if (typeCapability != null) {
            target.setCapabilities(new Symbol[]{typeCapability});
        }
        String senderName = "qpid-jms:sender:" + sourceAddress + ":" + targetAddress;
        Sender sender = ((Session)((AmqpSession)this.getParent()).getEndpoint()).sender(senderName);
        sender.setSource((org.apache.qpid.proton.amqp.transport.Source)source);
        sender.setTarget((org.apache.qpid.proton.amqp.transport.Target)target);
        if (((AmqpSession)this.getParent()).getConnection().isPresettleProducers()) {
            sender.setSenderSettleMode(SenderSettleMode.SETTLED);
        } else {
            sender.setSenderSettleMode(SenderSettleMode.UNSETTLED);
        }
        sender.setReceiverSettleMode(ReceiverSettleMode.FIRST);
        return sender;
    }

    @Override
    protected AmqpProducer createResource(AmqpSession parent, JmsProducerInfo resourceInfo, Sender endpoint) {
        return new AmqpFixedProducer((AmqpSession)this.getParent(), (JmsProducerInfo)this.getResourceInfo(), endpoint);
    }

    @Override
    protected boolean isClosePending() {
        return ((Sender)this.getEndpoint()).getRemoteTarget() == null;
    }

    @Override
    protected Exception getOpenAbortException() {
        org.apache.qpid.proton.amqp.transport.Target target = ((Sender)this.getEndpoint()).getRemoteTarget();
        if (target != null) {
            return super.getOpenAbortException();
        }
        return new InvalidDestinationException("Link creation was refused");
    }
}

