/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp;

import java.util.HashMap;
import java.util.Map;
import javax.jms.InvalidDestinationException;
import org.apache.qpid.jms.meta.JmsSessionInfo;
import org.apache.qpid.jms.provider.AsyncResult;
import org.apache.qpid.jms.provider.NoOpAsyncResult;
import org.apache.qpid.jms.provider.WrappedAsyncResult;
import org.apache.qpid.jms.provider.amqp.AmqpAbstractResource;
import org.apache.qpid.jms.provider.amqp.AmqpConnection;
import org.apache.qpid.jms.provider.amqp.AmqpSession;
import org.apache.qpid.jms.provider.amqp.builders.AmqpResourceBuilder;
import org.apache.qpid.proton.amqp.messaging.Target;
import org.apache.qpid.proton.amqp.transport.ReceiverSettleMode;
import org.apache.qpid.proton.amqp.transport.SenderSettleMode;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.engine.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpConnectionSession
extends AmqpSession {
    private static final Logger LOG = LoggerFactory.getLogger(AmqpConnectionSession.class);
    private final Map<String, AsyncResult> pendingUnsubs = new HashMap<String, AsyncResult>();

    public AmqpConnectionSession(AmqpConnection connection, JmsSessionInfo info, Session session) {
        super(connection, info, session);
    }

    public void unsubscribe(String subscriptionName, AsyncResult request) {
        DurableSubscriptionReattachBuilder builder = new DurableSubscriptionReattachBuilder(this, (JmsSessionInfo)this.getResourceInfo(), subscriptionName);
        DurableSubscriptionReattachRequest subscribeRequest = new DurableSubscriptionReattachRequest(builder, request);
        this.pendingUnsubs.put(subscriptionName, subscribeRequest);
        LOG.debug("Attempting remove of subscription: {}", (Object)subscriptionName);
        builder.buildResource(subscribeRequest);
    }

    private class DurableSubscriptionReattachRequest
    extends WrappedAsyncResult {
        private final DurableSubscriptionReattachBuilder subscriberBuilder;

        public DurableSubscriptionReattachRequest(DurableSubscriptionReattachBuilder subscriberBuilder, AsyncResult originalRequest) {
            super(originalRequest);
            this.subscriberBuilder = subscriberBuilder;
        }

        @Override
        public void onSuccess() {
            DurableSubscriptionReattach subscriber = (DurableSubscriptionReattach)this.subscriberBuilder.getResource();
            LOG.trace("Reattached to subscription: {}", (Object)subscriber.getSubscriptionName());
            AmqpConnectionSession.this.pendingUnsubs.remove(subscriber.getSubscriptionName());
            if (((Receiver)subscriber.getEndpoint()).getRemoteSource() != null) {
                subscriber.close(this.getWrappedRequest());
            } else {
                subscriber.close(NoOpAsyncResult.INSTANCE);
                this.getWrappedRequest().onFailure((Throwable)new InvalidDestinationException("Cannot remove a subscription that does not exist"));
            }
        }

        @Override
        public void onFailure(Throwable result) {
            DurableSubscriptionReattach subscriber = (DurableSubscriptionReattach)this.subscriberBuilder.getResource();
            LOG.trace("Failed to reattach to subscription: {}", (Object)subscriber.getSubscriptionName());
            AmqpConnectionSession.this.pendingUnsubs.remove(subscriber.getSubscriptionName());
            subscriber.resourceClosed();
            super.onFailure(result);
        }
    }

    private final class DurableSubscriptionReattachBuilder
    extends AmqpResourceBuilder<DurableSubscriptionReattach, AmqpSession, JmsSessionInfo, Receiver> {
        private final String subscriptionName;

        public DurableSubscriptionReattachBuilder(AmqpSession parent, JmsSessionInfo resourceInfo, String subscriptionName) {
            super(parent, resourceInfo);
            this.subscriptionName = subscriptionName;
        }

        @Override
        protected Receiver createEndpoint(JmsSessionInfo resourceInfo) {
            Receiver receiver = ((Session)((AmqpSession)this.getParent()).getEndpoint()).receiver(this.subscriptionName);
            receiver.setTarget((org.apache.qpid.proton.amqp.transport.Target)new Target());
            receiver.setSenderSettleMode(SenderSettleMode.UNSETTLED);
            receiver.setReceiverSettleMode(ReceiverSettleMode.FIRST);
            return receiver;
        }

        @Override
        protected DurableSubscriptionReattach createResource(AmqpSession parent, JmsSessionInfo resourceInfo, Receiver endpoint) {
            return new DurableSubscriptionReattach(resourceInfo, endpoint);
        }

        @Override
        protected boolean isClosePending() {
            return ((Receiver)this.endpoint).getRemoteSource() == null;
        }
    }

    private class DurableSubscriptionReattach
    extends AmqpAbstractResource<JmsSessionInfo, Receiver> {
        public DurableSubscriptionReattach(JmsSessionInfo resource, Receiver receiver) {
            super(resource, receiver);
        }

        public String getSubscriptionName() {
            return ((Receiver)this.getEndpoint()).getName();
        }
    }
}

