/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp.message;

import org.apache.qpid.proton.amqp.UnsignedByte;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.amqp.messaging.Header;

public final class AmqpHeader {
    private static final int DEFAULT_PRIORITY = 4;
    private static final long UINT_MAX = 0xFFFFFFFFL;
    private static byte DURABLE = 1;
    private static byte PRIORITY = (byte)2;
    private static byte TIME_TO_LIVE = (byte)4;
    private static byte FIRST_ACQUIRER = (byte)8;
    private static byte DELIVERY_COUNT = (byte)16;
    private byte modified = 0;
    private Boolean durable;
    private UnsignedByte priority;
    private UnsignedInteger timeToLive;
    private Boolean firstAcquirer;
    private UnsignedInteger deliveryCount;

    public AmqpHeader() {
    }

    public AmqpHeader(AmqpHeader header) {
        this.setHeader(header);
    }

    public AmqpHeader(Header header) {
        this.setHeader(header);
    }

    public void setHeader(Header header) {
        if (header != null) {
            this.setDurable(header.getDurable());
            this.setPriority(header.getPriority());
            this.setTimeToLive(header.getTtl());
            this.setFirstAcquirer(header.getFirstAcquirer());
            this.setDeliveryCount(header.getDeliveryCount());
        }
    }

    public void setHeader(AmqpHeader header) {
        if (header != null) {
            this.modified = header.modified;
            this.durable = header.durable;
            this.priority = header.priority;
            this.timeToLive = header.timeToLive;
            this.firstAcquirer = header.firstAcquirer;
            this.deliveryCount = header.deliveryCount;
        }
    }

    public Header getHeader() {
        Header result = null;
        if (!this.isDefault()) {
            result = new Header();
            if (Boolean.TRUE.equals(this.durable)) {
                result.setDurable(Boolean.TRUE);
            } else {
                result.setDurable(Boolean.FALSE);
            }
            result.setPriority(this.priority);
            result.setFirstAcquirer(this.firstAcquirer);
            result.setTtl(this.timeToLive);
            result.setDeliveryCount(this.deliveryCount);
        }
        return result;
    }

    public boolean isDefault() {
        return this.modified == 0;
    }

    public boolean nonDefaultDurable() {
        return (this.modified & DURABLE) == DURABLE;
    }

    public boolean nonDefaultPriority() {
        return (this.modified & PRIORITY) == PRIORITY;
    }

    public boolean nonDefaultTimeToLive() {
        return (this.modified & TIME_TO_LIVE) == TIME_TO_LIVE;
    }

    public boolean nonDefaultFirstAcquirer() {
        return (this.modified & FIRST_ACQUIRER) == FIRST_ACQUIRER;
    }

    public boolean nonDefaultDeliveryCount() {
        return (this.modified & DELIVERY_COUNT) == DELIVERY_COUNT;
    }

    public boolean isDurable() {
        return Boolean.TRUE.equals(this.durable);
    }

    public void setDurable(Boolean value) {
        if (Boolean.TRUE.equals(value)) {
            this.modified = (byte)(this.modified | DURABLE);
            this.durable = value;
        } else {
            this.modified = (byte)(this.modified & ~DURABLE);
            this.durable = null;
        }
    }

    public int getPriority() {
        if (this.priority != null) {
            int scaled = this.priority.intValue();
            if (scaled > 9) {
                scaled = 9;
            }
            return scaled;
        }
        return 4;
    }

    public void setPriority(UnsignedByte value) {
        if (value == null || value.intValue() == 4) {
            this.modified = (byte)(this.modified & ~PRIORITY);
            this.priority = null;
        } else {
            this.modified = (byte)(this.modified | PRIORITY);
            this.priority = value;
        }
    }

    public void setPriority(int priority) {
        if (priority == 4) {
            this.setPriority(null);
        } else {
            int scaled = priority;
            if (priority < 0) {
                scaled = 0;
            } else if (priority > 9) {
                scaled = 9;
            }
            this.setPriority(UnsignedByte.valueOf((byte)scaled));
        }
    }

    public long getTimeToLive() {
        return this.timeToLive == null ? 0L : this.timeToLive.longValue();
    }

    public void setTimeToLive(UnsignedInteger value) {
        if (value == null || UnsignedInteger.ZERO.equals((Object)value)) {
            this.modified = (byte)(this.modified & ~TIME_TO_LIVE);
            this.timeToLive = null;
        } else {
            this.modified = (byte)(this.modified | TIME_TO_LIVE);
            this.timeToLive = value;
        }
    }

    public void setTimeToLive(long timeToLive) {
        if (timeToLive > 0L && timeToLive < 0xFFFFFFFFL) {
            this.setTimeToLive(UnsignedInteger.valueOf((long)timeToLive));
        } else {
            this.setTimeToLive(null);
        }
    }

    public boolean isFirstAcquirer() {
        return Boolean.TRUE.equals(this.firstAcquirer);
    }

    public void setFirstAcquirer(Boolean value) {
        if (Boolean.TRUE.equals(value)) {
            this.modified = (byte)(this.modified | FIRST_ACQUIRER);
            this.firstAcquirer = Boolean.TRUE;
        } else {
            this.modified = (byte)(this.modified & ~FIRST_ACQUIRER);
            this.firstAcquirer = null;
        }
    }

    public int getDeliveryCount() {
        return this.deliveryCount == null ? 0 : this.deliveryCount.intValue();
    }

    public void setDeliveryCount(UnsignedInteger value) {
        if (value == null || UnsignedInteger.ZERO.equals((Object)value)) {
            this.modified = (byte)(this.modified & ~DELIVERY_COUNT);
            this.deliveryCount = null;
        } else {
            this.modified = (byte)(this.modified | DELIVERY_COUNT);
            this.deliveryCount = value;
        }
    }

    public void setDeliveryCount(int count) {
        if (count == 0) {
            this.setDeliveryCount(null);
        } else {
            this.setDeliveryCount(UnsignedInteger.valueOf((int)count));
        }
    }

    public String toString() {
        return "AmqpHeader {durable=" + this.durable + ", priority=" + this.priority + ", ttl=" + this.timeToLive + ", firstAcquirer=" + this.firstAcquirer + ", deliveryCount=" + this.deliveryCount + " }";
    }
}

