/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.policy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.qpid.jms.JmsDestination;
import org.apache.qpid.jms.policy.JmsDeserializationPolicy;

public class JmsDefaultDeserializationPolicy
implements JmsDeserializationPolicy {
    public static final String CATCH_ALL_WILDCARD = "*";
    @Deprecated
    public static final String DEPRECATED_ALLOWLIST_PROPERTY = "org.apache.qpid.jms.deserialization.white_list";
    @Deprecated
    public static final String DEPRECATED_DENYLIST_PROPERTY = "org.apache.qpid.jms.deserialization.black_list";
    public static final String ALLOWLIST_PROPERTY = "org.apache.qpid.jms.deserialization.allow_list";
    public static final String DENYLIST_PROPERTY = "org.apache.qpid.jms.deserialization.deny_list";
    private List<String> allowList = new ArrayList<String>();
    private List<String> denyList = new ArrayList<String>();

    public JmsDefaultDeserializationPolicy() {
        String deprecatedAllowList = System.getProperty(DEPRECATED_ALLOWLIST_PROPERTY, CATCH_ALL_WILDCARD);
        String allowList = System.getProperty(ALLOWLIST_PROPERTY, deprecatedAllowList);
        this.setAllowList(allowList);
        String deprecatedDenyList = System.getProperty(DEPRECATED_DENYLIST_PROPERTY);
        String denyList = System.getProperty(DENYLIST_PROPERTY, deprecatedDenyList);
        this.setDenyList(denyList);
    }

    public JmsDefaultDeserializationPolicy(JmsDefaultDeserializationPolicy source) {
        this.allowList.addAll(source.allowList);
        this.denyList.addAll(source.denyList);
    }

    @Override
    public JmsDeserializationPolicy copy() {
        return new JmsDefaultDeserializationPolicy(this);
    }

    @Override
    public boolean isTrustedType(JmsDestination destination, Class<?> clazz) {
        if (clazz == null) {
            return true;
        }
        String className = clazz.getCanonicalName();
        if (className == null) {
            className = clazz.getName();
        }
        for (String denyListEntry : this.denyList) {
            if (CATCH_ALL_WILDCARD.equals(denyListEntry)) {
                return false;
            }
            if (!this.isClassOrPackageMatch(className, denyListEntry)) continue;
            return false;
        }
        for (String allowListEntry : this.allowList) {
            if (CATCH_ALL_WILDCARD.equals(allowListEntry)) {
                return true;
            }
            if (!this.isClassOrPackageMatch(className, allowListEntry)) continue;
            return true;
        }
        return false;
    }

    private final boolean isClassOrPackageMatch(String className, String listEntry) {
        if (className == null) {
            return false;
        }
        if (className.equals(listEntry)) {
            return true;
        }
        int entryLength = listEntry.length();
        return className.length() > entryLength && className.startsWith(listEntry) && '.' == className.charAt(entryLength);
    }

    @Deprecated
    public String getWhiteList() {
        return this.getAllowList();
    }

    public String getAllowList() {
        Iterator<String> entries = this.allowList.iterator();
        StringBuilder builder = new StringBuilder();
        while (entries.hasNext()) {
            builder.append(entries.next());
            if (!entries.hasNext()) continue;
            builder.append(",");
        }
        return builder.toString();
    }

    @Deprecated
    public String getBlackList() {
        return this.getDenyList();
    }

    public String getDenyList() {
        Iterator<String> entries = this.denyList.iterator();
        StringBuilder builder = new StringBuilder();
        while (entries.hasNext()) {
            builder.append(entries.next());
            if (!entries.hasNext()) continue;
            builder.append(",");
        }
        return builder.toString();
    }

    @Deprecated
    public void setWhiteList(String allowList) {
        this.setAllowList(allowList);
    }

    public void setAllowList(String allowList) {
        ArrayList<String> list = new ArrayList<String>();
        if (allowList != null && !allowList.isEmpty()) {
            list.addAll(Arrays.asList(allowList.split(",")));
        }
        this.allowList = list;
    }

    @Deprecated
    public void setBlackList(String denyList) {
        this.setDenyList(denyList);
    }

    public void setDenyList(String denyList) {
        ArrayList<String> list = new ArrayList<String>();
        if (denyList != null && !denyList.isEmpty()) {
            list.addAll(Arrays.asList(denyList.split(",")));
        }
        this.denyList = list;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.allowList == null ? 0 : this.allowList.hashCode());
        result = 31 * result + (this.denyList == null ? 0 : this.denyList.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JmsDefaultDeserializationPolicy other = (JmsDefaultDeserializationPolicy)obj;
        if (this.allowList == null ? other.allowList != null : !this.allowList.equals(other.allowList)) {
            return false;
        }
        return !(this.denyList == null ? other.denyList != null : !this.denyList.equals(other.denyList));
    }
}

