/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp;

import java.io.IOException;
import java.util.Map;
import javax.jms.JMSException;
import org.apache.qpid.jms.JmsDestination;
import org.apache.qpid.jms.message.JmsOutboundMessageDispatch;
import org.apache.qpid.jms.meta.JmsProducerId;
import org.apache.qpid.jms.meta.JmsProducerInfo;
import org.apache.qpid.jms.provider.AsyncResult;
import org.apache.qpid.jms.provider.WrappedAsyncResult;
import org.apache.qpid.jms.provider.amqp.AmqpFixedProducer;
import org.apache.qpid.jms.provider.amqp.AmqpProducer;
import org.apache.qpid.jms.provider.amqp.AmqpSession;
import org.apache.qpid.jms.util.IdGenerator;
import org.apache.qpid.jms.util.LRUCache;
import org.apache.qpid.proton.engine.EndpointState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpAnonymousFallbackProducer
extends AmqpProducer {
    private static final Logger LOG = LoggerFactory.getLogger(AmqpAnonymousFallbackProducer.class);
    private static final IdGenerator producerIdGenerator = new IdGenerator();
    private final AnonymousProducerCache producerCache = new AnonymousProducerCache(10);
    private final String producerIdKey = producerIdGenerator.generateId();
    private long producerIdCount;

    public AmqpAnonymousFallbackProducer(AmqpSession session, JmsProducerInfo info) {
        super(session, info);
        if (this.connection.isAnonymousProducerCache()) {
            this.producerCache.setMaxCacheSize(this.connection.getAnonymousProducerCacheSize());
        }
    }

    @Override
    public boolean send(JmsOutboundMessageDispatch envelope, AsyncResult request) throws IOException, JMSException {
        LOG.trace("Started send chain for anonymous producer: {}", (Object)this.getProducerId());
        AmqpProducer producer = null;
        if (this.connection.isAnonymousProducerCache()) {
            producer = (AmqpProducer)this.producerCache.get(envelope.getDestination());
        }
        if (producer == null) {
            JmsProducerInfo info = new JmsProducerInfo(this.getNextProducerId());
            info.setDestination(envelope.getDestination());
            producer = new AmqpFixedProducer(this.session, info);
            producer.setPresettle(this.isPresettle());
            AnonymousOpenRequest open = new AnonymousOpenRequest(request, producer, envelope);
            producer.open(open);
            if (this.connection.isAnonymousProducerCache()) {
                this.producerCache.put(envelope.getDestination(), producer);
            }
            return true;
        }
        return producer.send(envelope, request);
    }

    @Override
    public void open(AsyncResult request) {
        request.onSuccess();
    }

    @Override
    public void close(AsyncResult request) {
        for (AmqpProducer producer : this.producerCache.values()) {
            producer.close(new CloseRequest(producer));
        }
        request.onSuccess();
    }

    @Override
    public boolean isAnonymous() {
        return true;
    }

    @Override
    public EndpointState getLocalState() {
        return EndpointState.ACTIVE;
    }

    @Override
    public EndpointState getRemoteState() {
        return EndpointState.ACTIVE;
    }

    private JmsProducerId getNextProducerId() {
        return new JmsProducerId(this.producerIdKey, -1L, this.producerIdCount++);
    }

    private final class AnonymousProducerCache
    extends LRUCache<JmsDestination, AmqpProducer> {
        private static final long serialVersionUID = 1L;

        public AnonymousProducerCache(int cacheSize) {
            super(cacheSize);
        }

        @Override
        protected void onCacheEviction(Map.Entry<JmsDestination, AmqpProducer> cached) {
            LOG.trace("Producer: {} evicted from producer cache", (Object)cached.getValue());
            cached.getValue().close(new CloseRequest(cached.getValue()));
        }
    }

    private final class CloseRequest
    implements AsyncResult {
        private final AmqpProducer producer;

        public CloseRequest(AmqpProducer producer) {
            this.producer = producer;
        }

        @Override
        public void onFailure(Throwable result) {
            AmqpAnonymousFallbackProducer.this.connection.getProvider().fireProviderException(result);
        }

        @Override
        public void onSuccess() {
            LOG.trace("Close of anonymous producer {} complete", (Object)this.producer);
        }

        @Override
        public boolean isComplete() {
            return this.producer.isClosed();
        }
    }

    private final class AnonymousCloseRequest
    extends AnonymousRequest {
        public AnonymousCloseRequest(AnonymousSendRequest send) {
            super(send.getWrappedRequest(), send.producer, send.envelope);
        }

        @Override
        public void onSuccess() {
            LOG.trace("Close phase of anonymous send complete: {} ", (Object)AmqpAnonymousFallbackProducer.this.getProducerId());
            super.onSuccess();
        }
    }

    private final class AnonymousSendRequest
    extends AnonymousRequest {
        public AnonymousSendRequest(AnonymousOpenRequest open) {
            super(open.getWrappedRequest(), open.producer, open.envelope);
        }

        @Override
        public void onFailure(Throwable result) {
            AmqpAnonymousFallbackProducer.this.producerCache.remove(((JmsProducerInfo)this.producer.getJmsResource()).getDestination());
            super.onFailure(result);
        }

        @Override
        public void onSuccess() {
            LOG.trace("Send phase of anonymous send complete: {} ", (Object)AmqpAnonymousFallbackProducer.this.getProducerId());
            if (!AmqpAnonymousFallbackProducer.this.connection.isAnonymousProducerCache()) {
                AnonymousCloseRequest close = new AnonymousCloseRequest(this);
                this.producer.close(close);
            } else {
                super.onSuccess();
            }
        }
    }

    private final class AnonymousOpenRequest
    extends AnonymousRequest {
        public AnonymousOpenRequest(AsyncResult sendResult, AmqpProducer producer, JmsOutboundMessageDispatch envelope) {
            super(sendResult, producer, envelope);
        }

        @Override
        public void onSuccess() {
            LOG.trace("Open phase of anonymous send complete: {} ", (Object)AmqpAnonymousFallbackProducer.this.getProducerId());
            AnonymousSendRequest send = new AnonymousSendRequest(this);
            try {
                this.producer.send(this.envelope, send);
            }
            catch (Exception e) {
                super.onFailure(e);
            }
        }
    }

    private abstract class AnonymousRequest
    extends WrappedAsyncResult {
        protected final AmqpProducer producer;
        protected final JmsOutboundMessageDispatch envelope;

        public AnonymousRequest(AsyncResult sendResult, AmqpProducer producer, JmsOutboundMessageDispatch envelope) {
            super(sendResult);
            this.producer = producer;
            this.envelope = envelope;
        }

        @Override
        public void onFailure(Throwable result) {
            LOG.debug("Send failed during {} step in chain: {}", (Object)this.getClass().getName(), (Object)AmqpAnonymousFallbackProducer.this.getProducerId());
            super.onFailure(result);
        }
    }
}

