/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.discovery.multicast.parsers;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.qpid.jms.provider.discovery.multicast.DiscoveryEvent;
import org.apache.qpid.jms.provider.discovery.multicast.PacketParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveMQPacketParser
implements PacketParser {
    private static final Logger LOG = LoggerFactory.getLogger(ActiveMQPacketParser.class);
    private static final String TYPE_SUFFIX = "ActiveMQ-4.";
    private static final String ALIVE = "alive.";
    private static final String DEAD = "dead.";
    private static final String DELIMITER = "%";
    private String group;

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public void setGroup(String group) {
        this.group = group;
    }

    @Override
    public DiscoveryEvent processPacket(byte[] packet, int offset, int length) {
        String str = new String(packet, offset, length);
        DiscoveryEvent event = null;
        if (str.startsWith(this.getType())) {
            String payload = str.substring(this.getType().length());
            if (payload.startsWith(ALIVE)) {
                String brokerName = this.getBrokerName(payload.substring(ALIVE.length()));
                try {
                    String brokerUri = payload.substring(ALIVE.length() + brokerName.length() + 2);
                    event = new DiscoveryEvent(new URI(brokerUri), DiscoveryEvent.EventType.ALIVE);
                }
                catch (URISyntaxException ex) {
                    LOG.warn("Published URI has invalid URI syntax, ignoring: {}", (Object)payload);
                }
            } else {
                String brokerName = this.getBrokerName(payload.substring(DEAD.length()));
                try {
                    String brokerUri = payload.substring(DEAD.length() + brokerName.length() + 2);
                    event = new DiscoveryEvent(new URI(brokerUri), DiscoveryEvent.EventType.SHUTDOWN);
                }
                catch (URISyntaxException ex) {
                    LOG.warn("Published URI has invalid URI syntax, ignoring: {}", (Object)payload);
                }
            }
        }
        return event;
    }

    private String getBrokerName(String str) {
        String result = null;
        int start = str.indexOf(DELIMITER);
        if (start >= 0) {
            int end = str.indexOf(DELIMITER, start + 1);
            result = str.substring(start + 1, end);
        }
        return result;
    }

    private String getType() {
        return this.group + "." + TYPE_SUFFIX;
    }
}

