/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.discovery;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.apache.qpid.jms.provider.Provider;
import org.apache.qpid.jms.provider.ProviderWrapper;
import org.apache.qpid.jms.provider.discovery.DiscoveryAgent;
import org.apache.qpid.jms.provider.discovery.DiscoveryListener;
import org.apache.qpid.jms.provider.discovery.DiscoveryProviderFactory;
import org.apache.qpid.jms.provider.failover.FailoverProvider;
import org.apache.qpid.jms.util.QpidJMSThreadFactory;
import org.apache.qpid.jms.util.ThreadPoolUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscoveryProvider
extends ProviderWrapper<FailoverProvider>
implements DiscoveryListener {
    private static final Logger LOG = LoggerFactory.getLogger(DiscoveryProviderFactory.class);
    private final URI discoveryUri;
    private final List<DiscoveryAgent> discoveryAgents = new ArrayList<DiscoveryAgent>();
    private ScheduledExecutorService sharedScheduler;

    public DiscoveryProvider(URI discoveryUri, FailoverProvider next) {
        super((Provider)next);
        this.discoveryUri = discoveryUri;
    }

    public void start() throws IOException, IllegalStateException {
        if (this.discoveryAgents.isEmpty()) {
            throw new IllegalStateException("No DiscoveryAgent configured.");
        }
        for (DiscoveryAgent discoveryAgent : this.discoveryAgents) {
            discoveryAgent.setDiscoveryListener(this);
            if (discoveryAgent.isSchedulerRequired()) {
                discoveryAgent.setScheduler(this.getSharedScheduler());
            }
            discoveryAgent.start();
        }
        super.start();
    }

    public void close() {
        ThreadPoolUtils.shutdownGraceful((ExecutorService)this.sharedScheduler);
        for (DiscoveryAgent discoveryAgent : this.discoveryAgents) {
            discoveryAgent.close();
        }
        super.close();
    }

    public URI getDiscoveryURI() {
        return this.discoveryUri;
    }

    public List<DiscoveryAgent> getDiscoveryAgents() {
        return Collections.unmodifiableList(this.discoveryAgents);
    }

    public void setDiscoveryAgents(List<DiscoveryAgent> agents) {
        this.discoveryAgents.addAll(agents);
    }

    @Override
    public void onServiceAdd(URI remoteURI) {
        if (remoteURI != null) {
            LOG.debug("Adding URI of remote peer: {}", (Object)remoteURI);
            ((FailoverProvider)this.next).add(remoteURI);
        }
    }

    @Override
    public void onServiceRemove(URI remoteURI) {
        if (remoteURI != null) {
            LOG.debug("Removing URI of remote peer: {}", (Object)remoteURI);
            ((FailoverProvider)this.next).remove(remoteURI);
        }
    }

    public void onConnectionInterrupted(URI remoteURI) {
        for (DiscoveryAgent discoveryAgent : this.discoveryAgents) {
            discoveryAgent.resume();
        }
        super.onConnectionInterrupted(remoteURI);
    }

    public void onConnectionRestored(URI remoteURI) {
        for (DiscoveryAgent discoveryAgent : this.discoveryAgents) {
            discoveryAgent.suspend();
        }
        super.onConnectionRestored(remoteURI);
    }

    private ScheduledExecutorService getSharedScheduler() {
        if (this.sharedScheduler == null) {
            this.sharedScheduler = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new QpidJMSThreadFactory("DiscoveryProvider :[" + this.getDiscoveryURI() + "]", true));
        }
        return this.sharedScheduler;
    }
}

