/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp.message;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.qpid.proton.codec.ReadableBuffer;
import org.apache.qpid.proton.codec.WritableBuffer;

public class AmqpWritableBuffer
implements WritableBuffer {
    public static final int INITIAL_CAPACITY = 1024;
    public ByteBuf nettyBuffer;

    public AmqpWritableBuffer() {
        this.nettyBuffer = Unpooled.buffer((int)1024);
    }

    public AmqpWritableBuffer(ByteBuf buffer) {
        this.nettyBuffer = buffer;
    }

    public ByteBuf getBuffer() {
        return this.nettyBuffer;
    }

    public void put(byte b) {
        this.nettyBuffer.writeByte((int)b);
    }

    public void putFloat(float f) {
        this.nettyBuffer.writeFloat(f);
    }

    public void putDouble(double d) {
        this.nettyBuffer.writeDouble(d);
    }

    public void put(byte[] src, int offset, int length) {
        this.nettyBuffer.writeBytes(src, offset, length);
    }

    public void put(ByteBuffer payload) {
        this.nettyBuffer.writeBytes(payload);
    }

    public void put(ByteBuf payload) {
        this.nettyBuffer.writeBytes(payload);
    }

    public void putShort(short s) {
        this.nettyBuffer.writeShort((int)s);
    }

    public void putInt(int i) {
        this.nettyBuffer.writeInt(i);
    }

    public void putLong(long l) {
        this.nettyBuffer.writeLong(l);
    }

    public void put(String value) {
        this.nettyBuffer.writeCharSequence((CharSequence)value, StandardCharsets.UTF_8);
    }

    public boolean hasRemaining() {
        return this.nettyBuffer.writerIndex() < this.nettyBuffer.maxCapacity();
    }

    public int remaining() {
        return this.nettyBuffer.maxCapacity() - this.nettyBuffer.writerIndex();
    }

    public int position() {
        return this.nettyBuffer.writerIndex();
    }

    public void position(int position) {
        this.nettyBuffer.writerIndex(position);
    }

    public int limit() {
        return this.nettyBuffer.capacity();
    }

    public void put(ReadableBuffer buffer) {
        buffer.get((WritableBuffer)this);
    }
}

