/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp.message;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.qpid.jms.provider.amqp.message.AmqpCodec;
import org.apache.qpid.jms.provider.amqp.message.AmqpJmsMessageFacade;
import org.apache.qpid.jms.provider.amqp.message.AmqpObjectTypeDelegate;
import org.apache.qpid.proton.amqp.messaging.AmqpSequence;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.Section;

public class AmqpTypedObjectDelegate
implements AmqpObjectTypeDelegate {
    static final AmqpValue NULL_OBJECT_BODY = new AmqpValue(null);
    private ByteBuf encodedBody;
    private final AmqpJmsMessageFacade parent;

    public AmqpTypedObjectDelegate(AmqpJmsMessageFacade parent) {
        this.parent = parent;
        this.parent.setContentType(null);
        if (parent.getBody() != null) {
            this.encodedBody = AmqpCodec.encode(parent.getBody());
        }
    }

    @Override
    public Serializable getObject() throws IOException, ClassNotFoundException {
        Section body = null;
        if (this.encodedBody != null) {
            body = AmqpCodec.decode(this.encodedBody);
        }
        if (body == null) {
            return null;
        }
        if (body instanceof AmqpValue) {
            return (Serializable)((AmqpValue)body).getValue();
        }
        if (body instanceof Data) {
            throw new UnsupportedOperationException("Data support still to be added");
        }
        if (body instanceof AmqpSequence) {
            return (Serializable)((Object)((AmqpSequence)body).getValue());
        }
        throw new IllegalStateException("Unexpected body type: " + body.getClass().getSimpleName());
    }

    @Override
    public void setObject(Serializable value) throws IOException {
        if (value == null) {
            this.parent.setBody((Section)NULL_OBJECT_BODY);
            this.encodedBody = null;
        } else if (this.isSupportedAmqpValueObjectType(value)) {
            this.encodedBody = AmqpCodec.encode((Section)new AmqpValue((Object)value));
            Section decodedBody = AmqpCodec.decode(this.encodedBody);
            this.parent.setBody(decodedBody);
        } else {
            throw new IllegalArgumentException("Encoding this object type with the AMQP type system is not supported: " + value.getClass().getName());
        }
    }

    @Override
    public void onSend() {
        this.parent.setContentType(null);
        if (this.parent.getBody() == null) {
            this.parent.setBody((Section)NULL_OBJECT_BODY);
        }
    }

    @Override
    public void copyInto(AmqpObjectTypeDelegate copy) throws Exception {
        if (!(copy instanceof AmqpTypedObjectDelegate)) {
            copy.setObject(this.getObject());
        } else {
            AmqpTypedObjectDelegate target = (AmqpTypedObjectDelegate)copy;
            if (this.encodedBody != null) {
                target.encodedBody = this.encodedBody.duplicate();
                target.parent.setBody(this.parent.getBody());
            }
        }
    }

    @Override
    public boolean isAmqpTypeEncoded() {
        return true;
    }

    @Override
    public boolean hasBody() {
        try {
            return this.getObject() != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isSupportedAmqpValueObjectType(Serializable serializable) {
        return serializable instanceof String || serializable instanceof Map || serializable instanceof List || serializable.getClass().isArray();
    }
}

