/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.JMSException;
import javax.jms.JMSSecurityRuntimeException;
import javax.net.ssl.SSLContext;
import org.apache.qpid.jms.JmsConnectionExtensions;
import org.apache.qpid.jms.JmsTemporaryDestination;
import org.apache.qpid.jms.message.JmsInboundMessageDispatch;
import org.apache.qpid.jms.message.JmsMessageFactory;
import org.apache.qpid.jms.message.JmsOutboundMessageDispatch;
import org.apache.qpid.jms.meta.JmsConnectionInfo;
import org.apache.qpid.jms.meta.JmsConsumerId;
import org.apache.qpid.jms.meta.JmsConsumerInfo;
import org.apache.qpid.jms.meta.JmsDefaultResourceVisitor;
import org.apache.qpid.jms.meta.JmsProducerId;
import org.apache.qpid.jms.meta.JmsProducerInfo;
import org.apache.qpid.jms.meta.JmsResource;
import org.apache.qpid.jms.meta.JmsResourceVistor;
import org.apache.qpid.jms.meta.JmsSessionId;
import org.apache.qpid.jms.meta.JmsSessionInfo;
import org.apache.qpid.jms.meta.JmsTransactionInfo;
import org.apache.qpid.jms.provider.AsyncResult;
import org.apache.qpid.jms.provider.NoOpAsyncResult;
import org.apache.qpid.jms.provider.Provider;
import org.apache.qpid.jms.provider.ProviderClosedException;
import org.apache.qpid.jms.provider.ProviderConstants;
import org.apache.qpid.jms.provider.ProviderFailedException;
import org.apache.qpid.jms.provider.ProviderFuture;
import org.apache.qpid.jms.provider.ProviderListener;
import org.apache.qpid.jms.provider.amqp.AmqpConnection;
import org.apache.qpid.jms.provider.amqp.AmqpConsumer;
import org.apache.qpid.jms.provider.amqp.AmqpEventSink;
import org.apache.qpid.jms.provider.amqp.AmqpExceptionBuilder;
import org.apache.qpid.jms.provider.amqp.AmqpFixedProducer;
import org.apache.qpid.jms.provider.amqp.AmqpProducer;
import org.apache.qpid.jms.provider.amqp.AmqpRedirect;
import org.apache.qpid.jms.provider.amqp.AmqpResource;
import org.apache.qpid.jms.provider.amqp.AmqpResourceParent;
import org.apache.qpid.jms.provider.amqp.AmqpSaslAuthenticator;
import org.apache.qpid.jms.provider.amqp.AmqpSession;
import org.apache.qpid.jms.provider.amqp.AmqpTemporaryDestination;
import org.apache.qpid.jms.provider.amqp.builders.AmqpClosedConnectionBuilder;
import org.apache.qpid.jms.provider.amqp.builders.AmqpConnectionBuilder;
import org.apache.qpid.jms.sasl.Mechanism;
import org.apache.qpid.jms.sasl.SaslMechanismFinder;
import org.apache.qpid.jms.transports.TransportListener;
import org.apache.qpid.jms.util.IOExceptionSupport;
import org.apache.qpid.jms.util.PropertyUtil;
import org.apache.qpid.jms.util.QpidJMSThreadFactory;
import org.apache.qpid.jms.util.ThreadPoolUtils;
import org.apache.qpid.proton.engine.Collector;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Sasl;
import org.apache.qpid.proton.engine.SaslListener;
import org.apache.qpid.proton.engine.Transport;
import org.apache.qpid.proton.engine.impl.CollectorImpl;
import org.apache.qpid.proton.engine.impl.ProtocolTracer;
import org.apache.qpid.proton.engine.impl.TransportImpl;
import org.apache.qpid.proton.engine.impl.TransportInternal;
import org.apache.qpid.proton.framing.TransportFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpProvider
implements Provider,
TransportListener,
AmqpResourceParent {
    private static final Logger LOG = LoggerFactory.getLogger(AmqpProvider.class);
    private static final Logger TRACE_BYTES = LoggerFactory.getLogger((String)(AmqpConnection.class.getPackage().getName() + ".BYTES"));
    private static final Logger TRACE_FRAMES = LoggerFactory.getLogger((String)(AmqpConnection.class.getPackage().getName() + ".FRAMES"));
    private static final int DEFAULT_MAX_FRAME_SIZE = 0x100000;
    private static final int DEFAULT_CHANNEL_MAX = Short.MAX_VALUE;
    private static final AtomicInteger PROVIDER_SEQUENCE = new AtomicInteger();
    private static final NoOpAsyncResult NOOP_REQUEST = new NoOpAsyncResult();
    private volatile ProviderListener listener;
    private volatile AmqpConnection connection;
    private AmqpSaslAuthenticator authenticator;
    private final org.apache.qpid.jms.transports.Transport transport;
    private String vhost;
    private boolean traceFrames;
    private boolean traceBytes;
    private boolean saslLayer = true;
    private Set<String> saslMechanisms;
    private JmsConnectionInfo connectionInfo;
    private int channelMax = Short.MAX_VALUE;
    private int idleTimeout = 60000;
    private int drainTimeout = 60000;
    private long sessionOutoingWindow = -1L;
    private int maxFrameSize = 0x100000;
    private boolean allowNonSecureRedirects;
    private final URI remoteURI;
    private final AtomicBoolean closed = new AtomicBoolean();
    private volatile Throwable failureCause;
    private ScheduledThreadPoolExecutor serializer;
    private final Transport protonTransport = Transport.Factory.create();
    private final Collector protonCollector = new CollectorImpl();
    private final Connection protonConnection = Connection.Factory.create();
    private AsyncResult connectionRequest;
    private ScheduledFuture<?> nextIdleTimeoutCheck;

    public AmqpProvider(URI remoteURI, org.apache.qpid.jms.transports.Transport transport) {
        this.remoteURI = remoteURI;
        this.transport = transport;
        this.serializer = new ScheduledThreadPoolExecutor(1, new QpidJMSThreadFactory("AmqpProvider :(" + PROVIDER_SEQUENCE.incrementAndGet() + "):[" + remoteURI.getScheme() + "://" + remoteURI.getHost() + ":" + remoteURI.getPort() + "]", true));
        this.serializer.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.serializer.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
    }

    @Override
    public void connect(final JmsConnectionInfo connectionInfo) throws IOException {
        this.checkClosedOrFailed();
        final ProviderFuture connectRequest = new ProviderFuture();
        this.serializer.execute(new Runnable(){

            @Override
            public void run() {
                AmqpProvider.this.connectionRequest = connectRequest;
                AmqpProvider.this.connectionInfo = connectionInfo;
                try {
                    Map headers;
                    AmqpProvider.this.protonTransport.setEmitFlowEventOnSend(false);
                    try {
                        ((TransportInternal)AmqpProvider.this.protonTransport).setUseReadOnlyOutputBuffer(false);
                    }
                    catch (NoSuchMethodError nsme) {
                        LOG.trace("Proton output buffer optimisation unavailable");
                    }
                    if (AmqpProvider.this.getMaxFrameSize() > 0) {
                        AmqpProvider.this.protonTransport.setMaxFrameSize(AmqpProvider.this.getMaxFrameSize());
                        AmqpProvider.this.protonTransport.setOutboundFrameSizeLimit(AmqpProvider.this.getMaxFrameSize());
                    }
                    AmqpProvider.this.protonTransport.setChannelMax(AmqpProvider.this.getChannelMax());
                    AmqpProvider.this.protonTransport.setIdleTimeout(AmqpProvider.this.idleTimeout);
                    AmqpProvider.this.protonTransport.bind(AmqpProvider.this.protonConnection);
                    AmqpProvider.this.protonConnection.collect(AmqpProvider.this.protonCollector);
                    SSLContext sslContextOverride = connectionInfo.getExtensionMap().containsKey((Object)JmsConnectionExtensions.SSL_CONTEXT) ? (SSLContext)connectionInfo.getExtensionMap().get((Object)JmsConnectionExtensions.SSL_CONTEXT).apply(connectionInfo.getConnection(), AmqpProvider.this.transport.getRemoteLocation()) : null;
                    AmqpProvider.this.transport.setTransportListener(AmqpProvider.this);
                    AmqpProvider.this.transport.setMaxFrameSize(AmqpProvider.this.maxFrameSize);
                    if (connectionInfo.getExtensionMap().containsKey((Object)JmsConnectionExtensions.HTTP_HEADERS_OVERRIDE) && (headers = (Map)connectionInfo.getExtensionMap().get((Object)JmsConnectionExtensions.HTTP_HEADERS_OVERRIDE).apply(connectionInfo.getConnection(), AmqpProvider.this.transport.getRemoteLocation())) != null) {
                        AmqpProvider.this.transport.getTransportOptions().getHttpHeaders().putAll(headers);
                    }
                    AmqpProvider.this.transport.connect(sslContextOverride);
                    if (AmqpProvider.this.saslLayer) {
                        Sasl sasl = AmqpProvider.this.protonTransport.sasl();
                        sasl.client();
                        String hostname = AmqpProvider.this.getVhost();
                        if (hostname == null) {
                            hostname = AmqpProvider.this.remoteURI.getHost();
                        } else if (hostname.isEmpty()) {
                            hostname = null;
                        }
                        sasl.setRemoteHostname(hostname);
                        sasl.setListener(new SaslListener(){

                            public void onSaslMechanisms(Sasl sasl, Transport transport) {
                                AmqpProvider.this.authenticator.handleSaslMechanisms(sasl, transport);
                                AmqpProvider.this.checkSaslAuthenticationState();
                            }

                            public void onSaslChallenge(Sasl sasl, Transport transport) {
                                AmqpProvider.this.authenticator.handleSaslChallenge(sasl, transport);
                                AmqpProvider.this.checkSaslAuthenticationState();
                            }

                            public void onSaslOutcome(Sasl sasl, Transport transport) {
                                AmqpProvider.this.authenticator.handleSaslOutcome(sasl, transport);
                                AmqpProvider.this.checkSaslAuthenticationState();
                            }

                            public void onSaslInit(Sasl sasl, Transport transport) {
                            }

                            public void onSaslResponse(Sasl sasl, Transport transport) {
                            }
                        });
                        AmqpProvider.this.authenticator = new AmqpSaslAuthenticator(remoteMechanisms -> AmqpProvider.this.findSaslMechanism(remoteMechanisms));
                        AmqpProvider.this.pumpToProtonTransport();
                    } else {
                        connectRequest.onSuccess();
                    }
                }
                catch (Throwable t) {
                    AmqpProvider.this.connectionRequest.onFailure(IOExceptionSupport.create(t));
                }
            }
        });
        if (connectionInfo.getConnectTimeout() != -1L) {
            if (!connectRequest.sync(connectionInfo.getConnectTimeout(), TimeUnit.MILLISECONDS)) {
                throw new IOException("Timed out while waiting to connect");
            }
        } else {
            connectRequest.sync();
        }
    }

    @Override
    public void start() throws IOException, IllegalStateException {
        this.checkClosedOrFailed();
        if (this.listener == null) {
            throw new IllegalStateException("No ProviderListener registered.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            final ProviderFuture request = new ProviderFuture(){

                @Override
                public void onFailure(Throwable result) {
                    this.onSuccess();
                }
            };
            this.serializer.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (AmqpProvider.this.transport == null || !AmqpProvider.this.transport.isConnected()) {
                            request.onSuccess();
                            return;
                        }
                        if (AmqpProvider.this.connection != null) {
                            AmqpProvider.this.connection.close(request);
                        } else {
                            if (!(AmqpProvider.this.authenticator == null || AmqpProvider.this.authenticator.isComplete() && AmqpProvider.this.authenticator.wasSuccessful())) {
                                request.onSuccess();
                                return;
                            }
                            if (AmqpProvider.this.protonConnection.getLocalState() == EndpointState.UNINITIALIZED) {
                                AmqpClosedConnectionBuilder builder = new AmqpClosedConnectionBuilder(AmqpProvider.this.getProvider(), AmqpProvider.this.connectionInfo);
                                builder.buildResource(request);
                                AmqpProvider.this.protonConnection.setContext((Object)builder);
                            } else {
                                request.onSuccess();
                            }
                        }
                        AmqpProvider.this.pumpToProtonTransport(request);
                    }
                    catch (Exception e) {
                        LOG.debug("Caught exception while closing proton connection: {}", (Object)e.getMessage());
                    }
                    finally {
                        if (AmqpProvider.this.nextIdleTimeoutCheck != null) {
                            LOG.trace("Cancelling scheduled IdleTimeoutCheck");
                            AmqpProvider.this.nextIdleTimeoutCheck.cancel(false);
                            AmqpProvider.this.nextIdleTimeoutCheck = null;
                        }
                    }
                }
            });
            try {
                if (this.getCloseTimeout() < 0L) {
                    request.sync();
                } else {
                    request.sync(this.getCloseTimeout(), TimeUnit.MILLISECONDS);
                }
            }
            catch (IOException e) {
                LOG.warn("Error caught while closing Provider: {}", (Object)(e.getMessage() != null ? e.getMessage() : "<Unknown Error>"));
            }
            finally {
                try {
                    if (this.transport != null) {
                        try {
                            this.transport.close();
                        }
                        catch (Exception e) {
                            LOG.debug("Caught exception while closing down Transport: {}", (Object)e.getMessage());
                        }
                    }
                }
                finally {
                    ThreadPoolUtils.shutdownGraceful(this.serializer);
                }
            }
        }
    }

    @Override
    public void create(final JmsResource resource, final AsyncResult request) throws IOException, JMSException {
        this.checkClosedOrFailed();
        this.serializer.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    AmqpProvider.this.checkClosedOrFailed();
                    resource.visit(new JmsResourceVistor(){

                        @Override
                        public void processSessionInfo(JmsSessionInfo sessionInfo) throws Exception {
                            AmqpProvider.this.connection.createSession(sessionInfo, request);
                        }

                        @Override
                        public void processProducerInfo(JmsProducerInfo producerInfo) throws Exception {
                            AmqpSession session = AmqpProvider.this.connection.getSession(producerInfo.getParentId());
                            session.createProducer(producerInfo, request);
                        }

                        @Override
                        public void processConsumerInfo(JmsConsumerInfo consumerInfo) throws Exception {
                            AmqpSession session = consumerInfo.isConnectionConsumer() ? AmqpProvider.this.connection.getConnectionSession() : AmqpProvider.this.connection.getSession(consumerInfo.getParentId());
                            session.createConsumer(consumerInfo, request);
                        }

                        @Override
                        public void processConnectionInfo(JmsConnectionInfo connectionInfo) throws Exception {
                            AmqpProvider.this.connectionInfo = connectionInfo;
                            AmqpConnectionBuilder builder = new AmqpConnectionBuilder(AmqpProvider.this, connectionInfo);
                            AmqpProvider.this.connectionRequest = new AsyncResult(){

                                @Override
                                public void onSuccess() {
                                    AmqpProvider.this.fireConnectionEstablished();
                                    request.onSuccess();
                                }

                                @Override
                                public void onFailure(Throwable result) {
                                    request.onFailure(result);
                                }

                                @Override
                                public boolean isComplete() {
                                    return request.isComplete();
                                }
                            };
                            builder.buildResource(AmqpProvider.this.connectionRequest);
                        }

                        @Override
                        public void processDestination(JmsTemporaryDestination destination) throws Exception {
                            if (destination.isTemporary()) {
                                AmqpProvider.this.connection.createTemporaryDestination(destination, request);
                            } else {
                                request.onSuccess();
                            }
                        }

                        @Override
                        public void processTransactionInfo(JmsTransactionInfo transactionInfo) throws Exception {
                            AmqpSession session = AmqpProvider.this.connection.getSession(transactionInfo.getSessionId());
                            session.begin(transactionInfo.getId(), request);
                        }
                    });
                    AmqpProvider.this.pumpToProtonTransport(request);
                }
                catch (Throwable t) {
                    request.onFailure(t);
                }
            }
        });
    }

    @Override
    public void start(final JmsResource resource, final AsyncResult request) throws IOException {
        this.checkClosedOrFailed();
        this.serializer.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    AmqpProvider.this.checkClosedOrFailed();
                    resource.visit(new JmsDefaultResourceVisitor(){

                        @Override
                        public void processConsumerInfo(JmsConsumerInfo consumerInfo) throws Exception {
                            AmqpSession session = AmqpProvider.this.connection.getSession(consumerInfo.getParentId());
                            AmqpConsumer consumer = session.getConsumer(consumerInfo);
                            consumer.start(request);
                        }
                    });
                    AmqpProvider.this.pumpToProtonTransport(request);
                }
                catch (Throwable t) {
                    request.onFailure(t);
                }
            }
        });
    }

    @Override
    public void stop(final JmsResource resource, final AsyncResult request) throws IOException {
        this.checkClosedOrFailed();
        this.serializer.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    AmqpProvider.this.checkClosedOrFailed();
                    resource.visit(new JmsDefaultResourceVisitor(){

                        @Override
                        public void processConsumerInfo(JmsConsumerInfo consumerInfo) throws Exception {
                            AmqpSession session = AmqpProvider.this.connection.getSession(consumerInfo.getParentId());
                            AmqpConsumer consumer = session.getConsumer(consumerInfo);
                            consumer.stop(request);
                        }
                    });
                    AmqpProvider.this.pumpToProtonTransport(request);
                }
                catch (Throwable t) {
                    request.onFailure(t);
                }
            }
        });
    }

    @Override
    public void destroy(final JmsResource resource, final AsyncResult request) throws IOException {
        this.checkClosedOrFailed();
        this.serializer.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    AmqpProvider.this.checkClosedOrFailed();
                    resource.visit(new JmsDefaultResourceVisitor(){

                        @Override
                        public void processSessionInfo(JmsSessionInfo sessionInfo) throws Exception {
                            final AmqpSession session = AmqpProvider.this.connection.getSession(sessionInfo.getId());
                            session.close(new AsyncResult(){

                                @Override
                                public void onSuccess() {
                                    this.onComplete();
                                    request.onSuccess();
                                }

                                @Override
                                public void onFailure(Throwable result) {
                                    this.onComplete();
                                    request.onFailure(result);
                                }

                                @Override
                                public boolean isComplete() {
                                    return request.isComplete();
                                }

                                void onComplete() {
                                    session.handleResourceClosure(AmqpProvider.this, null);
                                }
                            });
                        }

                        @Override
                        public void processProducerInfo(JmsProducerInfo producerInfo) throws Exception {
                            AmqpSession session = AmqpProvider.this.connection.getSession(producerInfo.getParentId());
                            AmqpProducer producer = session.getProducer(producerInfo);
                            producer.close(request);
                        }

                        @Override
                        public void processConsumerInfo(final JmsConsumerInfo consumerInfo) throws Exception {
                            AmqpSession session = AmqpProvider.this.connection.getSession(consumerInfo.getParentId());
                            AmqpConsumer consumer = session.getConsumer(consumerInfo);
                            consumer.close(new AsyncResult(){

                                @Override
                                public void onSuccess() {
                                    this.onComplete();
                                    request.onSuccess();
                                }

                                @Override
                                public void onFailure(Throwable result) {
                                    this.onComplete();
                                    request.onFailure(result);
                                }

                                @Override
                                public boolean isComplete() {
                                    return request.isComplete();
                                }

                                void onComplete() {
                                    AmqpProvider.this.connection.getSubTracker().consumerRemoved(consumerInfo);
                                }
                            });
                        }

                        @Override
                        public void processConnectionInfo(JmsConnectionInfo connectionInfo) throws Exception {
                            AmqpProvider.this.connection.close(request);
                        }

                        @Override
                        public void processDestination(JmsTemporaryDestination destination) throws Exception {
                            AmqpTemporaryDestination temporary = AmqpProvider.this.connection.getTemporaryDestination(destination);
                            if (temporary != null) {
                                temporary.close(request);
                            } else {
                                LOG.debug("Could not find temporary destination {} to delete.", (Object)destination);
                                request.onSuccess();
                            }
                        }
                    });
                    AmqpProvider.this.pumpToProtonTransport(request);
                }
                catch (Throwable t) {
                    request.onFailure(t);
                }
            }
        });
    }

    @Override
    public void send(final JmsOutboundMessageDispatch envelope, final AsyncResult request) throws IOException {
        this.checkClosedOrFailed();
        this.serializer.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    AmqpProvider.this.checkClosedOrFailed();
                    JmsProducerId producerId = envelope.getProducerId();
                    AmqpProducer producer = null;
                    if (producerId.getProviderHint() instanceof AmqpFixedProducer) {
                        producer = (AmqpFixedProducer)producerId.getProviderHint();
                    } else {
                        AmqpSession session = AmqpProvider.this.connection.getSession(producerId.getParentId());
                        producer = session.getProducer(producerId);
                    }
                    ((AmqpProducer)producer).send(envelope, request);
                }
                catch (Throwable t) {
                    request.onFailure(t);
                }
            }
        });
    }

    @Override
    public void acknowledge(final JmsSessionId sessionId, final ProviderConstants.ACK_TYPE ackType, final AsyncResult request) throws IOException {
        this.checkClosedOrFailed();
        this.serializer.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    AmqpProvider.this.checkClosedOrFailed();
                    AmqpSession amqpSession = AmqpProvider.this.connection.getSession(sessionId);
                    amqpSession.acknowledge(ackType);
                    AmqpProvider.this.pumpToProtonTransport(request);
                    request.onSuccess();
                }
                catch (Throwable t) {
                    request.onFailure(t);
                }
            }
        });
    }

    @Override
    public void acknowledge(final JmsInboundMessageDispatch envelope, final ProviderConstants.ACK_TYPE ackType, final AsyncResult request) throws IOException {
        this.checkClosedOrFailed();
        this.serializer.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    AmqpProvider.this.checkClosedOrFailed();
                    JmsConsumerId consumerId = envelope.getConsumerId();
                    AmqpConsumer consumer = null;
                    if (consumerId.getProviderHint() instanceof AmqpConsumer) {
                        consumer = (AmqpConsumer)consumerId.getProviderHint();
                    } else {
                        AmqpSession session = AmqpProvider.this.connection.getSession(consumerId.getParentId());
                        consumer = session.getConsumer(consumerId);
                    }
                    consumer.acknowledge(envelope, ackType);
                    if (consumer.getSession().isAsyncAck()) {
                        request.onSuccess();
                        AmqpProvider.this.pumpToProtonTransport(request);
                    } else {
                        AmqpProvider.this.pumpToProtonTransport(request);
                        request.onSuccess();
                    }
                }
                catch (Throwable t) {
                    request.onFailure(t);
                }
            }
        });
    }

    @Override
    public void commit(final JmsTransactionInfo transactionInfo, final JmsTransactionInfo nextTransactionId, final AsyncResult request) throws IOException {
        this.checkClosedOrFailed();
        this.serializer.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    AmqpProvider.this.checkClosedOrFailed();
                    AmqpSession session = AmqpProvider.this.connection.getSession(transactionInfo.getSessionId());
                    session.commit(transactionInfo, nextTransactionId, request);
                    AmqpProvider.this.pumpToProtonTransport(request);
                }
                catch (Throwable t) {
                    request.onFailure(t);
                }
            }
        });
    }

    @Override
    public void rollback(final JmsTransactionInfo transactionInfo, final JmsTransactionInfo nextTransactionId, final AsyncResult request) throws IOException {
        this.checkClosedOrFailed();
        this.serializer.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    AmqpProvider.this.checkClosedOrFailed();
                    AmqpSession session = AmqpProvider.this.connection.getSession(transactionInfo.getSessionId());
                    session.rollback(transactionInfo, nextTransactionId, request);
                    AmqpProvider.this.pumpToProtonTransport(request);
                }
                catch (Throwable t) {
                    request.onFailure(t);
                }
            }
        });
    }

    @Override
    public void recover(final JmsSessionId sessionId, final AsyncResult request) throws IOException {
        this.checkClosedOrFailed();
        this.serializer.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    AmqpProvider.this.checkClosedOrFailed();
                    AmqpSession session = AmqpProvider.this.connection.getSession(sessionId);
                    session.recover();
                    AmqpProvider.this.pumpToProtonTransport(request);
                    request.onSuccess();
                }
                catch (Throwable t) {
                    request.onFailure(t);
                }
            }
        });
    }

    @Override
    public void unsubscribe(final String subscription, final AsyncResult request) throws IOException {
        this.checkClosedOrFailed();
        this.serializer.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    AmqpProvider.this.checkClosedOrFailed();
                    AmqpProvider.this.connection.unsubscribe(subscription, request);
                    AmqpProvider.this.pumpToProtonTransport(request);
                }
                catch (Throwable t) {
                    request.onFailure(t);
                }
            }
        });
    }

    @Override
    public void pull(final JmsConsumerId consumerId, final long timeout, final AsyncResult request) throws IOException {
        this.checkClosedOrFailed();
        this.serializer.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    AmqpProvider.this.checkClosedOrFailed();
                    AmqpConsumer consumer = null;
                    if (consumerId.getProviderHint() instanceof AmqpConsumer) {
                        consumer = (AmqpConsumer)consumerId.getProviderHint();
                    } else {
                        AmqpSession session = AmqpProvider.this.connection.getSession(consumerId.getParentId());
                        consumer = session.getConsumer(consumerId);
                    }
                    consumer.pull(timeout, request);
                    AmqpProvider.this.pumpToProtonTransport(request);
                }
                catch (Throwable t) {
                    request.onFailure(t);
                }
            }
        });
    }

    private void updateTracer() {
        if (this.isTraceFrames()) {
            ((TransportImpl)this.protonTransport).setProtocolTracer(new ProtocolTracer(){

                public void receivedFrame(TransportFrame transportFrame) {
                    TRACE_FRAMES.trace("RECV: {}", (Object)transportFrame.getBody());
                }

                public void sentFrame(TransportFrame transportFrame) {
                    TRACE_FRAMES.trace("SENT: {}", (Object)transportFrame.getBody());
                }
            });
        }
    }

    @Override
    public void onData(final ByteBuf input) {
        ReferenceCountUtil.retain((Object)input);
        this.serializer.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    if (AmqpProvider.this.isTraceBytes()) {
                        TRACE_BYTES.info("Received: {}", (Object)ByteBufUtil.hexDump((ByteBuf)input));
                    }
                    do {
                        ByteBuffer buffer = AmqpProvider.this.protonTransport.tail();
                        int chunkSize = Math.min(buffer.remaining(), input.readableBytes());
                        buffer.limit(buffer.position() + chunkSize);
                        input.readBytes(buffer);
                        AmqpProvider.this.protonTransport.process();
                    } while (input.isReadable());
                    ReferenceCountUtil.release((Object)input);
                    AmqpProvider.this.processUpdates();
                    AmqpProvider.this.pumpToProtonTransport();
                }
                catch (Throwable t) {
                    LOG.warn("Caught problem during data processing: {}", (Object)t.getMessage(), (Object)t);
                    AmqpProvider.this.fireProviderException(t);
                }
            }
        });
    }

    @Override
    public void onTransportError(final Throwable error) {
        if (!this.serializer.isShutdown()) {
            this.serializer.execute(new Runnable(){

                @Override
                public void run() {
                    LOG.info("Transport failed: {}", (Object)error.getMessage());
                    if (!AmqpProvider.this.closed.get()) {
                        AmqpProvider.this.protonTransport.close_head();
                        AmqpProvider.this.fireProviderException(error);
                    }
                }
            });
        }
    }

    public void scheduleExecuteAndPump(final Runnable task) {
        this.serializer.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    try {
                        task.run();
                    }
                    finally {
                        AmqpProvider.this.pumpToProtonTransport();
                    }
                }
                catch (Throwable t) {
                    LOG.warn("Caught problem during task processing: {}", (Object)t.getMessage(), (Object)t);
                    AmqpProvider.this.fireProviderException(t);
                }
            }
        });
    }

    @Override
    public void onTransportClosed() {
        if (!this.serializer.isShutdown()) {
            this.serializer.execute(new Runnable(){

                @Override
                public void run() {
                    LOG.debug("Transport connection remotely closed");
                    if (!AmqpProvider.this.closed.get()) {
                        AmqpProvider.this.protonTransport.close_head();
                        AmqpProvider.this.fireProviderException(new IOException("Transport connection remotely closed."));
                    }
                }
            });
        }
    }

    private void checkSaslAuthenticationState() {
        try {
            if (this.authenticator.isComplete()) {
                if (!this.authenticator.wasSuccessful()) {
                    Transport t = this.protonConnection.getTransport();
                    t.close_head();
                    this.connectionRequest.onFailure((Throwable)this.authenticator.getFailureCause());
                } else {
                    this.connectionRequest.onSuccess();
                    this.authenticator = null;
                }
            }
        }
        catch (Throwable ex) {
            try {
                Transport t = this.protonConnection.getTransport();
                t.close_head();
            }
            finally {
                this.fireProviderException(ex);
            }
        }
    }

    private void processUpdates() {
        try {
            Event protonEvent = null;
            while ((protonEvent = this.protonCollector.peek()) != null) {
                if (!protonEvent.getType().equals((Object)Event.Type.TRANSPORT)) {
                    LOG.trace("New Proton Event: {}", (Object)protonEvent.getType());
                }
                AmqpEventSink amqpEventSink = null;
                switch (protonEvent.getType()) {
                    case CONNECTION_REMOTE_CLOSE: {
                        amqpEventSink = (AmqpEventSink)protonEvent.getConnection().getContext();
                        if (amqpEventSink == null) break;
                        amqpEventSink.processRemoteClose(this);
                        break;
                    }
                    case CONNECTION_REMOTE_OPEN: {
                        amqpEventSink = (AmqpEventSink)protonEvent.getConnection().getContext();
                        if (amqpEventSink == null) break;
                        amqpEventSink.processRemoteOpen(this);
                        break;
                    }
                    case SESSION_REMOTE_CLOSE: {
                        amqpEventSink = (AmqpEventSink)protonEvent.getSession().getContext();
                        if (amqpEventSink == null) break;
                        amqpEventSink.processRemoteClose(this);
                        break;
                    }
                    case SESSION_REMOTE_OPEN: {
                        amqpEventSink = (AmqpEventSink)protonEvent.getSession().getContext();
                        if (amqpEventSink == null) break;
                        amqpEventSink.processRemoteOpen(this);
                        break;
                    }
                    case LINK_REMOTE_CLOSE: {
                        amqpEventSink = (AmqpEventSink)protonEvent.getLink().getContext();
                        if (amqpEventSink == null) break;
                        amqpEventSink.processRemoteClose(this);
                        break;
                    }
                    case LINK_REMOTE_DETACH: {
                        amqpEventSink = (AmqpEventSink)protonEvent.getLink().getContext();
                        if (amqpEventSink == null) break;
                        amqpEventSink.processRemoteDetach(this);
                        break;
                    }
                    case LINK_REMOTE_OPEN: {
                        amqpEventSink = (AmqpEventSink)protonEvent.getLink().getContext();
                        if (amqpEventSink == null) break;
                        amqpEventSink.processRemoteOpen(this);
                        break;
                    }
                    case LINK_FLOW: {
                        amqpEventSink = (AmqpEventSink)protonEvent.getLink().getContext();
                        if (amqpEventSink == null) break;
                        amqpEventSink.processFlowUpdates(this);
                        break;
                    }
                    case DELIVERY: {
                        amqpEventSink = (AmqpEventSink)protonEvent.getLink().getContext();
                        if (amqpEventSink == null) break;
                        amqpEventSink.processDeliveryUpdates(this, (Delivery)protonEvent.getContext());
                        break;
                    }
                }
                this.protonCollector.pop();
            }
        }
        catch (Throwable t) {
            try {
                LOG.warn("Caught problem during update processing: {}", (Object)t.getMessage(), (Object)t);
            }
            finally {
                this.fireProviderException(t);
            }
        }
    }

    protected boolean pumpToProtonTransport() {
        return this.pumpToProtonTransport(NOOP_REQUEST);
    }

    protected boolean pumpToProtonTransport(AsyncResult request) {
        try {
            boolean done = false;
            while (!done) {
                ByteBuffer toWrite = this.protonTransport.getOutputBuffer();
                if (toWrite != null && toWrite.hasRemaining()) {
                    ByteBuf outbound = this.transport.allocateSendBuffer(toWrite.remaining());
                    outbound.writeBytes(toWrite);
                    if (this.isTraceBytes()) {
                        TRACE_BYTES.info("Sending: {}", (Object)ByteBufUtil.hexDump((ByteBuf)outbound));
                    }
                    this.transport.send(outbound);
                    this.protonTransport.outputConsumed();
                    continue;
                }
                done = true;
            }
        }
        catch (IOException e) {
            this.fireProviderException(e);
            request.onFailure(e);
            return false;
        }
        return true;
    }

    void fireConnectionEstablished() {
        ProviderListener listener;
        this.connectionRequest = null;
        long now = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
        long deadline = this.protonTransport.tick(now);
        if (deadline != 0L) {
            long delay = deadline - now;
            LOG.trace("IdleTimeoutCheck being initiated, initial delay: {}", (Object)delay);
            this.nextIdleTimeoutCheck = this.serializer.schedule(new IdleTimeoutCheck(), delay, TimeUnit.MILLISECONDS);
        }
        if ((listener = this.listener) != null) {
            listener.onConnectionEstablished(this.remoteURI);
        }
    }

    void fireNonFatalProviderException(Exception ex) {
        ProviderListener listener = this.listener;
        if (listener != null) {
            listener.onProviderException(ex);
        }
    }

    void fireProviderException(Throwable ex) {
        if (this.connectionRequest != null) {
            this.connectionRequest.onFailure(ex);
            this.connectionRequest = null;
        }
        if (this.nextIdleTimeoutCheck != null) {
            this.nextIdleTimeoutCheck.cancel(true);
            this.nextIdleTimeoutCheck = null;
        }
        this.failureCause = ex;
        ProviderListener listener = this.listener;
        if (listener != null) {
            listener.onConnectionFailure(IOExceptionSupport.create(ex));
        }
    }

    void fireResourceClosed(JmsResource resource, Throwable cause) {
        ProviderListener listener = this.listener;
        if (listener != null) {
            listener.onResourceClosed(resource, cause);
        }
    }

    @Override
    public void addChildResource(AmqpResource resource) {
        if (resource instanceof AmqpConnection) {
            this.connection = (AmqpConnection)resource;
        }
    }

    @Override
    public void removeChildResource(AmqpResource resource) {
    }

    @Override
    public JmsMessageFactory getMessageFactory() {
        if (this.connection == null) {
            throw new RuntimeException("Message Factory is not accessible when not connected.");
        }
        return this.connection.getAmqpMessageFactory();
    }

    public void setTraceFrames(boolean trace) {
        this.traceFrames = trace;
        this.updateTracer();
    }

    public boolean isTraceFrames() {
        return this.traceFrames;
    }

    public void setTraceBytes(boolean trace) {
        this.traceBytes = trace;
    }

    public boolean isTraceBytes() {
        return this.traceBytes;
    }

    public boolean isSaslLayer() {
        return this.saslLayer;
    }

    public void setSaslLayer(boolean saslLayer) {
        this.saslLayer = saslLayer;
    }

    public Set<String> getSaslMechanisms() {
        return this.saslMechanisms;
    }

    public void setSaslMechanisms(String[] saslMechanisms) {
        HashSet<String> saslMechanismSet = null;
        if (saslMechanisms != null && saslMechanisms.length > 0) {
            HashSet<String> mechs = new HashSet<String>();
            for (int i = 0; i < saslMechanisms.length; ++i) {
                String mech = saslMechanisms[i];
                if (mech.trim().isEmpty()) continue;
                mechs.add(mech);
            }
            if (!mechs.isEmpty()) {
                saslMechanismSet = mechs;
            }
        }
        this.saslMechanisms = saslMechanismSet;
    }

    public String getVhost() {
        return this.vhost;
    }

    public void setVhost(String vhost) {
        this.vhost = vhost;
    }

    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public int getDrainTimeout() {
        return this.drainTimeout;
    }

    public void setDrainTimeout(int drainTimeout) {
        this.drainTimeout = drainTimeout;
    }

    public int getMaxFrameSize() {
        return this.maxFrameSize;
    }

    public void setMaxFrameSize(int maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
    }

    public long getSessionOutgoingWindow() {
        return this.sessionOutoingWindow;
    }

    public void setSessionOutgoingWindow(long sessionOutoingWindow) {
        this.sessionOutoingWindow = sessionOutoingWindow;
    }

    public boolean isAllowNonSecureRedirects() {
        return this.allowNonSecureRedirects;
    }

    public void setAllowNonSecureRedirects(boolean allowNonSecureRedirects) {
        this.allowNonSecureRedirects = allowNonSecureRedirects;
    }

    public long getCloseTimeout() {
        return this.connectionInfo != null ? this.connectionInfo.getCloseTimeout() : 60000L;
    }

    public long getConnectTimeout() {
        return this.connectionInfo != null ? this.connectionInfo.getConnectTimeout() : 15000L;
    }

    public long getRequestTimeout() {
        return this.connectionInfo != null ? this.connectionInfo.getRequestTimeout() : -1L;
    }

    public long getSendTimeout() {
        return this.connectionInfo != null ? this.connectionInfo.getSendTimeout() : -1L;
    }

    public String toString() {
        return "AmqpProvider: " + this.getRemoteURI().getHost() + ":" + this.getRemoteURI().getPort();
    }

    public int getChannelMax() {
        return this.channelMax;
    }

    public void setChannelMax(int channelMax) {
        this.channelMax = channelMax;
    }

    public org.apache.qpid.jms.transports.Transport getTransport() {
        return this.transport;
    }

    @Override
    public void setProviderListener(ProviderListener listener) {
        this.listener = listener;
    }

    @Override
    public ProviderListener getProviderListener() {
        return this.listener;
    }

    @Override
    public URI getRemoteURI() {
        return this.remoteURI;
    }

    @Override
    public List<URI> getAlternateURIs() {
        List<AmqpRedirect> failoverList;
        ArrayList<URI> alternates = new ArrayList<URI>();
        if (this.connection != null && !(failoverList = this.connection.getProperties().getFailoverServerList()).isEmpty()) {
            for (AmqpRedirect redirect : failoverList) {
                try {
                    alternates.add(redirect.toURI());
                }
                catch (Exception ex) {
                    LOG.trace("Error while creating URI from failover server: {}", (Object)redirect);
                }
            }
        }
        return alternates;
    }

    public Transport getProtonTransport() {
        return this.protonTransport;
    }

    public Connection getProtonConnection() {
        return this.protonConnection;
    }

    ScheduledExecutorService getScheduler() {
        return this.serializer;
    }

    @Override
    public AmqpProvider getProvider() {
        return this;
    }

    public ScheduledFuture<?> scheduleRequestTimeout(final AsyncResult request, long timeout, final Exception error) {
        if (timeout != -1L) {
            return this.serializer.schedule(new Runnable(){

                @Override
                public void run() {
                    request.onFailure(error);
                    AmqpProvider.this.pumpToProtonTransport();
                }
            }, timeout, TimeUnit.MILLISECONDS);
        }
        return null;
    }

    public ScheduledFuture<?> scheduleRequestTimeout(final AsyncResult request, long timeout, final AmqpExceptionBuilder builder) {
        if (timeout != -1L) {
            return this.serializer.schedule(new Runnable(){

                @Override
                public void run() {
                    request.onFailure(builder.createException());
                    AmqpProvider.this.pumpToProtonTransport();
                }
            }, timeout, TimeUnit.MILLISECONDS);
        }
        return null;
    }

    private void checkClosedOrFailed() throws ProviderClosedException, ProviderFailedException {
        if (this.closed.get()) {
            throw new ProviderClosedException("This Provider is already closed");
        }
        if (this.failureCause != null) {
            throw new ProviderFailedException("The Provider has failed", this.failureCause);
        }
    }

    private Mechanism findSaslMechanism(String[] remoteMechanisms) throws JMSSecurityRuntimeException {
        String username = this.connectionInfo.getExtensionMap().containsKey((Object)JmsConnectionExtensions.USERNAME_OVERRIDE) ? (String)this.connectionInfo.getExtensionMap().get((Object)JmsConnectionExtensions.USERNAME_OVERRIDE).apply(this.connectionInfo.getConnection(), this.transport.getRemoteLocation()) : this.connectionInfo.getUsername();
        String password = this.connectionInfo.getExtensionMap().containsKey((Object)JmsConnectionExtensions.PASSWORD_OVERRIDE) ? (String)this.connectionInfo.getExtensionMap().get((Object)JmsConnectionExtensions.PASSWORD_OVERRIDE).apply(this.connectionInfo.getConnection(), this.transport.getRemoteLocation()) : this.connectionInfo.getPassword();
        Mechanism mechanism = SaslMechanismFinder.findMatchingMechanism(username, password, this.transport.getLocalPrincipal(), this.saslMechanisms, remoteMechanisms);
        mechanism.setUsername(username);
        mechanism.setPassword(password);
        try {
            Map<String, String> saslOptions = PropertyUtil.filterProperties(PropertyUtil.parseQuery(this.getRemoteURI()), "sasl.options.");
            if (!saslOptions.containsKey("serverName")) {
                saslOptions.put("serverName", this.remoteURI.getHost());
            }
            mechanism.init(Collections.unmodifiableMap(saslOptions));
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to apply sasl options to mechanism: " + mechanism.getName() + ", reason: " + ex.toString(), ex);
        }
        return mechanism;
    }

    private final class IdleTimeoutCheck
    implements Runnable {
        private IdleTimeoutCheck() {
        }

        @Override
        public void run() {
            boolean checkScheduled = false;
            if (AmqpProvider.this.connection.getLocalState() == EndpointState.ACTIVE) {
                long now = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
                long deadline = AmqpProvider.this.protonTransport.tick(now);
                boolean pumpSucceeded = AmqpProvider.this.pumpToProtonTransport();
                if (AmqpProvider.this.protonTransport.isClosed()) {
                    LOG.info("IdleTimeoutCheck closed the transport due to the peer exceeding our requested idle-timeout.");
                    if (pumpSucceeded) {
                        AmqpProvider.this.fireProviderException(new IOException("Transport closed due to the peer exceeding our requested idle-timeout"));
                    }
                } else if (deadline != 0L) {
                    long delay = deadline - now;
                    checkScheduled = true;
                    LOG.trace("IdleTimeoutCheck rescheduling with delay: {}", (Object)delay);
                    AmqpProvider.this.nextIdleTimeoutCheck = AmqpProvider.this.serializer.schedule(this, delay, TimeUnit.MILLISECONDS);
                }
            } else {
                LOG.trace("IdleTimeoutCheck skipping check, connection is not active.");
            }
            if (!checkScheduled) {
                AmqpProvider.this.nextIdleTimeoutCheck = null;
                LOG.trace("IdleTimeoutCheck exiting");
            }
        }
    }
}

