/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import org.apache.qpid.jms.provider.AsyncResult;
import org.apache.qpid.jms.provider.ProviderSynchronization;
import org.apache.qpid.jms.util.IOExceptionSupport;

public class ProviderFuture
implements AsyncResult {
    private static final int SPIN_COUNT = 10;
    private static final int YIELD_COUNT = 100;
    private static final int TINY_PARK_COUNT = 1000;
    private static final int TINY_PARK_NANOS = 1;
    private static final int SMALL_PARK_COUNT = 101000;
    private static final int SMALL_PARK_NANOS = 10000;
    private static final int INCOMPLETE = 0;
    private static final int COMPLETING = 1;
    private static final int SUCCESS = 2;
    private static final int FAILURE = 3;
    private static final AtomicIntegerFieldUpdater<ProviderFuture> STATE_FIELD_UPDATER = AtomicIntegerFieldUpdater.newUpdater(ProviderFuture.class, "state");
    private volatile int state = 0;
    private volatile Throwable error;
    private int waiting;
    private final ProviderSynchronization synchronization;

    public ProviderFuture() {
        this(null);
    }

    public ProviderFuture(ProviderSynchronization synchronization) {
        this.synchronization = synchronization;
    }

    @Override
    public boolean isComplete() {
        return this.state > 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFailure(Throwable result) {
        if (STATE_FIELD_UPDATER.compareAndSet(this, 0, 1)) {
            this.error = result;
            if (this.synchronization != null) {
                this.synchronization.onPendingFailure(this.error);
            }
            STATE_FIELD_UPDATER.lazySet(this, 3);
            ProviderFuture providerFuture = this;
            synchronized (providerFuture) {
                if (this.waiting > 0) {
                    this.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSuccess() {
        if (STATE_FIELD_UPDATER.compareAndSet(this, 0, 1)) {
            if (this.synchronization != null) {
                this.synchronization.onPendingSuccess();
            }
            STATE_FIELD_UPDATER.lazySet(this, 2);
            ProviderFuture providerFuture = this;
            synchronized (providerFuture) {
                if (this.waiting > 0) {
                    this.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean sync(long amount, TimeUnit unit) throws IOException {
        try {
            if (this.isComplete() || amount == 0L) {
                this.failOnError();
                return true;
            }
            Thread currentThread = Thread.currentThread();
            long timeout = unit.toNanos(amount);
            long maxParkNanos = timeout / 8L;
            maxParkNanos = maxParkNanos > 0L ? maxParkNanos : timeout;
            long tinyParkNanos = Math.min(maxParkNanos, 1L);
            long smallParkNanos = Math.min(maxParkNanos, 10000L);
            long startTime = System.nanoTime();
            int idleCount = 0;
            while (true) {
                if (currentThread.isInterrupted()) {
                    throw new InterruptedException();
                }
                long elapsed = System.nanoTime() - startTime;
                long diff = elapsed - timeout;
                if (diff >= 0L) {
                    this.failOnError();
                    return this.isComplete();
                }
                if (this.isComplete()) {
                    this.failOnError();
                    return true;
                }
                if (idleCount < 10) {
                    ++idleCount;
                    continue;
                }
                if (idleCount < 100) {
                    Thread.yield();
                    ++idleCount;
                    continue;
                }
                if (idleCount < 1000) {
                    LockSupport.parkNanos(tinyParkNanos);
                    ++idleCount;
                    continue;
                }
                if (idleCount < 101000) {
                    LockSupport.parkNanos(smallParkNanos);
                    ++idleCount;
                    continue;
                }
                ProviderFuture providerFuture = this;
                synchronized (providerFuture) {
                    if (this.isComplete()) {
                        this.failOnError();
                        return true;
                    }
                    ++this.waiting;
                    try {
                        this.wait(-diff / 1000000L, (int)(-diff % 1000000L));
                    }
                    finally {
                        --this.waiting;
                    }
                }
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw IOExceptionSupport.create(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sync() throws IOException {
        try {
            if (this.isComplete()) {
                this.failOnError();
                return;
            }
            Thread currentThread = Thread.currentThread();
            int idleCount = 0;
            while (true) {
                if (currentThread.isInterrupted()) {
                    throw new InterruptedException();
                }
                if (this.isComplete()) {
                    this.failOnError();
                    return;
                }
                if (idleCount < 10) {
                    ++idleCount;
                    continue;
                }
                if (idleCount < 100) {
                    Thread.yield();
                    ++idleCount;
                    continue;
                }
                if (idleCount < 1000) {
                    LockSupport.parkNanos(1L);
                    ++idleCount;
                    continue;
                }
                if (idleCount < 101000) {
                    LockSupport.parkNanos(10000L);
                    ++idleCount;
                    continue;
                }
                ProviderFuture providerFuture = this;
                synchronized (providerFuture) {
                    if (this.isComplete()) {
                        this.failOnError();
                        return;
                    }
                    ++this.waiting;
                    try {
                        this.wait();
                    }
                    finally {
                        --this.waiting;
                    }
                }
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw IOExceptionSupport.create(e);
        }
    }

    private void failOnError() throws IOException {
        Throwable cause = this.error;
        if (cause != null) {
            throw IOExceptionSupport.create(cause);
        }
    }
}

