/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.discovery.file;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.qpid.jms.provider.discovery.DiscoveryAgent;
import org.apache.qpid.jms.provider.discovery.DiscoveryListener;
import org.apache.qpid.jms.util.ThreadPoolUtils;
import org.apache.qpid.jms.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileWatcherDiscoveryAgent
implements DiscoveryAgent {
    private static final Logger LOG = LoggerFactory.getLogger(FileWatcherDiscoveryAgent.class);
    private static final int DEFAULT_UPDATE_INTERVAL = 30000;
    private ScheduledExecutorService scheduler;
    private final Set<URI> discovered = new LinkedHashSet<URI>();
    private final URI discoveryURI;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private DiscoveryListener listener;
    private int updateInterval = 30000;
    private boolean warnOnWatchedReadError;

    public FileWatcherDiscoveryAgent(URI discoveryURI) throws URISyntaxException {
        this.discoveryURI = URISupport.removeQuery((URI)discoveryURI);
    }

    @Override
    public void setDiscoveryListener(DiscoveryListener listener) {
        this.listener = listener;
    }

    public DiscoveryListener getDiscoveryListener() {
        return this.listener;
    }

    @Override
    public boolean isSchedulerRequired() {
        return true;
    }

    @Override
    public void setScheduler(ScheduledExecutorService scheduler) {
        this.scheduler = scheduler;
    }

    @Override
    public void start() throws IOException, IllegalStateException {
        if (this.listener == null) {
            throw new IllegalStateException("No DiscoveryListener configured.");
        }
        if (this.scheduler == null) {
            throw new IllegalStateException("No scheduler service has been provided.");
        }
        if (this.started.compareAndSet(false, true)) {
            this.scheduler.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    LOG.debug("Performing watched resources scheduled update: {}", (Object)FileWatcherDiscoveryAgent.this.getDiscvoeryURI());
                    FileWatcherDiscoveryAgent.this.updateWatchedResources();
                }
            }, 0L, this.getUpdateInterval(), TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void close() {
        if (this.started.compareAndSet(true, false)) {
            ThreadPoolUtils.shutdownGraceful((ExecutorService)this.scheduler);
        }
    }

    @Override
    public void suspend() {
    }

    @Override
    public void resume() {
    }

    public String toString() {
        return "FileWatcherDiscoveryAgent: listener:" + this.getDiscvoeryURI();
    }

    public URI getDiscvoeryURI() {
        return this.discoveryURI;
    }

    public int getUpdateInterval() {
        return this.updateInterval;
    }

    public void setUpdateInterval(int updateInterval) {
        this.updateInterval = updateInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateWatchedResources() {
        String fileURL = this.getDiscvoeryURI().toString();
        if (fileURL != null) {
            BufferedReader in = null;
            String newUris = null;
            StringBuffer buffer = new StringBuffer();
            try {
                String line;
                in = new BufferedReader(this.getURLStream(fileURL));
                while ((line = in.readLine()) != null) {
                    buffer.append(line);
                }
                newUris = buffer.toString();
            }
            catch (IOException ioe) {
                if (!this.warnOnWatchedReadError) {
                    LOG.warn("Failed to read watched resource: " + fileURL);
                    LOG.trace("Resource read error:", (Throwable)ioe);
                } else {
                    LOG.debug("Failed to read watched resource: " + fileURL);
                    LOG.trace("Resource read error:", (Throwable)ioe);
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            this.processURIs(newUris);
        }
    }

    private InputStreamReader getURLStream(String path) throws IOException {
        InputStreamReader result = null;
        URL url = null;
        try {
            url = new URL(path);
            result = new InputStreamReader(url.openStream());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (result == null) {
            result = new FileReader(path);
        }
        return result;
    }

    private final void processURIs(String updatedURIs) {
        if (updatedURIs != null && !(updatedURIs = updatedURIs.trim()).isEmpty()) {
            ArrayList<URI> list = new ArrayList<URI>();
            StringTokenizer tokenizer = new StringTokenizer(updatedURIs, ",");
            while (tokenizer.hasMoreTokens()) {
                String str = tokenizer.nextToken();
                try {
                    URI uri = new URI(str);
                    list.add(uri);
                }
                catch (Exception e) {
                    LOG.error("Failed to parse broker address: " + str, (Throwable)e);
                }
            }
            if (!list.isEmpty()) {
                try {
                    this.updateURIs(list);
                }
                catch (IOException e) {
                    LOG.error("Failed to update transport URI's from: " + updatedURIs, (Throwable)e);
                }
            }
        }
    }

    private void updateURIs(List<URI> updates) throws IOException {
        HashSet<URI> removedPeers = new HashSet<URI>(this.discovered);
        removedPeers.removeAll(updates);
        for (URI removed : removedPeers) {
            this.listener.onServiceRemove(removed);
        }
        HashSet<URI> addedPeers = new HashSet<URI>(updates);
        addedPeers.removeAll(this.discovered);
        for (URI addition : addedPeers) {
            this.listener.onServiceAdd(addition);
        }
        this.discovered.clear();
        this.discovered.addAll(updates);
    }
}

