/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp.message;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.qpid.jms.provider.amqp.AmqpConsumer;
import org.apache.qpid.jms.provider.amqp.message.AmqpJmsBytesMessageFacade;
import org.apache.qpid.jms.provider.amqp.message.AmqpJmsMapMessageFacade;
import org.apache.qpid.jms.provider.amqp.message.AmqpJmsMessageFacade;
import org.apache.qpid.jms.provider.amqp.message.AmqpJmsObjectMessageFacade;
import org.apache.qpid.jms.provider.amqp.message.AmqpJmsStreamMessageFacade;
import org.apache.qpid.jms.provider.amqp.message.AmqpJmsTextMessageFacade;
import org.apache.qpid.jms.provider.amqp.message.AmqpMessageSupport;
import org.apache.qpid.jms.provider.amqp.message.AmqpWritableBuffer;
import org.apache.qpid.jms.util.ContentTypeSupport;
import org.apache.qpid.jms.util.InvalidContentTypeException;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.AmqpSequence;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.DeliveryAnnotations;
import org.apache.qpid.proton.amqp.messaging.Footer;
import org.apache.qpid.proton.amqp.messaging.Header;
import org.apache.qpid.proton.amqp.messaging.MessageAnnotations;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.codec.AMQPDefinedTypes;
import org.apache.qpid.proton.codec.Decoder;
import org.apache.qpid.proton.codec.DecoderImpl;
import org.apache.qpid.proton.codec.EncoderImpl;
import org.apache.qpid.proton.codec.ReadableBuffer;
import org.apache.qpid.proton.codec.WritableBuffer;

public final class AmqpCodec {
    private static final ThreadLocal<EncoderDecoderPair> TLS_CODEC = new ThreadLocal<EncoderDecoderPair>(){

        @Override
        protected EncoderDecoderPair initialValue() {
            return new EncoderDecoderPair();
        }
    };

    public static EncoderImpl getEncoder() {
        return AmqpCodec.TLS_CODEC.get().encoder;
    }

    public static DecoderImpl getDecoder() {
        return AmqpCodec.TLS_CODEC.get().decoder;
    }

    public static ByteBuf encode(Section section) {
        if (section == null) {
            return null;
        }
        AmqpWritableBuffer buffer = new AmqpWritableBuffer();
        EncoderImpl encoder = AmqpCodec.getEncoder();
        encoder.setByteBuffer((WritableBuffer)buffer);
        encoder.writeObject((Object)section);
        encoder.setByteBuffer((WritableBuffer)null);
        return buffer.getBuffer();
    }

    public static Section decode(ByteBuf encoded) {
        if (encoded == null || !encoded.isReadable()) {
            return null;
        }
        DecoderImpl decoder = AmqpCodec.TLS_CODEC.get().decoder;
        decoder.setByteBuffer(encoded.nioBuffer());
        Section result = (Section)decoder.readObject();
        decoder.setByteBuffer(null);
        encoded.resetReaderIndex();
        return result;
    }

    public static ByteBuf encodeMessage(AmqpJmsMessageFacade message) {
        AmqpWritableBuffer buffer = new AmqpWritableBuffer();
        EncoderImpl encoder = AmqpCodec.getEncoder();
        encoder.setByteBuffer((WritableBuffer)buffer);
        Header header = message.getHeader();
        DeliveryAnnotations deliveryAnnotations = message.getDeliveryAnnotations();
        MessageAnnotations messageAnnotations = message.getMessageAnnotations();
        Properties properties = message.getProperties();
        ApplicationProperties applicationProperties = message.getApplicationProperties();
        Section body = message.getBody();
        Footer footer = message.getFooter();
        if (header != null) {
            encoder.writeObject((Object)header);
        }
        if (deliveryAnnotations != null) {
            encoder.writeObject((Object)deliveryAnnotations);
        }
        if (messageAnnotations != null) {
            encoder.writeObject((Object)messageAnnotations);
        }
        if (properties != null) {
            encoder.writeObject((Object)properties);
        }
        if (applicationProperties != null) {
            encoder.writeObject((Object)applicationProperties);
        }
        if (body != null) {
            encoder.writeObject((Object)body);
        }
        if (footer != null) {
            encoder.writeObject((Object)footer);
        }
        encoder.setByteBuffer((WritableBuffer)null);
        return buffer.getBuffer();
    }

    public static AmqpJmsMessageFacade decodeMessage(AmqpConsumer consumer, ReadableBuffer messageBytes) throws IOException {
        DecoderImpl decoder = AmqpCodec.getDecoder();
        decoder.setBuffer(messageBytes);
        Header header = null;
        DeliveryAnnotations deliveryAnnotations = null;
        MessageAnnotations messageAnnotations = null;
        Properties properties = null;
        ApplicationProperties applicationProperties = null;
        Section body = null;
        Footer footer = null;
        Object section = null;
        if (messageBytes.hasRemaining()) {
            section = (Section)decoder.readObject();
        }
        if (section instanceof Header) {
            header = (Header)section;
            section = messageBytes.hasRemaining() ? (Section)decoder.readObject() : null;
        }
        if (section instanceof DeliveryAnnotations) {
            deliveryAnnotations = (DeliveryAnnotations)section;
            section = messageBytes.hasRemaining() ? (Section)decoder.readObject() : null;
        }
        if (section instanceof MessageAnnotations) {
            messageAnnotations = (MessageAnnotations)section;
            section = messageBytes.hasRemaining() ? (Section)decoder.readObject() : null;
        }
        if (section instanceof Properties) {
            properties = (Properties)section;
            section = messageBytes.hasRemaining() ? (Section)decoder.readObject() : null;
        }
        if (section instanceof ApplicationProperties) {
            applicationProperties = (ApplicationProperties)section;
            section = messageBytes.hasRemaining() ? (Section)decoder.readObject() : null;
        }
        if (section != null && !(section instanceof Footer)) {
            body = section;
            section = messageBytes.hasRemaining() ? (Section)decoder.readObject() : null;
        }
        if (section instanceof Footer) {
            footer = (Footer)section;
        }
        decoder.setByteBuffer(null);
        AmqpJmsMessageFacade result = AmqpCodec.createFromMsgAnnotation(messageAnnotations);
        if (result == null) {
            result = AmqpCodec.createWithoutAnnotation(body, properties);
        }
        if (result != null) {
            result.setHeader(header);
            result.setDeliveryAnnotations(deliveryAnnotations);
            result.setMessageAnnotations(messageAnnotations);
            result.setProperties(properties);
            result.setApplicationProperties(applicationProperties);
            result.setBody(body);
            result.setFooter(footer);
            result.initialize(consumer);
            return result;
        }
        throw new IOException("Could not create a JMS message from incoming message");
    }

    private static AmqpJmsMessageFacade createFromMsgAnnotation(MessageAnnotations messageAnnotations) throws IOException {
        Object annotation = AmqpMessageSupport.getMessageAnnotation("x-opt-jms-msg-type", messageAnnotations);
        if (annotation != null) {
            switch ((Byte)annotation) {
                case 0: {
                    return new AmqpJmsMessageFacade();
                }
                case 3: {
                    return new AmqpJmsBytesMessageFacade();
                }
                case 5: {
                    return new AmqpJmsTextMessageFacade(StandardCharsets.UTF_8);
                }
                case 2: {
                    return new AmqpJmsMapMessageFacade();
                }
                case 4: {
                    return new AmqpJmsStreamMessageFacade();
                }
                case 1: {
                    return new AmqpJmsObjectMessageFacade();
                }
            }
            throw new IOException("Invalid JMS Message Type annotation value found in message: " + annotation);
        }
        return null;
    }

    private static AmqpJmsMessageFacade createWithoutAnnotation(Section body, Properties properties) {
        Symbol messageContentType;
        Symbol symbol = messageContentType = properties != null ? properties.getContentType() : null;
        if (body == null) {
            if (AmqpMessageSupport.isContentType("application/x-java-serialized-object", messageContentType)) {
                return new AmqpJmsObjectMessageFacade();
            }
            if (AmqpMessageSupport.isContentType("application/octet-stream", messageContentType) || AmqpMessageSupport.isContentType(null, messageContentType)) {
                return new AmqpJmsBytesMessageFacade();
            }
            Charset charset = AmqpCodec.getCharsetForTextualContent(messageContentType);
            if (charset != null) {
                return new AmqpJmsTextMessageFacade(charset);
            }
            return new AmqpJmsMessageFacade();
        }
        if (body instanceof Data) {
            if (AmqpMessageSupport.isContentType("application/octet-stream", messageContentType) || AmqpMessageSupport.isContentType(null, messageContentType)) {
                return new AmqpJmsBytesMessageFacade();
            }
            if (AmqpMessageSupport.isContentType("application/x-java-serialized-object", messageContentType)) {
                return new AmqpJmsObjectMessageFacade();
            }
            Charset charset = AmqpCodec.getCharsetForTextualContent(messageContentType);
            if (charset != null) {
                return new AmqpJmsTextMessageFacade(charset);
            }
            return new AmqpJmsBytesMessageFacade();
        }
        if (body instanceof AmqpValue) {
            Object value = ((AmqpValue)body).getValue();
            if (value == null || value instanceof String) {
                return new AmqpJmsTextMessageFacade(StandardCharsets.UTF_8);
            }
            if (value instanceof Binary) {
                return new AmqpJmsBytesMessageFacade();
            }
            return new AmqpJmsObjectMessageFacade();
        }
        if (body instanceof AmqpSequence) {
            return new AmqpJmsObjectMessageFacade();
        }
        return null;
    }

    private static Charset getCharsetForTextualContent(Symbol messageContentType) {
        if (messageContentType != null) {
            try {
                return ContentTypeSupport.parseContentTypeForTextualCharset(messageContentType.toString());
            }
            catch (InvalidContentTypeException invalidContentTypeException) {
                // empty catch block
            }
        }
        return null;
    }

    private static class EncoderDecoderPair {
        DecoderImpl decoder = new DecoderImpl();
        EncoderImpl encoder = new EncoderImpl(this.decoder);

        private EncoderDecoderPair() {
            AMQPDefinedTypes.registerAllTypes((Decoder)this.decoder, (EncoderImpl)this.encoder);
        }
    }
}

