/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp;

import java.net.URI;
import java.util.Map;
import org.apache.qpid.jms.provider.ProviderFactory;
import org.apache.qpid.jms.provider.amqp.AmqpProvider;
import org.apache.qpid.jms.transports.Transport;
import org.apache.qpid.jms.transports.TransportFactory;
import org.apache.qpid.jms.util.PropertyUtil;

public class AmqpProviderFactory
extends ProviderFactory {
    public static final String DEFAULT_TRANSPORT_SCHEME = "tcp";
    public static final String DEFAULT_PROVIDER_SCHEME = "amqp";
    private String transportScheme = "tcp";
    private String providerScheme = "amqp";

    @Override
    public AmqpProvider createProvider(URI remoteURI) throws Exception {
        Map<String, String> map = PropertyUtil.parseQuery(remoteURI);
        Map<String, String> providerOptions = PropertyUtil.filterProperties(map, "amqp.");
        Transport transport = TransportFactory.create(this.getTransportScheme(), PropertyUtil.replaceQuery(remoteURI, map));
        AmqpProvider result = new AmqpProvider(remoteURI, transport);
        Map<String, String> unused = PropertyUtil.setProperties((Object)result, providerOptions);
        if (!unused.isEmpty()) {
            String msg = " Not all provider options could be set on the AMQP Provider. Check the options are spelled correctly. Unused parameters=[" + unused + "]. This provider instance cannot be started.";
            throw new IllegalArgumentException(msg);
        }
        return result;
    }

    @Override
    public String getName() {
        return "AMQP";
    }

    public String getTransportScheme() {
        return this.transportScheme;
    }

    public void setTransportScheme(String transportScheme) {
        this.transportScheme = transportScheme;
    }

    public String getProviderScheme() {
        return this.providerScheme;
    }

    public void setProviderScheme(String providerScheme) {
        this.providerScheme = providerScheme;
    }
}

