/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp;

import java.io.IOException;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.qpid.jms.provider.ProviderFactory;
import org.apache.qpid.jms.provider.amqp.AmqpProvider;
import org.apache.qpid.jms.provider.amqp.AmqpProviderFactory;
import org.apache.qpid.jms.provider.amqp.AmqpSupport;
import org.apache.qpid.jms.transports.TransportFactory;
import org.apache.qpid.jms.util.FactoryFinder;
import org.apache.qpid.jms.util.PropertyUtil;
import org.apache.qpid.jms.util.URISupport;
import org.apache.qpid.proton.amqp.Symbol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpRedirect {
    private static final Logger LOG = LoggerFactory.getLogger(AmqpRedirect.class);
    private static final FactoryFinder<ProviderFactory> PROVIDER_FACTORY_FINDER = new FactoryFinder<ProviderFactory>(ProviderFactory.class, "META-INF/services/" + ProviderFactory.class.getPackage().getName().replace(".", "/") + "/redirects/");
    private final Map<Symbol, Object> redirect;
    private final AmqpProvider provider;

    public AmqpRedirect(Map<Symbol, Object> redirect, AmqpProvider provider) {
        this.redirect = redirect;
        this.provider = provider;
        if (provider == null) {
            throw new IllegalArgumentException("A provider instance is required");
        }
        URI remoteURI = provider.getRemoteURI();
        if (remoteURI == null || remoteURI.getScheme() == null || remoteURI.getScheme().isEmpty()) {
            throw new IllegalArgumentException("The provider instance must provide a valid scheme");
        }
    }

    public AmqpRedirect validate() throws Exception {
        String networkHost = (String)this.redirect.get(AmqpSupport.NETWORK_HOST);
        if (networkHost == null || networkHost.isEmpty()) {
            throw new IOException("Redirection information not set, missing network host.");
        }
        try {
            Integer.parseInt(this.redirect.get(AmqpSupport.PORT).toString());
        }
        catch (Exception ex) {
            throw new IOException("Redirection information contained invalid port.");
        }
        String sourceScheme = this.provider.getRemoteURI().getScheme();
        String scheme = (String)this.redirect.get(AmqpSupport.SCHEME);
        if (scheme != null && !scheme.isEmpty() && !scheme.equals(sourceScheme)) {
            ProviderFactory factory = null;
            try {
                factory = ProviderFactory.findProviderFactory(scheme);
            }
            catch (Throwable error) {
                LOG.trace("Couldn't find AMQP prefixed Provider using scheme: {}", (Object)scheme);
            }
            if (factory == null) {
                try {
                    factory = AmqpRedirect.findProviderFactoryByTransportScheme(scheme);
                }
                catch (Throwable error) {
                    LOG.trace("Couldn't find Provider using transport scheme: {}", (Object)scheme);
                }
            }
            if (factory == null || !(factory instanceof AmqpProviderFactory)) {
                throw new IOException("Redirect contained an unknown provider scheme: " + scheme);
            }
            LOG.trace("Found provider: {} for redirect: {}", (Object)factory.getName(), (Object)scheme);
            AmqpProviderFactory amqpFactory = (AmqpProviderFactory)factory;
            String transportType = amqpFactory.getTransportScheme();
            if (transportType == null || transportType.isEmpty()) {
                throw new IOException("Redirect contained an unknown provider scheme: " + scheme);
            }
            TransportFactory transportFactory = TransportFactory.findTransportFactory(transportType);
            if (transportFactory == null) {
                throw new IOException("Redirect contained an unknown provider scheme: " + scheme);
            }
            if (this.provider.getTransport().isSecure() && !transportFactory.isSecure() && !this.provider.isAllowNonSecureRedirects()) {
                throw new IOException("Attempt to redirect to an insecure connection type: " + transportType);
            }
            this.redirect.put(AmqpSupport.SCHEME, amqpFactory.getProviderScheme());
        }
        this.toURI();
        return this;
    }

    public Map<Symbol, Object> getRedirectMap() {
        return this.redirect;
    }

    public String getHostname() {
        return (String)this.redirect.get(AmqpSupport.OPEN_HOSTNAME);
    }

    public String getNetworkHost() {
        return (String)this.redirect.get(AmqpSupport.NETWORK_HOST);
    }

    public int getPort() {
        return Integer.parseInt(this.redirect.get(AmqpSupport.PORT).toString());
    }

    public String getScheme() {
        String scheme = (String)this.redirect.get(AmqpSupport.SCHEME);
        if (scheme == null || scheme.isEmpty()) {
            scheme = this.provider.getRemoteURI().getScheme();
        }
        return scheme;
    }

    public String getPath() {
        return (String)this.redirect.get(AmqpSupport.PATH);
    }

    public URI toURI() throws Exception {
        Map<String, String> queryOptions = PropertyUtil.parseQuery(this.provider.getRemoteURI());
        URI result = new URI(this.getScheme(), null, this.getNetworkHost(), this.getPort(), this.getPath(), null, null);
        String hostname = this.getHostname();
        if (hostname != null && !hostname.isEmpty()) {
            queryOptions = new LinkedHashMap<String, String>(queryOptions);
            queryOptions.put("amqp.vhost", hostname);
        }
        return URISupport.applyParameters(result, queryOptions);
    }

    private static ProviderFactory findProviderFactoryByTransportScheme(String scheme) throws IOException {
        if (scheme == null || scheme.isEmpty()) {
            throw new IOException("No Transport scheme specified.");
        }
        ProviderFactory factory = null;
        try {
            factory = PROVIDER_FACTORY_FINDER.newInstance(scheme);
        }
        catch (Throwable e) {
            throw new IOException("Provider NOT found using redirect scheme: [" + scheme + "]", e);
        }
        return factory;
    }
}

