/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.oxia;

import java.time.Duration;
import org.apache.pulsar.tests.integration.containers.ChaosContainer;
import org.apache.pulsar.tests.integration.containers.PulsarContainer;
import org.testcontainers.containers.wait.strategy.Wait;

public class OxiaContainer
extends ChaosContainer<OxiaContainer> {
    public static final String NAME = "oxia";
    public static final int OXIA_PORT = 6648;
    public static final int METRICS_PORT = 8080;
    private static final int DEFAULT_SHARDS = 1;
    private static final String DEFAULT_IMAGE_NAME = "streamnative/oxia:main";

    public OxiaContainer(String clusterName) {
        this(clusterName, DEFAULT_IMAGE_NAME, 1);
    }

    OxiaContainer(String clusterName, String imageName, int shards) {
        super(clusterName, imageName);
        if (shards <= 0) {
            throw new IllegalArgumentException("shards must be greater than zero");
        }
        this.addExposedPorts(new int[]{6648, 8080});
        this.withCreateContainerCmdModifier(createContainerCmd -> {
            createContainerCmd.withHostName(NAME);
            createContainerCmd.withName(this.getContainerName());
        });
        this.setCommand(new String[]{NAME, "standalone", "--shards=" + shards, "--wal-sync-data=false"});
        this.waitingFor(Wait.forHttp((String)"/metrics").forPort(8080).forStatusCode(200).withStartupTimeout(Duration.ofSeconds(30L)));
        PulsarContainer.configureLeaveContainerRunning(this);
    }

    public String getServiceAddress() {
        return "oxia:6648";
    }

    public String getContainerName() {
        return this.clusterName + "-oxia";
    }
}

