/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.metrics;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pulsar.PulsarVersion;
import org.apache.pulsar.broker.stats.prometheus.PrometheusMetricsClient;
import org.apache.pulsar.tests.integration.containers.ChaosContainer;
import org.apache.pulsar.tests.integration.containers.OpenTelemetryCollectorContainer;
import org.apache.pulsar.tests.integration.topologies.FunctionRuntimeType;
import org.apache.pulsar.tests.integration.topologies.PulsarCluster;
import org.apache.pulsar.tests.integration.topologies.PulsarClusterSpec;
import org.apache.pulsar.tests.integration.topologies.PulsarTestBase;
import org.awaitility.Awaitility;
import org.testng.annotations.Test;

public class OpenTelemetrySanityTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeOut=360000L)
    public void testOpenTelemetryMetricsOtlpExport() throws Exception {
        String clusterName = "testOpenTelemetryMetrics-" + UUID.randomUUID();
        OpenTelemetryCollectorContainer openTelemetryCollectorContainer = new OpenTelemetryCollectorContainer(clusterName);
        String exporter = "otlp";
        Pair otlpEndpointProp = Pair.of((Object)"OTEL_EXPORTER_OTLP_ENDPOINT", (Object)openTelemetryCollectorContainer.getOtlpEndpoint());
        Map<String, String> brokerCollectorProps = OpenTelemetrySanityTest.getOpenTelemetryProps(exporter, otlpEndpointProp);
        Map<String, String> proxyCollectorProps = OpenTelemetrySanityTest.getOpenTelemetryProps(exporter, otlpEndpointProp);
        Map<String, String> functionWorkerCollectorProps = OpenTelemetrySanityTest.getOpenTelemetryProps(exporter, otlpEndpointProp);
        PulsarClusterSpec spec = PulsarClusterSpec.builder().clusterName(clusterName).brokerEnvs(brokerCollectorProps).proxyEnvs(proxyCollectorProps).externalService("otel-collector", openTelemetryCollectorContainer).functionWorkerEnvs(functionWorkerCollectorProps).build();
        PulsarCluster pulsarCluster = PulsarCluster.forSpec(spec);
        try {
            pulsarCluster.start();
            pulsarCluster.setupFunctionWorkers(PulsarTestBase.randomName(), FunctionRuntimeType.PROCESS, 1);
            String metricName = "queueSize_ratio";
            Awaitility.waitAtMost((long)90L, (TimeUnit)TimeUnit.SECONDS).ignoreExceptions().pollInterval(1L, TimeUnit.SECONDS).until(() -> {
                PrometheusMetricsClient.Metrics metrics = OpenTelemetrySanityTest.getMetricsFromPrometheus(openTelemetryCollectorContainer, 8889);
                return !metrics.findByNameAndLabels(metricName, "job", "pulsar-broker").isEmpty();
            });
            Awaitility.waitAtMost((long)90L, (TimeUnit)TimeUnit.SECONDS).ignoreExceptions().pollInterval(1L, TimeUnit.SECONDS).until(() -> {
                PrometheusMetricsClient.Metrics metrics = OpenTelemetrySanityTest.getMetricsFromPrometheus(openTelemetryCollectorContainer, 8889);
                return !metrics.findByNameAndLabels(metricName, "job", "pulsar-proxy").isEmpty();
            });
            Awaitility.waitAtMost((long)90L, (TimeUnit)TimeUnit.SECONDS).ignoreExceptions().pollInterval(1L, TimeUnit.SECONDS).until(() -> {
                PrometheusMetricsClient.Metrics metrics = OpenTelemetrySanityTest.getMetricsFromPrometheus(openTelemetryCollectorContainer, 8889);
                return !metrics.findByNameAndLabels(metricName, "job", "pulsar-function-worker").isEmpty();
            });
        }
        finally {
            if (Collections.singletonList(pulsarCluster).get(0) != null) {
                pulsarCluster.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeOut=360000L)
    public void testOpenTelemetryMetricsPrometheusExport() throws Exception {
        int prometheusExporterPort = 9464;
        String clusterName = "testOpenTelemetryMetrics-" + UUID.randomUUID();
        String exporter = "prometheus";
        Pair prometheusExporterPortProp = Pair.of((Object)"OTEL_EXPORTER_PROMETHEUS_PORT", (Object)Integer.toString(prometheusExporterPort));
        Map<String, String> brokerCollectorProps = OpenTelemetrySanityTest.getOpenTelemetryProps(exporter, prometheusExporterPortProp);
        Map<String, String> proxyCollectorProps = OpenTelemetrySanityTest.getOpenTelemetryProps(exporter, prometheusExporterPortProp);
        Map<String, String> functionWorkerCollectorProps = OpenTelemetrySanityTest.getOpenTelemetryProps(exporter, prometheusExporterPortProp);
        PulsarClusterSpec spec = PulsarClusterSpec.builder().clusterName(clusterName).brokerEnvs(brokerCollectorProps).brokerAdditionalPorts(List.of(Integer.valueOf(prometheusExporterPort))).proxyEnvs(proxyCollectorProps).proxyAdditionalPorts(List.of(Integer.valueOf(prometheusExporterPort))).functionWorkerEnvs(functionWorkerCollectorProps).functionWorkerAdditionalPorts(List.of(Integer.valueOf(prometheusExporterPort))).build();
        PulsarCluster pulsarCluster = PulsarCluster.forSpec(spec);
        try {
            pulsarCluster.start();
            pulsarCluster.setupFunctionWorkers(PulsarTestBase.randomName(), FunctionRuntimeType.PROCESS, 1);
            String metricName = "target_info";
            Awaitility.waitAtMost((long)90L, (TimeUnit)TimeUnit.SECONDS).ignoreExceptions().pollInterval(1L, TimeUnit.SECONDS).until(() -> {
                PrometheusMetricsClient.Metrics metrics = OpenTelemetrySanityTest.getMetricsFromPrometheus(pulsarCluster.getBroker(0), prometheusExporterPort);
                return !metrics.findByNameAndLabels(metricName, new Pair[]{Pair.of((Object)"pulsar_cluster", (Object)clusterName), Pair.of((Object)"service_name", (Object)"pulsar-broker"), Pair.of((Object)"service_version", (Object)PulsarVersion.getVersion()), Pair.of((Object)"host_name", (Object)pulsarCluster.getBroker(0).getHostname())}).isEmpty();
            });
            Awaitility.waitAtMost((long)90L, (TimeUnit)TimeUnit.SECONDS).ignoreExceptions().pollInterval(1L, TimeUnit.SECONDS).until(() -> {
                PrometheusMetricsClient.Metrics metrics = OpenTelemetrySanityTest.getMetricsFromPrometheus(pulsarCluster.getProxy(), prometheusExporterPort);
                return !metrics.findByNameAndLabels(metricName, new Pair[]{Pair.of((Object)"pulsar_cluster", (Object)clusterName), Pair.of((Object)"service_name", (Object)"pulsar-proxy"), Pair.of((Object)"service_version", (Object)PulsarVersion.getVersion()), Pair.of((Object)"host_name", (Object)pulsarCluster.getProxy().getHostname())}).isEmpty();
            });
            Awaitility.waitAtMost((long)90L, (TimeUnit)TimeUnit.SECONDS).ignoreExceptions().pollInterval(1L, TimeUnit.SECONDS).until(() -> {
                PrometheusMetricsClient.Metrics metrics = OpenTelemetrySanityTest.getMetricsFromPrometheus(pulsarCluster.getAnyWorker(), prometheusExporterPort);
                return !metrics.findByNameAndLabels(metricName, new Pair[]{Pair.of((Object)"pulsar_cluster", (Object)clusterName), Pair.of((Object)"service_name", (Object)"pulsar-function-worker"), Pair.of((Object)"service_version", (Object)PulsarVersion.getVersion()), Pair.of((Object)"host_name", (Object)pulsarCluster.getAnyWorker().getHostname())}).isEmpty();
            });
        }
        finally {
            if (Collections.singletonList(pulsarCluster).get(0) != null) {
                pulsarCluster.stop();
            }
        }
    }

    private static PrometheusMetricsClient.Metrics getMetricsFromPrometheus(ChaosContainer<?> container, int port) {
        PrometheusMetricsClient client = new PrometheusMetricsClient(container.getHost(), container.getMappedPort(port).intValue());
        return client.getMetrics();
    }

    private static Map<String, String> getOpenTelemetryProps(String exporter, Pair<String, String> ... extraProps) {
        Map<String, String> defaultProps = Map.of("OTEL_SDK_DISABLED", "false", "OTEL_METRIC_EXPORT_INTERVAL", "1000", "OTEL_METRICS_EXPORTER", exporter);
        HashMap<String, String> props = new HashMap<String, String>(defaultProps);
        Arrays.stream(extraProps).forEach(p -> props.put((String)p.getKey(), (String)p.getValue()));
        return props;
    }
}

