/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.io.sources.debezium;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.apache.pulsar.tests.integration.containers.DebeziumOracleDbContainer;
import org.apache.pulsar.tests.integration.docker.ContainerExecResult;
import org.apache.pulsar.tests.integration.io.sources.SourceTester;
import org.apache.pulsar.tests.integration.topologies.PulsarCluster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.util.Strings;

public class DebeziumOracleDbSourceTester
extends SourceTester<DebeziumOracleDbContainer> {
    private static final Logger log = LoggerFactory.getLogger(DebeziumOracleDbSourceTester.class);
    private static final String NAME = "debezium-oracle";
    private static final long SLEEP_AFTER_COMMAND_MS = 30000L;
    private final String pulsarServiceUrl;
    private DebeziumOracleDbContainer debeziumOracleDbContainer;
    private final PulsarCluster pulsarCluster;

    public DebeziumOracleDbSourceTester(PulsarCluster cluster) {
        super(NAME);
        this.pulsarCluster = cluster;
        this.numEntriesToInsert = 1;
        this.numEntriesExpectAfterStart = 0;
        this.pulsarServiceUrl = "pulsar://pulsar-proxy:6650";
        this.sourceConfig.put("database.hostname", "debezium-oracledb-12c");
        this.sourceConfig.put("database.port", "1521");
        this.sourceConfig.put("database.user", "dbzuser");
        this.sourceConfig.put("database.password", "dbz");
        this.sourceConfig.put("database.server.name", "XE");
        this.sourceConfig.put("database.dbname", "XE");
        this.sourceConfig.put("snapshot.mode", "schema_only");
        this.sourceConfig.put("schema.include.list", "inv");
        this.sourceConfig.put("database.history.pulsar.service.url", this.pulsarServiceUrl);
        this.sourceConfig.put("topic.namespace", "debezium/oracle");
    }

    @Override
    public void setServiceContainer(DebeziumOracleDbContainer container) {
        log.info("start debezium oracle server container.");
        Preconditions.checkState((this.debeziumOracleDbContainer == null ? 1 : 0) != 0);
        this.debeziumOracleDbContainer = container;
        this.pulsarCluster.startService("debezium-oracledb-12c", this.debeziumOracleDbContainer);
    }

    @Override
    public void prepareSource() {
        String[] minerCommands = new String[]{"ALTER DATABASE ADD SUPPLEMENTAL LOG DATA;", "ALTER DATABASE ADD SUPPLEMENTAL LOG DATA (PRIMARY KEY) COLUMNS;", "alter system switch logfile;"};
        String[] commands = new String[]{"CREATE TABLESPACE inv DATAFILE 'tbs_inv01.dbf' SIZE 200M LOGGING;", "CREATE USER inv identified by inv default tablespace inv;", "GRANT CREATE TABLE TO inv;", "GRANT LOCK ANY TABLE TO inv;", "GRANT ALTER ANY TABLE TO inv;", "GRANT CREATE SEQUENCE TO inv;", "GRANT UNLIMITED TABLESPACE TO inv;", "CREATE TABLE inv.customers (id NUMBER(9) GENERATED BY DEFAULT ON NULL AS IDENTITY (START WITH 1001) NOT NULL PRIMARY KEY,first_name VARCHAR2(255) NOT NULL,last_name VARCHAR2(255) NOT NULL,email VARCHAR2(255) NOT NULL);", "ALTER TABLE inv.customers ADD SUPPLEMENTAL LOG DATA (ALL) COLUMNS;", "create role dbz_privs;", "grant create session, execute_catalog_role, select any transaction, select any dictionary to dbz_privs;", "grant select on SYSTEM.LOGMNR_COL$ to dbz_privs;", "grant select on SYSTEM.LOGMNR_OBJ$ to dbz_privs;", "grant select on SYSTEM.LOGMNR_USER$ to dbz_privs;", "grant select on SYSTEM.LOGMNR_UID$ to dbz_privs;", "create user dbzuser identified by dbz default tablespace users;", "grant dbz_privs to dbzuser;", "alter user dbzuser quota unlimited on users;", "grant LOGMINING to dbz_privs;", "GRANT CREATE SESSION TO dbzuser;", "GRANT SET CONTAINER TO dbzuser;", "GRANT SELECT ON V_$DATABASE to dbzuser;", "GRANT FLASHBACK ANY TABLE TO dbzuser;", "GRANT SELECT ANY TABLE TO dbzuser;", "GRANT SELECT_CATALOG_ROLE TO dbzuser;", "GRANT EXECUTE_CATALOG_ROLE TO dbzuser;", "GRANT SELECT ANY TRANSACTION TO dbzuser;", "GRANT LOGMINING TO dbzuser;", "GRANT CREATE TABLE TO dbzuser;", "GRANT LOCK ANY TABLE TO dbzuser;", "GRANT ALTER ANY TABLE TO dbzuser;", "GRANT CREATE SEQUENCE TO dbzuser;", "GRANT EXECUTE ON DBMS_LOGMNR TO dbzuser;", "GRANT EXECUTE ON DBMS_LOGMNR_D TO dbzuser;", "GRANT SELECT ON V_$LOG TO dbzuser;", "GRANT SELECT ON V_$LOG_HISTORY TO dbzuser;", "GRANT SELECT ON V_$LOGMNR_LOGS TO dbzuser;", "GRANT SELECT ON V_$LOGMNR_CONTENTS TO dbzuser;", "GRANT SELECT ON V_$LOGMNR_PARAMETERS TO dbzuser;", "GRANT SELECT ON V_$LOGFILE TO dbzuser;", "GRANT SELECT ON V_$ARCHIVED_LOG TO dbzuser;", "GRANT SELECT ON V_$ARCHIVE_DEST_STATUS TO dbzuser;"};
        this.waitForOracleStatus("OPEN");
        Thread.sleep(30000L);
        this.runSqlCmd("shutdown immediate");
        this.waitForOracleStatus("ORACLE not available");
        Thread.sleep(30000L);
        this.runSqlCmd("startup mount");
        this.waitForOracleStatus("MOUNTED");
        Thread.sleep(30000L);
        this.runSqlCmd("alter database archivelog;");
        this.runSqlCmd("alter database open;");
        this.waitForOracleStatus("OPEN");
        Thread.sleep(30000L);
        for (String cmd : minerCommands) {
            this.runSqlCmd(cmd);
        }
        for (String cmd : commands) {
            this.runSqlCmd(cmd);
        }
        this.runSqlCmd("INSERT INTO inv.customers (first_name, last_name, email) VALUES ('James', 'Bond', 'jbond@null.dev');");
    }

    private void waitForOracleStatus(String status) throws Exception {
        for (int i = 0; i < 1000; ++i) {
            ContainerExecResult response = this.runSqlCmd("SELECT INSTANCE_NAME, STATUS, DATABASE_STATUS FROM V$INSTANCE;");
            if (response.getStderr() != null && response.getStderr().contains(status) || response.getStdout() != null && response.getStdout().contains(status)) {
                return;
            }
            Thread.sleep(1000L);
        }
        throw new IllegalStateException("Oracle did not initialize properly");
    }

    private ContainerExecResult runSqlCmd(String cmd) throws Exception {
        log.info("Executing \"{}\"", (Object)cmd);
        ContainerExecResult response = this.debeziumOracleDbContainer.execCmdAsUser("oracle", "/bin/bash", "-c", "echo \"exit;\" | echo \"" + cmd.replace("$", "\\$") + "\" | sqlplus sys/oracle as sysdba");
        if (Strings.isNullOrEmpty((String)response.getStderr())) {
            log.info("Result of \"{}\":\n{}", (Object)cmd, (Object)response.getStdout());
        } else {
            log.warn("Result of \"{}\":\n{}\n{}", new Object[]{cmd, response.getStdout(), response.getStderr()});
        }
        return response;
    }

    @Override
    public void prepareInsertEvent() throws Exception {
        this.runSqlCmd("INSERT INTO inv.customers (first_name, last_name, email) VALUES ('John', 'Doe', 'jdoe@null.dev');");
        this.runSqlCmd("SELECT * FROM inv.customers WHERE last_name='Doe';");
    }

    @Override
    public void prepareDeleteEvent() throws Exception {
        this.runSqlCmd("DELETE FROM inv.customers WHERE last_name='Doe';");
        this.runSqlCmd("SELECT * FROM inv.customers WHERE last_name='Doe';");
    }

    @Override
    public void prepareUpdateEvent() throws Exception {
        this.runSqlCmd("UPDATE inv.customers SET first_name='Jack' WHERE last_name='Doe';");
        this.runSqlCmd("SELECT * FROM inv.customers WHERE last_name='Doe';");
    }

    @Override
    public Map<String, String> produceSourceMessages(int numMessages) {
        log.info("debezium oracle server already contains preconfigured data.");
        return null;
    }

    @Override
    public int initialDelayForMsgReceive() {
        return 30;
    }

    @Override
    public String keyContains() {
        return "XE.INV.CUSTOMERS.Key";
    }

    @Override
    public String valueContains() {
        return "XE.INV.CUSTOMERS.Value";
    }

    @Override
    public void close() {
        if (this.pulsarCluster != null && this.debeziumOracleDbContainer != null) {
            PulsarCluster.stopService("debezium-oracledb-12c", this.debeziumOracleDbContainer);
            this.debeziumOracleDbContainer = null;
        }
    }

    public DebeziumOracleDbContainer getDebeziumOracleDbContainer() {
        return this.debeziumOracleDbContainer;
    }
}

