/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.io.sources;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.schema.Field;
import org.apache.pulsar.client.api.schema.GenericRecord;
import org.apache.pulsar.common.schema.KeyValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testng.Assert;
import org.testng.collections.Maps;

public abstract class SourceTester<ServiceContainerT extends GenericContainer>
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(SourceTester.class);
    public static final String INSERT = "INSERT";
    public static final String DELETE = "DELETE";
    public static final String UPDATE = "UPDATE";
    protected final String sourceType;
    protected final Map<String, Object> sourceConfig;
    protected int numEntriesToInsert = 1;
    protected int numEntriesExpectAfterStart = 9;
    public static final Set<String> DEBEZIUM_FIELD_SET = new HashSet<String>(){
        {
            this.add("before");
            this.add("after");
            this.add("source");
            this.add("op");
            this.add("ts_ms");
            this.add("transaction");
        }
    };

    protected SourceTester(String sourceType) {
        this.sourceType = sourceType;
        this.sourceConfig = Maps.newHashMap();
    }

    public abstract void setServiceContainer(ServiceContainerT var1);

    public String sourceType() {
        return this.sourceType;
    }

    public Map<String, Object> sourceConfig() {
        return this.sourceConfig;
    }

    public abstract void prepareSource() throws Exception;

    public abstract void prepareInsertEvent() throws Exception;

    public abstract void prepareDeleteEvent() throws Exception;

    public abstract void prepareUpdateEvent() throws Exception;

    public abstract Map<String, String> produceSourceMessages(int var1) throws Exception;

    public void validateSourceResult(Consumer consumer, int number, String eventType, String converterClassName) throws Exception {
        this.doPreValidationCheck(eventType);
        if (converterClassName.endsWith("AvroConverter")) {
            this.validateSourceResultAvro((Consumer<KeyValue<GenericRecord, GenericRecord>>)consumer, number, eventType);
        } else {
            this.validateSourceResultJson((Consumer<KeyValue<byte[], byte[]>>)consumer, number, eventType);
        }
        this.doPostValidationCheck(eventType);
    }

    public void doPreValidationCheck(String eventType) {
        log.info("pre-validation of {}", (Object)eventType);
    }

    public void doPostValidationCheck(String eventType) {
        log.info("post-validation of {}", (Object)eventType);
    }

    public void validateSourceResultJson(Consumer<KeyValue<byte[], byte[]>> consumer, int number, String eventType) throws Exception {
        int recordsNumber = 0;
        Message msg = consumer.receive(this.initialDelayForMsgReceive(), TimeUnit.SECONDS);
        while (msg != null) {
            ++recordsNumber;
            String key = new String((byte[])((KeyValue)msg.getValue()).getKey());
            String value = new String((byte[])((KeyValue)msg.getValue()).getValue());
            log.info("Received message: key = {}, value = {}.", (Object)key, (Object)value);
            Assert.assertTrue((boolean)key.contains(this.keyContains()));
            Assert.assertTrue((boolean)value.contains(this.valueContains()));
            if (eventType != null) {
                Assert.assertTrue((boolean)value.contains(this.eventContains(eventType, true)));
            }
            consumer.acknowledge(msg);
            msg = consumer.receive(1, TimeUnit.SECONDS);
        }
        Assert.assertEquals((int)recordsNumber, (int)number);
        log.info("Stop {} server container. topic: {} has {} records.", new Object[]{this.getSourceType(), consumer.getTopic(), recordsNumber});
    }

    public void validateSourceResultAvro(Consumer<KeyValue<GenericRecord, GenericRecord>> consumer, int number, String eventType) throws Exception {
        int recordsNumber = 0;
        Message msg = consumer.receive(this.initialDelayForMsgReceive(), TimeUnit.SECONDS);
        while (msg != null) {
            ++recordsNumber;
            GenericRecord keyRecord = (GenericRecord)((KeyValue)msg.getValue()).getKey();
            Assert.assertNotNull((Object)keyRecord.getFields());
            Assert.assertTrue((keyRecord.getFields().size() > 0 ? 1 : 0) != 0);
            GenericRecord valueRecord = (GenericRecord)((KeyValue)msg.getValue()).getValue();
            Assert.assertNotNull((Object)valueRecord.getFields());
            Assert.assertTrue((valueRecord.getFields().size() > 0 ? 1 : 0) != 0);
            log.info("Received message: key = {}, value = {}.", keyRecord.getNativeObject(), valueRecord.getNativeObject());
            for (Field field : valueRecord.getFields()) {
                log.info("validating field {}", (Object)field.getName());
                Assert.assertTrue((boolean)DEBEZIUM_FIELD_SET.contains(field.getName()));
            }
            if (eventType != null) {
                String op = valueRecord.getField("op").toString();
                Assert.assertEquals((String)this.eventContains(eventType, false), (String)op);
            }
            consumer.acknowledge(msg);
            msg = consumer.receive(1, TimeUnit.SECONDS);
        }
        Assert.assertEquals((int)recordsNumber, (int)number);
        log.info("Stop {} server container. topic: {} has {} records.", new Object[]{this.getSourceType(), consumer.getTopic(), recordsNumber});
    }

    public int initialDelayForMsgReceive() {
        return 2;
    }

    public String keyContains() {
        return "dbserver1.inventory.products.Key";
    }

    public String valueContains() {
        return "dbserver1.inventory.products.Value";
    }

    public String eventContains(String eventType, boolean isJson) {
        if (eventType.equals(INSERT)) {
            return isJson ? "\"op\":\"c\"" : "c";
        }
        if (eventType.equals(UPDATE)) {
            return isJson ? "\"op\":\"u\"" : "u";
        }
        return isJson ? "\"op\":\"d\"" : "d";
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public Map<String, Object> getSourceConfig() {
        return this.sourceConfig;
    }

    public int getNumEntriesToInsert() {
        return this.numEntriesToInsert;
    }

    public int getNumEntriesExpectAfterStart() {
        return this.numEntriesExpectAfterStart;
    }
}

