/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.io.sinks;

import org.apache.pulsar.tests.integration.io.PulsarIOTestBase;
import org.apache.pulsar.tests.integration.io.RabbitMQSinkTester;
import org.apache.pulsar.tests.integration.io.RabbitMQSourceTester;
import org.apache.pulsar.tests.integration.io.sinks.CassandraSinkTester;
import org.apache.pulsar.tests.integration.io.sinks.ElasticSearch7SinkTester;
import org.apache.pulsar.tests.integration.io.sinks.ElasticSearch8SinkTester;
import org.apache.pulsar.tests.integration.io.sinks.HdfsSinkTester;
import org.apache.pulsar.tests.integration.io.sinks.JdbcPostgresSinkTester;
import org.apache.pulsar.tests.integration.io.sinks.KafkaSinkTester;
import org.apache.pulsar.tests.integration.io.sinks.KinesisSinkTester;
import org.apache.pulsar.tests.integration.io.sinks.OpenSearchSinkTester;
import org.apache.pulsar.tests.integration.io.sources.KafkaSourceTester;
import org.apache.pulsar.tests.integration.topologies.FunctionRuntimeType;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class PulsarSinksTest
extends PulsarIOTestBase {
    public PulsarSinksTest() {
        super(FunctionRuntimeType.PROCESS);
    }

    @DataProvider(name="withSchema")
    public Object[][] withSchema() {
        return new Object[][]{{Boolean.TRUE}, {Boolean.FALSE}};
    }

    @Test(groups={"sink"})
    public void testKafkaSink() throws Exception {
        String kafkaContainerName = "kafka-" + PulsarSinksTest.randomName(8);
        this.testSink(new KafkaSinkTester(kafkaContainerName), true, new KafkaSourceTester(kafkaContainerName));
    }

    @Test(groups={"sink"})
    public void testCassandraSink() throws Exception {
        this.testSink(CassandraSinkTester.createTester(true), true);
    }

    @Test(groups={"sink"})
    public void testCassandraArchiveSink() throws Exception {
        this.testSink(CassandraSinkTester.createTester(false), false);
    }

    @Test(enabled=false, groups={"sink"})
    public void testHdfsSink() throws Exception {
        this.testSink(new HdfsSinkTester(), false);
    }

    @Test(groups={"sink"}, dataProvider="withSchema")
    public void testJdbcSink(boolean kvSchema) throws Exception {
        this.testSink(new JdbcPostgresSinkTester(kvSchema), true);
    }

    @Test(groups={"sink"}, dataProvider="withSchema")
    public void testElasticSearch7Sink(boolean withSchema) throws Exception {
        this.testSink(new ElasticSearch7SinkTester(withSchema), true);
    }

    @Test(groups={"sink"}, dataProvider="withSchema")
    public void testElasticSearch8Sink(boolean withSchema) throws Exception {
        this.testSink(new ElasticSearch8SinkTester(withSchema), true);
    }

    @Test(groups={"sink"}, dataProvider="withSchema")
    public void testOpenSearchSinkRawData(boolean withSchema) throws Exception {
        this.testSink(new OpenSearchSinkTester(withSchema), true);
    }

    @Test(groups={"sink"})
    public void testRabbitMQSink() throws Exception {
        String containerName = "rabbitmq-" + PulsarSinksTest.randomName(8);
        this.testSink(new RabbitMQSinkTester(containerName), true, new RabbitMQSourceTester(containerName));
    }

    @Test(groups={"sink"}, dataProvider="withSchema")
    public void testKinesis(boolean withSchema) throws Exception {
        this.testSink(new KinesisSinkTester(withSchema), true);
    }
}

