/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.io.sinks;

import java.util.Map;
import org.apache.pulsar.tests.integration.containers.HdfsContainer;
import org.apache.pulsar.tests.integration.io.sinks.SinkTester;
import org.apache.pulsar.tests.integration.topologies.PulsarCluster;

public class HdfsSinkTester
extends SinkTester<HdfsContainer> {
    private static final String NAME = "HDFS";

    public HdfsSinkTester() {
        super(NAME, SinkTester.SinkType.HDFS);
        this.sinkConfig.put("hdfsConfigResources", "");
        this.sinkConfig.put("directory", "/testing/test");
    }

    @Override
    protected HdfsContainer createSinkService(PulsarCluster cluster) {
        return new HdfsContainer(cluster.getClusterName());
    }

    @Override
    public void prepareSink() throws Exception {
        ((HdfsContainer)this.serviceContainer).execInContainer(new String[]{"/hadoop/bin/hdfs", "dfs", "-mkdir", "/tmp/testing"});
        ((HdfsContainer)this.serviceContainer).execInContainer(new String[]{"/hadoop/bin/hdfs", "-chown", "tester:testing", "/tmp/testing"});
        ((HdfsContainer)this.serviceContainer).execInContainer(new String[]{"export HADOOP_USER_NAME=tester"});
    }

    @Override
    public void validateSinkResult(Map<String, String> kvs) {
    }

    @Override
    public void close() throws Exception {
    }
}

