/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.containers;

import java.io.IOException;
import org.apache.pulsar.tests.integration.containers.PulsarContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;

public class PulsarInitMetadataContainer
extends GenericContainer<PulsarInitMetadataContainer> {
    private static final Logger log = LoggerFactory.getLogger(PulsarInitMetadataContainer.class);
    public static final String NAME = "init-metadata";
    private final String clusterName;
    private final String metadataStoreUrl;
    private final String configurationMetadataStoreUrl;
    private final String brokerHostname;

    public PulsarInitMetadataContainer(Network network, String clusterName, String metadataStoreUrl, String configurationMetadataStoreUrl, String brokerHostname) {
        this.clusterName = clusterName;
        this.metadataStoreUrl = metadataStoreUrl;
        this.configurationMetadataStoreUrl = configurationMetadataStoreUrl;
        this.brokerHostname = brokerHostname;
        this.setDockerImageName(PulsarContainer.DEFAULT_IMAGE_NAME);
        this.withNetwork(network);
        this.setCommand("sleep 1000000");
    }

    public void initialize() throws Exception {
        this.start();
        Container.ExecResult res = this.execInContainer(new String[]{"/pulsar/bin/pulsar", "initialize-cluster-metadata", "--cluster", this.clusterName, "--metadata-store", this.metadataStoreUrl, "--configuration-metadata-store", this.configurationMetadataStoreUrl, "--web-service-url", "http://" + this.brokerHostname + ":8080/", "--broker-service-url", "pulsar://" + this.brokerHostname + ":6650/"});
        if (res.getExitCode() != 0) {
            log.warn("Failed to initialize Pulsar cluster. exit code: " + res.getExitCode());
            log.warn("STDOUT: " + res.getStdout());
            log.warn("STDERR: " + res.getStderr());
            throw new IOException("Failed to initialized Pulsar Cluster");
        }
        log.info("Successfully initialized cluster");
    }
}

