/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.containers;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.pulsar.tests.integration.containers.ChaosContainer;
import org.apache.pulsar.tests.integration.docker.ContainerExecResult;
import org.apache.pulsar.tests.integration.utils.DockerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.HostPortWaitStrategy;
import org.testcontainers.containers.wait.strategy.HttpWaitStrategy;

public abstract class PulsarContainer<SelfT extends PulsarContainer<SelfT>>
extends ChaosContainer<SelfT> {
    private static final Logger log = LoggerFactory.getLogger(PulsarContainer.class);
    public static final int INVALID_PORT = -1;
    public static final int ZK_PORT = 2181;
    public static final int CS_PORT = 2184;
    public static final int BOOKIE_PORT = 3181;
    public static final int BROKER_PORT = 6650;
    public static final int BROKER_PORT_TLS = 6651;
    public static final int BROKER_HTTP_PORT = 8080;
    public static final int BROKER_HTTPS_PORT = 8081;
    public static final String DEFAULT_IMAGE_NAME = System.getenv().getOrDefault("PULSAR_TEST_IMAGE_NAME", "apachepulsar/pulsar-test-latest-version:latest");
    public static final String DEFAULT_HTTP_PATH = "/metrics";
    public static final String PULSAR_2_5_IMAGE_NAME = "apachepulsar/pulsar:2.5.0";
    public static final String PULSAR_2_4_IMAGE_NAME = "apachepulsar/pulsar:2.4.0";
    public static final String PULSAR_2_3_IMAGE_NAME = "apachepulsar/pulsar:2.3.0";
    public static final String PULSAR_2_2_IMAGE_NAME = "apachepulsar/pulsar:2.2.0";
    public static final String PULSAR_2_1_IMAGE_NAME = "apachepulsar/pulsar:2.1.0";
    public static final String PULSAR_2_0_IMAGE_NAME = "apachepulsar/pulsar:2.0.0";
    public static final boolean PULSAR_CONTAINERS_LEAVE_RUNNING = Boolean.parseBoolean(System.getenv("PULSAR_CONTAINERS_LEAVE_RUNNING"));
    protected final String hostname;
    private final String serviceName;
    private final String serviceEntryPoint;
    private final int servicePort;
    private final int servicePortTls;
    private final int httpPort;
    private final int httpsPort;
    private final String httpPath;

    public PulsarContainer(String clusterName, String hostname, String serviceName, String serviceEntryPoint, int servicePort, int httpPort) {
        this(clusterName, hostname, serviceName, serviceEntryPoint, servicePort, httpPort, DEFAULT_HTTP_PATH);
    }

    public PulsarContainer(String clusterName, String hostname, String serviceName, String serviceEntryPoint, int servicePort, int httpPort, String httpPath) {
        this(clusterName, hostname, serviceName, serviceEntryPoint, servicePort, httpPort, httpPath, DEFAULT_IMAGE_NAME);
    }

    public PulsarContainer(String clusterName, String hostname, String serviceName, String serviceEntryPoint, int servicePort, int httpPort, String httpPath, String pulsarImageName) {
        this(clusterName, hostname, serviceName, serviceEntryPoint, servicePort, 0, httpPort, 0, httpPath, pulsarImageName);
    }

    public PulsarContainer(String clusterName, String hostname, String serviceName, String serviceEntryPoint, int servicePort, int servicePortTls, int httpPort, int httpsPort, String httpPath, String pulsarImageName) {
        super(clusterName, pulsarImageName);
        this.hostname = hostname;
        this.serviceName = serviceName;
        this.serviceEntryPoint = serviceEntryPoint;
        this.servicePort = servicePort;
        this.servicePortTls = servicePortTls;
        this.httpPort = httpPort;
        this.httpsPort = httpsPort;
        this.httpPath = httpPath;
        PulsarContainer.configureLeaveContainerRunning(this);
    }

    public static void configureLeaveContainerRunning(GenericContainer<?> container) {
        if (PULSAR_CONTAINERS_LEAVE_RUNNING) {
            container.withReuse(true);
            container.withLabel("pulsarcontainer", "true");
            container.withLabel("pulsarcontainer.random", UUID.randomUUID().toString());
        }
    }

    @Override
    protected void beforeStop() {
        super.beforeStop();
        if (null != this.getContainerId()) {
            DockerUtils.dumpContainerDirToTargetCompressed(this.getDockerClient(), this.getContainerId(), "/var/log/pulsar");
            try {
                this.execCmd("/usr/bin/pkill", "tail");
            }
            catch (Exception e) {
                log.debug("Cannot run 'pkill tail'", (Throwable)e);
            }
        }
    }

    @Override
    public void stop() {
        if (PULSAR_CONTAINERS_LEAVE_RUNNING) {
            log.warn("Ignoring stop due to PULSAR_CONTAINERS_LEAVE_RUNNING=true.");
            return;
        }
        super.stop();
    }

    @Override
    protected void doStop() {
        if (this.getContainerId() != null) {
            if (this.serviceEntryPoint.equals("bin/pulsar")) {
                this.dockerClient.stopContainerCmd(this.getContainerId()).withTimeout(Integer.valueOf(15)).exec();
            } else {
                try {
                    ContainerExecResult result = this.execCmd("/usr/bin/supervisorctl", "stop", "all");
                    log.info("Stopped supervisor services exit code: {}\nstdout: {}\nstderr: {}", new Object[]{result.getExitCode(), result.getStdout(), result.getStderr()});
                }
                catch (Exception e) {
                    log.error("Cannot run 'supervisorctl stop all'", (Throwable)e);
                }
            }
        }
        super.doStop();
    }

    public String getContainerName() {
        return this.clusterName + "-" + this.hostname;
    }

    @Override
    protected void configure() {
        super.configure();
        if (this.httpPort > 0) {
            this.addExposedPorts(new int[]{this.httpPort});
        }
        if (this.httpsPort > 0) {
            this.addExposedPorts(new int[]{this.httpsPort});
        }
        if (this.servicePort > 0) {
            this.addExposedPort(this.servicePort);
        }
        if (this.servicePortTls > 0) {
            this.addExposedPort(this.servicePortTls);
        }
    }

    protected void beforeStart() {
    }

    protected void afterStart() {
    }

    public void start() {
        if (this.httpPort > 0 && this.servicePort < 0) {
            this.waitStrategy = new HttpWaitStrategy().forPort(this.httpPort).forStatusCode(200).forPath(this.httpPath).withStartupTimeout(Duration.of(300L, ChronoUnit.SECONDS));
        } else if (this.httpPort > 0 || this.servicePort > 0) {
            this.waitStrategy = new HostPortWaitStrategy().withStartupTimeout(Duration.of(300L, ChronoUnit.SECONDS));
        }
        this.withCreateContainerCmdModifier(createContainerCmd -> {
            createContainerCmd.withHostName(this.hostname);
            createContainerCmd.withName(this.getContainerName());
            createContainerCmd.withEntrypoint(new String[]{this.serviceEntryPoint});
        });
        if (this.isCodeCoverageEnabled()) {
            this.configureCodeCoverage();
        }
        this.beforeStart();
        super.start();
        this.afterStart();
        log.info("[{}] Start pulsar service {} at container {}", new Object[]{this.getContainerName(), this.serviceName, this.getContainerId()});
    }

    protected boolean isCodeCoverageEnabled() {
        return Boolean.getBoolean("integrationtest.coverage.enabled");
    }

    protected void configureCodeCoverage() {
        File coverageDirectory = System.getProperty("integrationtest.coverage.dir") != null ? new File(System.getProperty("integrationtest.coverage.dir")) : new File("target");
        if (!coverageDirectory.isDirectory()) {
            coverageDirectory.mkdirs();
        }
        this.withFileSystemBind(coverageDirectory.getAbsolutePath(), "/jacocoDir", BindMode.READ_WRITE);
        String jacocoVersion = System.getProperty("jacoco.version");
        File jacocoAgentJar = new File(System.getProperty("user.home"), ".m2/repository/org/jacoco/org.jacoco.agent/" + jacocoVersion + "/org.jacoco.agent-" + jacocoVersion + "-runtime.jar");
        if (jacocoAgentJar.isFile()) {
            try {
                FileUtils.copyFileToDirectory((File)jacocoAgentJar, (File)coverageDirectory);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            this.withEnv("OPTS", "-javaagent:/jacocoDir/" + jacocoAgentJar.getName() + "=destfile=/jacocoDir/jacoco_" + this.getContainerName() + "_" + System.currentTimeMillis() + ".exec,includes=org.apache.pulsar.*:org.apache.bookkeeper.mledger.*,excludes=*.proto.*:*.shade.*:*.shaded.*");
        } else {
            log.error("Cannot find jacoco agent jar from '" + jacocoAgentJar.getAbsolutePath() + "'");
        }
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof PulsarContainer)) {
            return false;
        }
        PulsarContainer another = (PulsarContainer)((Object)o);
        return this.getContainerId().equals(another.getContainerId()) && super.equals((Object)another);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Objects.hash(this.getContainerId());
    }

    public String getPlainTextServiceUrl() {
        return "pulsar://" + this.getHost() + ":" + this.getMappedPort(this.servicePort);
    }

    public String getServiceUrlTls() {
        return "pulsar+ssl://" + this.getHost() + ":" + this.getMappedPort(this.servicePortTls);
    }

    public String getHttpServiceUrl() {
        return "http://" + this.getHost() + ":" + this.getMappedPort(this.httpPort);
    }

    public String getHttpsServiceUrl() {
        return "https://" + this.getHost() + ":" + this.getMappedPort(this.httpsPort);
    }

    public String getHostname() {
        return this.hostname;
    }
}

