/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.containers;

import java.time.Duration;
import org.apache.pulsar.tests.integration.containers.ChaosContainer;
import org.testcontainers.containers.wait.strategy.HttpWaitStrategy;
import org.testcontainers.utility.MountableFile;

public class OpenTelemetryCollectorContainer
extends ChaosContainer<OpenTelemetryCollectorContainer> {
    private static final String IMAGE_NAME = "otel/opentelemetry-collector-contrib:latest";
    private static final String NAME = "otel-collector";
    public static final int PROMETHEUS_EXPORTER_PORT = 8889;
    private static final int OTLP_RECEIVER_PORT = 4317;
    private static final int ZPAGES_PORT = 55679;

    public OpenTelemetryCollectorContainer(String clusterName) {
        super(clusterName, IMAGE_NAME);
    }

    @Override
    protected void configure() {
        super.configure();
        ((OpenTelemetryCollectorContainer)((OpenTelemetryCollectorContainer)((OpenTelemetryCollectorContainer)this.withCopyFileToContainer(MountableFile.forClasspathResource((String)"containers/otel-collector-config.yaml", (Integer)420), "/etc/otel-collector-config.yaml")).withCommand("--config=/etc/otel-collector-config.yaml")).withExposedPorts(new Integer[]{4317, 8889, 55679})).waitingFor(new HttpWaitStrategy().forPath("/debug/servicez").forPort(55679).forStatusCode(200).withStartupTimeout(Duration.ofSeconds(300L)));
    }

    public String getContainerName() {
        return this.clusterName + "-otel-collector";
    }

    public String getOtlpEndpoint() {
        return String.format("http://%s:%d", NAME, 4317);
    }
}

