/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.cli;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.pulsar.tests.integration.containers.BrokerContainer;
import org.apache.pulsar.tests.integration.containers.ChaosContainer;
import org.apache.pulsar.tests.integration.containers.ProxyContainer;
import org.apache.pulsar.tests.integration.containers.ZKContainer;
import org.apache.pulsar.tests.integration.docker.ContainerExecResult;
import org.apache.pulsar.tests.integration.messaging.TopicMessagingBase;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ClientToolTest
extends TopicMessagingBase {
    private static final int MESSAGE_COUNT = 10;

    @Test
    public void testProduceConsumeThroughBrokers() throws Exception {
        BrokerContainer broker = this.pulsarCluster.getAnyBroker();
        String serviceUrl = "pulsar://" + broker.getContainerName() + ":6650";
        String topicName = this.getNonPartitionedTopic("testProduceConsumeBroker", true);
        this.testProduceConsume(serviceUrl, topicName);
    }

    @Test
    public void testProduceConsumeThroughProxy() throws Exception {
        ProxyContainer proxy = this.pulsarCluster.getProxy();
        String serviceUrl = "pulsar://" + proxy.getContainerName() + ":6650";
        String topicName = this.getNonPartitionedTopic("testProduceConsumeProxy", true);
        this.testProduceConsume(serviceUrl, topicName);
    }

    private void testProduceConsume(String serviceUrl, String topicName) throws Exception {
        List<String> data = ClientToolTest.randomStrings();
        ZKContainer clientToolContainer = this.pulsarCluster.getZooKeeper();
        this.produce(clientToolContainer, serviceUrl, topicName, data);
        List<String> consumed = this.consume(clientToolContainer, serviceUrl, topicName);
        Assert.assertEquals(consumed, data);
    }

    private static List<String> randomStrings() {
        return IntStream.range(0, 10).mapToObj(i -> ClientToolTest.randomName(10)).collect(Collectors.toList());
    }

    private void produce(ChaosContainer<?> container, String url, String topic, List<String> messages) throws Exception {
        ContainerExecResult result = container.execCmd("bin/pulsar-client", "--url", url, "produce", topic, "-m", String.join((CharSequence)",", messages));
        if (result.getExitCode() != 0L) {
            Assert.fail((String)("Producing failed. Command output:\n" + result.getStdout() + "\nError output:\n" + result.getStderr()));
        }
    }

    private List<String> consume(ChaosContainer<?> container, String url, String topic) throws Exception {
        ContainerExecResult result = container.execCmd("bin/pulsar-client", "--url", url, "consume", "-s", ClientToolTest.randomName(8), "-n", String.valueOf(10), "-p", "Earliest", topic);
        if (result.getExitCode() != 0L) {
            Assert.fail((String)("Consuming failed. Command output:\n" + result.getStdout() + "\nError output:\n" + result.getStderr()));
        }
        String output = result.getStdout();
        Pattern message = Pattern.compile("----- got message -----\npublishTime:\\[(.*)\\], eventTime:\\[(.*)\\], key:\\[null\\], properties:\\[\\], content:(.*)");
        Matcher matcher = message.matcher(output);
        ArrayList<String> received = new ArrayList<String>(10);
        while (matcher.find()) {
            received.add(matcher.group(3));
        }
        return received;
    }
}

