/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.auth.token;

import com.google.common.io.Files;
import java.io.File;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.tests.integration.auth.token.PulsarTokenAuthenticationBaseSuite;
import org.apache.pulsar.tests.integration.containers.BrokerContainer;
import org.apache.pulsar.tests.integration.containers.ProxyContainer;
import org.apache.pulsar.tests.integration.containers.PulsarContainer;
import org.apache.pulsar.tests.integration.utils.DockerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenAuthWithPublicPrivateKeys
extends PulsarTokenAuthenticationBaseSuite {
    private static final Logger log = LoggerFactory.getLogger(TokenAuthWithPublicPrivateKeys.class);
    private static final String PRIVATE_KEY_PATH_INSIDE_CONTAINER = "/tmp/private.key";
    private static final String PUBLIC_KEY_PATH_INSIDE_CONTAINER = "/tmp/public.key";
    private File publicKeyFile;

    protected void createKeysAndTokens(PulsarContainer container) throws Exception {
        container.execCmd("/pulsar/bin/pulsar", "tokens", "create-key-pair", "--output-private-key", PRIVATE_KEY_PATH_INSIDE_CONTAINER, "--output-public-key", PUBLIC_KEY_PATH_INSIDE_CONTAINER);
        byte[] publicKeyBytes = DockerUtils.runCommandWithRawOutput(container.getDockerClient(), container.getContainerId(), "/bin/cat", PUBLIC_KEY_PATH_INSIDE_CONTAINER).getStdout();
        this.publicKeyFile = File.createTempFile("public-", ".key", new File("/tmp"));
        Files.write((byte[])publicKeyBytes, (File)this.publicKeyFile);
        this.clientAuthToken = container.execCmd("/pulsar/bin/pulsar", "tokens", "create", "--private-key", "file:///tmp/private.key", "--subject", "client").getStdout().trim();
        log.info("Created client token: {}", (Object)this.clientAuthToken);
        this.superUserAuthToken = container.execCmd("/pulsar/bin/pulsar", "tokens", "create", "--private-key", "file:///tmp/private.key", "--subject", "super-user").getStdout().trim();
        log.info("Created super-user token: {}", (Object)this.superUserAuthToken);
        this.proxyAuthToken = container.execCmd("/pulsar/bin/pulsar", "tokens", "create", "--private-key", "file:///tmp/private.key", "--subject", "proxy").getStdout().trim();
        log.info("Created proxy token: {}", (Object)this.proxyAuthToken);
    }

    @Override
    protected void configureBroker(BrokerContainer brokerContainer) throws Exception {
        brokerContainer.withFileSystemBind(this.publicKeyFile.toString(), PUBLIC_KEY_PATH_INSIDE_CONTAINER);
        brokerContainer.withEnv("tokenPublicKey", "file:///tmp/public.key");
    }

    @Override
    protected void configureProxy(ProxyContainer proxyContainer) throws Exception {
        proxyContainer.withFileSystemBind(this.publicKeyFile.toString(), PUBLIC_KEY_PATH_INSIDE_CONTAINER);
        proxyContainer.withEnv("tokenPublicKey", "file:///tmp/public.key");
    }

    @Override
    protected String createClientTokenWithExpiry(long expiryTime, TimeUnit unit) throws Exception {
        return this.cmdContainer.execCmd("/pulsar/bin/pulsar", "tokens", "create", "--private-key", "file:///tmp/private.key", "--subject", "client", "--expiry-time", unit.toSeconds(expiryTime) + "s").getStdout().trim();
    }
}

