/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.schema;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Set;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.schema.GenericRecord;
import org.apache.pulsar.client.api.schema.SchemaDefinition;
import org.apache.pulsar.common.naming.TopicDomain;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.tests.integration.schema.Schemas;
import org.apache.pulsar.tests.integration.suites.PulsarTestSuite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SchemaTest
extends PulsarTestSuite {
    private static final Logger log = LoggerFactory.getLogger(SchemaTest.class);
    private PulsarClient client;
    private PulsarAdmin admin;

    @Override
    public void setupCluster() throws Exception {
        super.setupCluster();
        this.client = PulsarClient.builder().serviceUrl(this.pulsarCluster.getPlainTextServiceUrl()).build();
        this.admin = PulsarAdmin.builder().serviceHttpUrl(this.pulsarCluster.getHttpServiceUrl()).build();
    }

    @Override
    public void tearDownCluster() throws Exception {
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
        if (this.admin != null) {
            this.admin.close();
            this.admin = null;
        }
        super.tearDownCluster();
    }

    @Test
    public void testCreateSchemaAfterDeletion() throws Exception {
        String tenant = "public";
        String namespace = "test-namespace-" + SchemaTest.randomName(16);
        String topic = "test-create-schema-after-deletion";
        String fqtn = TopicName.get((String)TopicDomain.persistent.value(), (String)"public", (String)namespace, (String)"test-create-schema-after-deletion").toString();
        this.admin.namespaces().createNamespace("public/" + namespace, (Set)Sets.newHashSet((Object[])new String[]{this.pulsarCluster.getClusterName()}));
        try (Producer producer = this.client.newProducer(Schema.AVRO(Schemas.Person.class)).topic(fqtn).create();){
            Schemas.Person person = new Schemas.Person();
            person.setName("Tom Hanks");
            person.setAge(60);
            producer.send((Object)person);
            log.info("Successfully published person : {}", (Object)person);
        }
        log.info("Deleting schema of topic {}", (Object)fqtn);
        this.admin.schemas().deleteSchema(fqtn);
        log.info("Successfully deleted schema of topic {}", (Object)fqtn);
        producer = this.client.newProducer(Schema.AVRO(Schemas.Student.class)).topic(fqtn).create();
        try {
            Schemas.Student student = new Schemas.Student();
            student.setName("Tom Jerry");
            student.setAge(30);
            student.setGpa(6);
            student.setGpa(10);
            producer.send((Object)student);
            log.info("Successfully published student : {}", (Object)student);
        }
        finally {
            if (producer != null) {
                producer.close();
            }
        }
    }

    @Test
    public void testMultiVersionSchema() throws Exception {
        String tenant = "public";
        String namespace = "test-namespace-" + SchemaTest.randomName(16);
        String topic = "test-multi-version-schema";
        String fqtn = TopicName.get((String)TopicDomain.persistent.value(), (String)"public", (String)namespace, (String)"test-multi-version-schema").toString();
        this.admin.namespaces().createNamespace("public/" + namespace, (Set)Sets.newHashSet((Object[])new String[]{this.pulsarCluster.getClusterName()}));
        Producer producer = this.client.newProducer(Schema.AVRO((SchemaDefinition)SchemaDefinition.builder().withAlwaysAllowNull(false).withSupportSchemaVersioning(true).withPojo(Schemas.Person.class).build())).topic(fqtn).create();
        Schemas.Person person = new Schemas.Person();
        person.setName("Tom Hanks");
        person.setAge(60);
        Consumer consumer = this.client.newConsumer(Schema.AVRO((SchemaDefinition)SchemaDefinition.builder().withAlwaysAllowNull(false).withSupportSchemaVersioning(true).withPojo(Schemas.PersonConsumeSchema.class).build())).subscriptionName("test").topic(new String[]{fqtn}).subscribe();
        producer.send((Object)person);
        log.info("Successfully published person : {}", (Object)person);
        Schemas.PersonConsumeSchema personConsumeSchema = (Schemas.PersonConsumeSchema)consumer.receive().getValue();
        Assert.assertEquals((String)"Tom Hanks", (String)personConsumeSchema.getName());
        Assert.assertEquals((int)60, (int)personConsumeSchema.getAge());
        Assert.assertEquals((String)"male", (String)personConsumeSchema.getGender());
        producer.close();
        consumer.close();
        log.info("Successfully consumer personConsumeSchema : {}", (Object)personConsumeSchema);
    }

    @Test
    public void testAvroLogicalType() throws Exception {
        String tenant = "public";
        String namespace = "test-namespace-" + SchemaTest.randomName(16);
        String topic = "test-logical-type-schema";
        String fqtn = TopicName.get((String)TopicDomain.persistent.value(), (String)"public", (String)namespace, (String)"test-logical-type-schema").toString();
        this.admin.namespaces().createNamespace("public/" + namespace, (Set)Sets.newHashSet((Object[])new String[]{this.pulsarCluster.getClusterName()}));
        Schemas.AvroLogicalType messageForSend = Schemas.AvroLogicalType.builder().decimal(new BigDecimal("12.34")).timestampMicros(System.currentTimeMillis() * 1000L).timestampMillis(Instant.parse("2019-03-26T04:39:58.469Z")).timeMillis(LocalTime.now().truncatedTo(ChronoUnit.MILLIS)).timeMicros(System.currentTimeMillis() * 1000L).date(LocalDate.now()).build();
        Producer producer = this.client.newProducer(Schema.AVRO((SchemaDefinition)SchemaDefinition.builder().withPojo(Schemas.AvroLogicalType.class).withJSR310ConversionEnabled(true).build())).topic(fqtn).create();
        Consumer consumer = this.client.newConsumer(Schema.AVRO(Schemas.AvroLogicalType.class)).topic(new String[]{fqtn}).subscriptionName("test").subscribe();
        producer.send((Object)messageForSend);
        log.info("Successfully published avro logical type message : {}", (Object)messageForSend);
        Schemas.AvroLogicalType received = (Schemas.AvroLogicalType)consumer.receive().getValue();
        Assert.assertEquals((Object)received, (Object)messageForSend);
        producer.close();
        consumer.close();
        log.info("Successfully consumer avro logical type message : {}", (Object)received);
    }

    @Test
    public void testAutoConsumeSchemaSubscribeFirst() throws Exception {
        String tenant = "public";
        String namespace = "test-namespace-" + SchemaTest.randomName(16);
        String topic = "test-auto-consume-schema";
        String fqtn = TopicName.get((String)TopicDomain.persistent.value(), (String)"public", (String)namespace, (String)"test-auto-consume-schema").toString();
        this.admin.namespaces().createNamespace("public/" + namespace, (Set)Sets.newHashSet((Object[])new String[]{this.pulsarCluster.getClusterName()}));
        Consumer consumer = this.client.newConsumer(Schema.AUTO_CONSUME()).topic(new String[]{fqtn}).subscriptionName("test").subscribe();
        Producer producer = this.client.newProducer(Schema.AVRO(Schemas.Person.class)).topic(fqtn).create();
        Schemas.Person person = new Schemas.Person();
        person.setName("Tom Hanks");
        person.setAge(60);
        producer.send((Object)person);
        GenericRecord genericRecord = (GenericRecord)consumer.receive().getValue();
        Assert.assertEquals((Object)genericRecord.getField("name"), (Object)"Tom Hanks");
        Assert.assertEquals((Object)genericRecord.getField("age"), (Object)60);
        consumer.close();
        producer.close();
    }

    @Test
    public void testPrimitiveSchemaTypeCompatibilityCheck() {
        ArrayList<Schema> schemas = new ArrayList<Schema>();
        schemas.add(Schema.STRING);
        schemas.add(Schema.INT8);
        schemas.add(Schema.INT16);
        schemas.add(Schema.INT32);
        schemas.add(Schema.INT64);
        schemas.add(Schema.BOOL);
        schemas.add(Schema.DOUBLE);
        schemas.add(Schema.FLOAT);
        schemas.add(Schema.DATE);
        schemas.add(Schema.TIME);
        schemas.add(Schema.TIMESTAMP);
        schemas.add(Schema.INSTANT);
        schemas.add(Schema.LOCAL_DATE);
        schemas.add(Schema.LOCAL_TIME);
        schemas.add(Schema.LOCAL_DATE_TIME);
        schemas.forEach(schemaProducer -> schemas.forEach(schemaConsumer -> {
            try {
                String topicName = schemaProducer.getSchemaInfo().getName() + schemaConsumer.getSchemaInfo().getName();
                this.client.newProducer(schemaProducer).topic(topicName).create().close();
                this.client.newConsumer(schemaConsumer).topic(new String[]{topicName}).subscriptionName("test").subscribe().close();
                Assert.assertEquals((Object)schemaProducer.getSchemaInfo().getType(), (Object)schemaConsumer.getSchemaInfo().getType());
            }
            catch (PulsarClientException e) {
                Assert.assertNotEquals((Object)schemaProducer.getSchemaInfo().getType(), (Object)schemaConsumer.getSchemaInfo().getType());
            }
        }));
    }

    @Test
    public void testDeletePartitionedTopicWhenTopicReferenceIsNotReady() throws Exception {
        String topic = "persistent://public/default/tp-ref";
        this.admin.topics().createPartitionedTopic("persistent://public/default/tp-ref", 20);
        this.admin.schemas().createSchema("persistent://public/default/tp-ref", SchemaInfo.builder().type(SchemaType.STRING).schema(new byte[0]).build());
        this.admin.topics().deletePartitionedTopic("persistent://public/default/tp-ref", false);
    }
}

