/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.plugins;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.pulsar.tests.integration.containers.BrokerContainer;
import org.apache.pulsar.tests.integration.containers.ProxyContainer;
import org.apache.pulsar.tests.integration.suites.PulsarTestSuite;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestAdditionalServlets
extends PulsarTestSuite {
    private static final String NAME = "random";
    private static final String PREFIX = "PULSAR_PREFIX_";
    public static final int SEQUENCE_LENGTH = 7;

    @Override
    public void setupCluster() throws Exception {
        this.brokerEnvs.put("PULSAR_PREFIX_additionalServlets", NAME);
        this.brokerEnvs.put("PULSAR_PREFIX_additionalServletDirectory", "/pulsar/examples");
        this.brokerEnvs.put("PULSAR_PREFIX_randomServletSequenceLength", "7");
        this.brokerEnvs.put("PULSAR_PREFIX_narExtractionDirectory", "/tmp");
        this.proxyEnvs.put("PULSAR_PREFIX_additionalServlets", NAME);
        this.proxyEnvs.put("PULSAR_PREFIX_additionalServletDirectory", "/pulsar/examples");
        this.proxyEnvs.put("PULSAR_PREFIX_randomServletSequenceLength", "7");
        this.proxyEnvs.put("PULSAR_PREFIX_narExtractionDirectory", "/tmp");
        super.setupCluster();
    }

    @Test
    public void testBrokerAdditionalServlet() throws Exception {
        BrokerContainer broker = this.getPulsarCluster().getAnyBroker();
        String host = broker.getHost();
        Integer httpPort = broker.getMappedPort(8080);
        this.testAddress(host, httpPort);
    }

    @Test
    public void testProxyAdditionalServlet() throws Exception {
        ProxyContainer proxy = this.getPulsarCluster().getProxy();
        String host = proxy.getHost();
        Integer httpPort = proxy.getMappedPort(8080);
        this.testAddress(host, httpPort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testAddress(String host, Integer httpPort) throws IOException, InterruptedException, URISyntaxException {
        ExecutorService executor = null;
        try {
            executor = Executors.newSingleThreadExecutor();
            HttpClient httpClient = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.ALWAYS).executor(executor).build();
            HttpRequest request = HttpRequest.newBuilder().uri(new URI("http://" + host + ":" + httpPort + "/random/")).GET().build();
            String response = httpClient.send(request, HttpResponse.BodyHandlers.ofString()).body();
            Assert.assertEquals(IntStream.range(0, 7).boxed().collect(Collectors.toSet()), Arrays.stream(response.split(",")).map(Integer::parseInt).collect(Collectors.toSet()));
        }
        finally {
            if (executor != null) {
                executor.shutdown();
            }
        }
    }
}

