/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.io.sinks;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.schema.SchemaDefinition;
import org.apache.pulsar.client.impl.schema.AvroSchema;
import org.apache.pulsar.common.schema.KeyValue;
import org.apache.pulsar.common.schema.KeyValueEncodingType;
import org.apache.pulsar.tests.integration.io.sinks.SinkTester;
import org.apache.pulsar.tests.integration.topologies.PulsarCluster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testng.Assert;

public class JdbcPostgresSinkTester
extends SinkTester<PostgreSQLContainer> {
    private static final Logger log = LoggerFactory.getLogger(JdbcPostgresSinkTester.class);
    private static final String NAME = "jdbc-postgres";
    private static final String POSTGRES = "postgres";
    private final AvroSchema<Foo> schema = AvroSchema.of((SchemaDefinition)SchemaDefinition.builder().withPojo(Foo.class).build());
    private final String tableName = "test";
    private Connection connection;
    private boolean keyValueSchema;

    public JdbcPostgresSinkTester(boolean keyValueSchema) {
        super(NAME, SinkTester.SinkType.JDBC_POSTGRES);
        this.keyValueSchema = keyValueSchema;
        this.sinkConfig.put("userName", "test");
        this.sinkConfig.put("password", "test");
        this.sinkConfig.put("nonKey", "field2,field3");
        this.sinkConfig.put("key", "field1");
        this.sinkConfig.put("tableName", "test");
        this.sinkConfig.put("batchSize", 1);
    }

    @Override
    public Schema<?> getInputTopicSchema() {
        if (this.keyValueSchema) {
            return Schema.AUTO_CONSUME();
        }
        return this.schema;
    }

    @Override
    protected PostgreSQLContainer createSinkService(PulsarCluster cluster) {
        return (PostgreSQLContainer)new PostgreSQLContainer("postgres:14.3").withNetworkAliases(new String[]{POSTGRES});
    }

    @Override
    public void prepareSink() throws Exception {
        String jdbcUrl = ((PostgreSQLContainer)this.serviceContainer).getJdbcUrl();
        this.sinkConfig.put("jdbcUrl", "jdbc:postgresql://postgres:5432/test");
        String driver = ((PostgreSQLContainer)this.serviceContainer).getDriverClassName();
        Class.forName(driver);
        this.connection = DriverManager.getConnection(jdbcUrl, "test", "test");
        log.info("getConnection: {}, jdbcurl: {}", (Object)this.connection, (Object)jdbcUrl);
        String createTable = "CREATE TABLE test (field1 TEXT, field2 TEXT, field3 INTEGER, PRIMARY KEY (field3))";
        int ret = this.connection.createStatement().executeUpdate(createTable);
        log.info("created table in jdbc: {}, return value: {}", (Object)createTable, (Object)ret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void produceMessage(int numMessages, PulsarClient client, String inputTopicName, LinkedHashMap<String, String> kvs) throws Exception {
        if (!this.keyValueSchema) {
            super.produceMessage(numMessages, client, inputTopicName, kvs);
            return;
        }
        Producer producer = client.newProducer(Schema.KeyValue((Schema)Schema.JSON(KVSchemaKey.class), (Schema)Schema.AVRO(KVSchemaValue.class), (KeyValueEncodingType)KeyValueEncodingType.SEPARATED)).topic(inputTopicName).create();
        try {
            for (int i = 0; i < numMessages; ++i) {
                String key = "key-" + i;
                kvs.put(key, key);
                producer.newMessage().value((Object)new KeyValue((Object)new KVSchemaKey(i), (Object)new KVSchemaValue("f1_" + i, "f2_" + i))).send();
            }
        }
        finally {
            if (Collections.singletonList(producer).get(0) != null) {
                producer.close();
            }
        }
    }

    @Override
    public void validateSinkResult(Map<String, String> kvs) {
        log.info("Query table content from postgres server: {}", (Object)"test");
        String querySql = "SELECT * FROM test ORDER BY field3";
        try {
            Thread.sleep(1000L);
            PreparedStatement statement = this.connection.prepareStatement(querySql, 1004, 1008);
            ResultSet rs = statement.executeQuery();
            if (!this.keyValueSchema && kvs.get("ACTION").equals("DELETE")) {
                Assert.assertFalse((boolean)rs.first());
                return;
            }
            int index = 0;
            while (rs.next()) {
                String field1 = rs.getString(1);
                String field2 = rs.getString(2);
                int field3 = rs.getInt(3);
                if (this.keyValueSchema) {
                    Assert.assertEquals((String)field1, (String)("f1_" + index));
                    Assert.assertEquals((String)field2, (String)("f2_" + index));
                    Assert.assertEquals((int)field3, (int)index);
                } else {
                    String value = kvs.get("key-" + field3);
                    Foo obj = (Foo)this.schema.decode(value.getBytes());
                    Assert.assertEquals((String)obj.field1, (String)field1);
                    Assert.assertEquals((String)obj.field2, (String)field2);
                    Assert.assertEquals((int)obj.field3, (int)field3);
                }
                ++index;
            }
        }
        catch (Exception e) {
            log.error("Got exception: ", (Throwable)e);
            Assert.fail((String)("Got exception when op sql: " + e));
        }
    }

    public boolean isKeyValueSchema() {
        return this.keyValueSchema;
    }

    @Override
    public void close() throws Exception {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
    }

    public static class Foo {
        private String field1;
        private String field2;
        private int field3;

        public String getField1() {
            return this.field1;
        }

        public String getField2() {
            return this.field2;
        }

        public int getField3() {
            return this.field3;
        }

        public void setField1(String field1) {
            this.field1 = field1;
        }

        public void setField2(String field2) {
            this.field2 = field2;
        }

        public void setField3(int field3) {
            this.field3 = field3;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Foo)) {
                return false;
            }
            Foo other = (Foo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getField3() != other.getField3()) {
                return false;
            }
            String this$field1 = this.getField1();
            String other$field1 = other.getField1();
            if (this$field1 == null ? other$field1 != null : !this$field1.equals(other$field1)) {
                return false;
            }
            String this$field2 = this.getField2();
            String other$field2 = other.getField2();
            return !(this$field2 == null ? other$field2 != null : !this$field2.equals(other$field2));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Foo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getField3();
            String $field1 = this.getField1();
            result = result * 59 + ($field1 == null ? 43 : $field1.hashCode());
            String $field2 = this.getField2();
            result = result * 59 + ($field2 == null ? 43 : $field2.hashCode());
            return result;
        }

        public String toString() {
            return "JdbcPostgresSinkTester.Foo(field1=" + this.getField1() + ", field2=" + this.getField2() + ", field3=" + this.getField3() + ")";
        }
    }

    public static class KVSchemaKey {
        private int field3;

        public int getField3() {
            return this.field3;
        }

        public void setField3(int field3) {
            this.field3 = field3;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof KVSchemaKey)) {
                return false;
            }
            KVSchemaKey other = (KVSchemaKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.getField3() == other.getField3();
        }

        protected boolean canEqual(Object other) {
            return other instanceof KVSchemaKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getField3();
            return result;
        }

        public String toString() {
            return "JdbcPostgresSinkTester.KVSchemaKey(field3=" + this.getField3() + ")";
        }

        public KVSchemaKey(int field3) {
            this.field3 = field3;
        }
    }

    public static class KVSchemaValue {
        private String field1;
        private String field2;

        public String getField1() {
            return this.field1;
        }

        public String getField2() {
            return this.field2;
        }

        public void setField1(String field1) {
            this.field1 = field1;
        }

        public void setField2(String field2) {
            this.field2 = field2;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof KVSchemaValue)) {
                return false;
            }
            KVSchemaValue other = (KVSchemaValue)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$field1 = this.getField1();
            String other$field1 = other.getField1();
            if (this$field1 == null ? other$field1 != null : !this$field1.equals(other$field1)) {
                return false;
            }
            String this$field2 = this.getField2();
            String other$field2 = other.getField2();
            return !(this$field2 == null ? other$field2 != null : !this$field2.equals(other$field2));
        }

        protected boolean canEqual(Object other) {
            return other instanceof KVSchemaValue;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $field1 = this.getField1();
            result = result * 59 + ($field1 == null ? 43 : $field1.hashCode());
            String $field2 = this.getField2();
            result = result * 59 + ($field2 == null ? 43 : $field2.hashCode());
            return result;
        }

        public String toString() {
            return "JdbcPostgresSinkTester.KVSchemaValue(field1=" + this.getField1() + ", field2=" + this.getField2() + ")";
        }

        public KVSchemaValue(String field1, String field2) {
            this.field1 = field1;
            this.field2 = field2;
        }
    }
}

