/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.functions.python;

import org.apache.pulsar.tests.integration.functions.PulsarFunctionsTest;
import org.apache.pulsar.tests.integration.functions.utils.CommandGenerator;
import org.apache.pulsar.tests.integration.topologies.FunctionRuntimeType;
import org.testng.annotations.Test;

public abstract class PulsarFunctionsPythonTest
extends PulsarFunctionsTest {
    PulsarFunctionsPythonTest(FunctionRuntimeType functionRuntimeType) {
        super(functionRuntimeType);
    }

    @Test(groups={"python_function", "function"})
    public void testPythonFunctionLocalRun() throws Exception {
        this.testFunctionLocalRun(CommandGenerator.Runtime.PYTHON);
    }

    @Test(groups={"python_function", "function"})
    public void testPythonFunctionNegAck() throws Exception {
        this.testFunctionNegAck(CommandGenerator.Runtime.PYTHON);
    }

    @Test(groups={"python_function", "function"})
    public void testPythonPublishFunction() throws Exception {
        this.testPublishFunction(CommandGenerator.Runtime.PYTHON);
    }

    @Test(groups={"python_function", "function"})
    public void testPythonExclamationFunction() throws Exception {
        this.testExclamationFunction(CommandGenerator.Runtime.PYTHON, false, false, false, false);
    }

    @Test(groups={"python_function", "function"})
    public void testPythonExclamationFunctionWithExtraDeps() throws Exception {
        this.testExclamationFunction(CommandGenerator.Runtime.PYTHON, false, false, false, true);
    }

    @Test(groups={"python_function", "function"})
    public void testPythonExclamationZipFunction() throws Exception {
        this.testExclamationFunction(CommandGenerator.Runtime.PYTHON, false, true, false, false);
    }

    @Test(groups={"python_function", "function"})
    public void testPythonExclamationTopicPatternFunction() throws Exception {
        this.testExclamationFunction(CommandGenerator.Runtime.PYTHON, true, false, false, false);
    }

    @Test(groups={"python_function", "function"})
    public void testAvroSchemaFunctionTest() throws Exception {
        this.testAvroSchemaFunction(CommandGenerator.Runtime.PYTHON);
    }

    @Test(groups={"python_function", "function"})
    public void testRetainOrderingTest() throws Exception {
        this.testExclamationFunction(CommandGenerator.Runtime.PYTHON, false, false, false, false, generator -> generator.setRetainOrdering(true));
    }

    @Test(groups={"python_function", "function"})
    public void testRetainKeyOrderingTest() throws Exception {
        this.testExclamationFunction(CommandGenerator.Runtime.PYTHON, false, false, false, false, generator -> {
            System.out.println("calling generator.setRetainKeyOrdering(true);");
            generator.setRetainKeyOrdering(true);
        });
    }
}

