/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.functions;

import org.apache.pulsar.tests.integration.functions.utils.CommandGenerator;
import org.apache.pulsar.tests.integration.suites.PulsarTestSuite;
import org.apache.pulsar.tests.integration.topologies.FunctionRuntimeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.DataProvider;

public abstract class PulsarFunctionsTestBase
extends PulsarTestSuite {
    private static final Logger log = LoggerFactory.getLogger(PulsarFunctionsTestBase.class);
    public static final String EXCLAMATION_JAVA_CLASS = "org.apache.pulsar.functions.api.examples.ExclamationFunction";
    public static final String PUBLISH_JAVA_CLASS = "org.apache.pulsar.functions.api.examples.TypedMessageBuilderPublish";
    public static final String EXCEPTION_JAVA_CLASS = "org.apache.pulsar.tests.integration.functions.ExceptionFunction";
    public static final String GENERIC_OBJECT_FUNCTION_JAVA_CLASS = "org.apache.pulsar.tests.integration.functions.GenericObjectFunction";
    public static final String REMOVE_AVRO_FIELD_FUNCTION_JAVA_CLASS = "org.apache.pulsar.tests.integration.functions.RemoveAvroFieldFunction";
    public static final String REMOVE_AVRO_FIELD_RECORD_FUNCTION_JAVA_CLASS = "org.apache.pulsar.tests.integration.functions.RemoveAvroFieldRecordFunction";
    public static final String SERDE_JAVA_CLASS = "org.apache.pulsar.functions.api.examples.CustomBaseToBaseFunction";
    public static final String SERDE_CLASS = "org.apache.pulsar.functions.api.examples.CustomBaseSerde";
    public static final String EXCLAMATION_PYTHON_CLASS = "exclamation_function.ExclamationFunction";
    public static final String EXCLAMATION_WITH_DEPS_PYTHON_CLASS = "exclamation_with_extra_deps.ExclamationFunction";
    public static final String EXCLAMATION_PYTHON_ZIP_CLASS = "exclamation";
    public static final String PUBLISH_PYTHON_CLASS = "typed_message_builder_publish.TypedMessageBuilderPublish";
    public static final String EXCEPTION_PYTHON_CLASS = "exception_function";
    public static final String AVRO_SCHEMA_PYTHON_CLASS = "avro_schema_test_function.AvroSchemaTestFunction";
    public static final String EXCLAMATION_PYTHON_FILE = "exclamation_function.py";
    public static final String EXCLAMATION_WITH_DEPS_PYTHON_FILE = "exclamation_with_extra_deps.py";
    public static final String EXCLAMATION_PYTHON_ZIP_FILE = "exclamation.zip";
    public static final String PUBLISH_FUNCTION_PYTHON_FILE = "typed_message_builder_publish.py";
    public static final String EXCEPTION_FUNCTION_PYTHON_FILE = "exception_function.py";
    public static final String AVRO_SCHEMA_FUNCTION_PYTHON_FILE = "avro_schema_test_function.py";
    public static final String EXCLAMATION_GO_FILE = "exclamationFunc";
    public static final String PUBLISH_FUNCTION_GO_FILE = "exclamationFunc";
    public static final String LOGGING_JAVA_CLASS = "org.apache.pulsar.functions.api.examples.LoggingFunction";
    protected final FunctionRuntimeType functionRuntimeType;

    @DataProvider(name="FunctionRuntimeTypes")
    public static Object[][] getData() {
        return new Object[][]{{FunctionRuntimeType.PROCESS}, {FunctionRuntimeType.THREAD}};
    }

    @DataProvider(name="FunctionRuntimes")
    public static Object[][] functionRuntimes() {
        return new Object[][]{{CommandGenerator.Runtime.JAVA}, {CommandGenerator.Runtime.PYTHON}, {CommandGenerator.Runtime.GO}};
    }

    public PulsarFunctionsTestBase() {
        this(FunctionRuntimeType.PROCESS);
    }

    protected PulsarFunctionsTestBase(FunctionRuntimeType functionRuntimeType) {
        this.functionRuntimeType = functionRuntimeType;
    }

    @Override
    public void setupCluster() throws Exception {
        super.setupCluster();
        this.setupFunctionWorkers();
    }

    @Override
    public void tearDownCluster() throws Exception {
        try {
            this.teardownFunctionWorkers();
        }
        finally {
            super.tearDownCluster();
        }
    }

    protected void setupFunctionWorkers() {
        int numFunctionWorkers = 2;
        log.info("Setting up {} function workers : function runtime type = {}", (Object)2, (Object)this.functionRuntimeType);
        this.pulsarCluster.setupFunctionWorkers(PulsarFunctionsTestBase.randomName(5), this.functionRuntimeType, 2);
        log.info("{} function workers has started", (Object)2);
    }

    protected void teardownFunctionWorkers() {
        log.info("Tearing down function workers ...");
        this.pulsarCluster.stopWorkers();
        log.info("All functions workers are stopped.");
    }

    protected static String getExclamationClass(CommandGenerator.Runtime runtime, boolean pyZip, boolean extraDeps) {
        if (CommandGenerator.Runtime.JAVA == runtime) {
            return EXCLAMATION_JAVA_CLASS;
        }
        if (CommandGenerator.Runtime.PYTHON == runtime) {
            if (pyZip) {
                return EXCLAMATION_PYTHON_ZIP_CLASS;
            }
            if (extraDeps) {
                return EXCLAMATION_WITH_DEPS_PYTHON_CLASS;
            }
            return EXCLAMATION_PYTHON_CLASS;
        }
        if (CommandGenerator.Runtime.GO == runtime) {
            return null;
        }
        throw new IllegalArgumentException("Unsupported runtime : " + runtime);
    }
}

