/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.cli.tenant;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.tests.integration.docker.ContainerExecException;
import org.apache.pulsar.tests.integration.docker.ContainerExecResult;
import org.apache.pulsar.tests.integration.suites.PulsarTestSuite;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TenantTest
extends PulsarTestSuite {
    @Test
    public void testListTenantCmd() throws Exception {
        ContainerExecResult result = this.pulsarCluster.runAdminCommandOnAnyBroker("tenants", "list");
        Assert.assertTrue((boolean)result.getStdout().contains("public"));
    }

    @Test
    public void testGetTenantCmd() throws Exception {
        this.pulsarCluster.runAdminCommandOnAnyBroker("tenants", "get", "public");
    }

    @Test
    public void testGetNonExistTenantCmd() {
        String tenantName = TenantTest.randomName();
        ContainerExecException ex = (ContainerExecException)Assert.expectThrows(ContainerExecException.class, () -> this.pulsarCluster.runAdminCommandOnAnyBroker("tenants", "get", tenantName));
        Assert.assertTrue((boolean)ex.getResult().getStderr().contains("Tenant does not exist"));
    }

    @Test
    public void testCreateTenantCmd() throws Exception {
        String tenantName = TenantTest.randomName();
        this.pulsarCluster.runAdminCommandOnAnyBroker("tenants", "create", tenantName);
        ContainerExecResult result = this.pulsarCluster.runAdminCommandOnAnyBroker("tenants", "get", tenantName);
        TenantInfo tenantInfo = (TenantInfo)this.jsonMapper().readValue(result.getStdout(), TenantInfo.class);
        Assert.assertNotNull((Object)tenantInfo);
        Assert.assertTrue((boolean)tenantInfo.getAdminRoles().isEmpty());
        Assert.assertFalse((boolean)tenantInfo.getAllowedClusters().isEmpty());
        this.pulsarCluster.runAdminCommandOnAnyBroker("tenants", "delete", tenantName);
    }

    @Test
    public void testCreateTenantCmdWithAdminRolesAndAllowClustersFlags() throws Exception {
        String tenantName = TenantTest.randomName();
        List<String> adminRoles = Arrays.asList("role1", "role2");
        List<String> allowedClusters = Collections.singletonList(this.pulsarCluster.getClusterName());
        this.pulsarCluster.runAdminCommandOnAnyBroker("tenants", "create", tenantName, "--admin-roles", String.join((CharSequence)",", adminRoles), "--allowed-clusters", String.join((CharSequence)",", allowedClusters));
        ContainerExecResult result = this.pulsarCluster.runAdminCommandOnAnyBroker("tenants", "get", tenantName);
        TenantInfo tenantInfo = (TenantInfo)this.jsonMapper().readValue(result.getStdout(), TenantInfo.class);
        Assert.assertNotNull((Object)tenantInfo);
        Assert.assertNotNull((Object)tenantInfo.getAdminRoles());
        Assert.assertEquals((Object[])tenantInfo.getAdminRoles().stream().sorted().toArray(), (Object[])adminRoles.stream().sorted().toArray());
        Assert.assertEquals((Collection)tenantInfo.getAllowedClusters(), allowedClusters);
        this.pulsarCluster.runAdminCommandOnAnyBroker("tenants", "delete", tenantName);
    }

    @Test
    public void testCreateExistTenantCmd() {
        ContainerExecException ex = (ContainerExecException)Assert.expectThrows(ContainerExecException.class, () -> this.pulsarCluster.runAdminCommandOnAnyBroker("tenants", "create", "public"));
        Assert.assertTrue((boolean)ex.getResult().getStderr().contains("Tenant already exist"));
    }

    @Test
    public void testUpdateTenantCmdWithAdminRolesAndAllowedClustersFlags() throws Exception {
        String tenantName = TenantTest.randomName();
        List<String> adminRoles = Arrays.asList("role1", "role2");
        this.pulsarCluster.runAdminCommandOnAnyBroker("tenants", "create", tenantName, "--admin-roles", String.join((CharSequence)",", adminRoles));
        ContainerExecResult result = this.pulsarCluster.runAdminCommandOnAnyBroker("tenants", "get", tenantName);
        TenantInfo tenantInfo = (TenantInfo)this.jsonMapper().readValue(result.getStdout(), TenantInfo.class);
        Assert.assertNotNull((Object)tenantInfo);
        Assert.assertNotNull((Object)tenantInfo.getAdminRoles());
        Assert.assertEquals((Object[])tenantInfo.getAdminRoles().stream().sorted().toArray(), (Object[])adminRoles.stream().sorted().toArray());
        Assert.assertFalse((boolean)tenantInfo.getAllowedClusters().isEmpty());
        adminRoles = Arrays.asList("role3", "role4");
        List<String> allowedClusters = Collections.singletonList(this.pulsarCluster.getClusterName());
        this.pulsarCluster.runAdminCommandOnAnyBroker("tenants", "update", tenantName, "--admin-roles", String.join((CharSequence)",", adminRoles), "--allowed-clusters", String.join((CharSequence)",", allowedClusters));
        result = this.pulsarCluster.runAdminCommandOnAnyBroker("tenants", "get", tenantName);
        tenantInfo = (TenantInfo)this.jsonMapper().readValue(result.getStdout(), TenantInfo.class);
        Assert.assertNotNull((Object)tenantInfo);
        Assert.assertEquals((Object[])tenantInfo.getAdminRoles().stream().sorted().toArray(), (Object[])adminRoles.stream().sorted().toArray());
        Assert.assertEquals((Collection)tenantInfo.getAllowedClusters(), allowedClusters);
        this.pulsarCluster.runAdminCommandOnAnyBroker("tenants", "delete", tenantName);
    }
}

