/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.bookkeeper;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.pulsar.tests.integration.docker.ContainerExecResult;
import org.apache.pulsar.tests.integration.topologies.PulsarCluster;
import org.apache.pulsar.tests.integration.topologies.PulsarClusterSpec;
import org.apache.pulsar.tests.integration.topologies.PulsarClusterTestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class BookkeeperInstallWithHttpServerEnabledTest
extends PulsarClusterTestBase {
    private static final Logger log = LoggerFactory.getLogger(BookkeeperInstallWithHttpServerEnabledTest.class);

    @Override
    @BeforeClass(alwaysRun=true)
    public final void setupCluster() throws Exception {
        this.incrementSetupNumber();
        String clusterName = Stream.of(((Object)((Object)this)).getClass().getSimpleName(), BookkeeperInstallWithHttpServerEnabledTest.randomName(5)).filter(s -> !s.isEmpty()).collect(Collectors.joining("-"));
        this.bookkeeperEnvs.put("httpServerEnabled", "true");
        this.bookieAdditionalPorts.add(8000);
        PulsarClusterSpec spec = PulsarClusterSpec.builder().numBookies(2).numBrokers(1).bookkeeperEnvs(this.bookkeeperEnvs).bookieAdditionalPorts(this.bookieAdditionalPorts).clusterName(clusterName).build();
        log.info("Setting up cluster {} with {} bookies, {} brokers", new Object[]{spec.clusterName(), spec.numBookies(), spec.numBrokers()});
        this.pulsarCluster = PulsarCluster.forSpec(spec);
        this.pulsarCluster.start();
        log.info("Cluster {} is setup", (Object)spec.clusterName());
    }

    @Override
    @AfterClass(alwaysRun=true)
    public final void tearDownCluster() throws Exception {
        super.tearDownCluster();
    }

    @Test
    public void testBookieHttpServerIsRunning() throws Exception {
        ContainerExecResult result = this.pulsarCluster.getAnyBookie().execCmd("/usr/bin/curl", "-X", "GET", "http://localhost:8000/heartbeat");
        Assert.assertEquals((long)result.getExitCode(), (long)0L);
        Assert.assertEquals((String)result.getStdout(), (String)"OK\n");
    }
}

