/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.presto;

import io.jsonwebtoken.SignatureAlgorithm;
import java.security.Key;
import java.time.Duration;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.crypto.SecretKey;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.pulsar.broker.authentication.utils.AuthTokenUtils;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.common.policies.data.AuthAction;
import org.apache.pulsar.tests.integration.containers.BrokerContainer;
import org.apache.pulsar.tests.integration.containers.PrestoWorkerContainer;
import org.apache.pulsar.tests.integration.docker.ContainerExecException;
import org.apache.pulsar.tests.integration.docker.ContainerExecResult;
import org.apache.pulsar.tests.integration.presto.TestPulsarSQLBase;
import org.apache.pulsar.tests.integration.topologies.PulsarClusterSpec;
import org.awaitility.Awaitility;
import org.awaitility.core.ThrowingRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestPulsarSQLAuth
extends TestPulsarSQLBase {
    private static final Logger log = LoggerFactory.getLogger(TestPulsarSQLAuth.class);
    private SecretKey secretKey;
    private String adminToken;
    private PulsarAdmin admin;

    @Override
    protected PulsarClusterSpec.PulsarClusterSpecBuilder beforeSetupCluster(String clusterName, PulsarClusterSpec.PulsarClusterSpecBuilder specBuilder) {
        specBuilder = super.beforeSetupCluster(clusterName, specBuilder);
        specBuilder.enablePrestoWorker(true);
        return specBuilder;
    }

    @Override
    protected void beforeStartCluster() {
        this.secretKey = AuthTokenUtils.createSecretKey((SignatureAlgorithm)SignatureAlgorithm.HS256);
        this.adminToken = AuthTokenUtils.createToken((Key)this.secretKey, (String)"admin", Optional.empty());
        HashMap<String, String> envMap = new HashMap<String, String>();
        envMap.put("authenticationEnabled", "true");
        envMap.put("authenticationProviders", "org.apache.pulsar.broker.authentication.AuthenticationProviderToken");
        envMap.put("authorizationEnabled", "true");
        envMap.put("tokenSecretKey", AuthTokenUtils.encodeKeyBase64((Key)this.secretKey));
        envMap.put("superUserRoles", "admin");
        envMap.put("brokerDeleteInactiveTopicsEnabled", "false");
        envMap.put("topicLevelPoliciesEnabled", "false");
        for (BrokerContainer brokerContainer : this.pulsarCluster.getBrokers()) {
            brokerContainer.withEnv(envMap);
        }
        PrestoWorkerContainer prestoWorkerContainer = this.pulsarCluster.getPrestoWorkerContainer();
        ((PrestoWorkerContainer)((PrestoWorkerContainer)((PrestoWorkerContainer)prestoWorkerContainer.withEnv("SQL_PREFIX_pulsar.auth-plugin", "org.apache.pulsar.client.impl.auth.AuthenticationToken")).withEnv("SQL_PREFIX_pulsar.auth-params", this.adminToken)).withEnv("pulsar.broker-binary-service-url", "pulsar://pulsar-broker-0:6650")).withEnv("pulsar.authorization-enabled", "true");
    }

    @Override
    public void setupCluster() throws Exception {
        super.setupCluster();
        this.initJdbcConnection();
        this.admin = PulsarAdmin.builder().serviceHttpUrl(this.pulsarCluster.getHttpServiceUrl()).authentication("org.apache.pulsar.client.impl.auth.AuthenticationToken", this.adminToken).build();
    }

    @Override
    public void tearDownCluster() throws Exception {
        super.tearDownCluster();
    }

    @Test
    public void testPulsarSQLAuthCheck() throws PulsarAdminException {
        String passRole = RandomStringUtils.randomAlphabetic((int)4) + "-pass";
        String deniedRole = RandomStringUtils.randomAlphabetic((int)4) + "-denied";
        final String passToken = AuthTokenUtils.createToken((Key)this.secretKey, (String)passRole, Optional.empty());
        final String deniedToken = AuthTokenUtils.createToken((Key)this.secretKey, (String)deniedRole, Optional.empty());
        String topic = "testPulsarSQLAuthCheck";
        this.admin.topics().grantPermission(topic, passRole, EnumSet.of(AuthAction.consume));
        this.admin.topics().createNonPartitionedTopic(topic);
        String queryAllDataSql = String.format("select * from pulsar.\"%s\".\"%s\";", "public/default", topic);
        this.assertSQLExecution(() -> {
            try {
                ContainerExecResult containerExecResult = this.execQuery(queryAllDataSql, (Map<String, String>)new HashMap<String, String>(){
                    {
                        this.put("auth-plugin", "org.apache.pulsar.client.impl.auth.AuthenticationToken");
                        this.put("auth-params", passToken);
                    }
                });
                Assert.assertEquals((long)containerExecResult.getExitCode(), (long)0L);
            }
            catch (ContainerExecException e) {
                Assert.fail((String)String.format("assertSQLExecution fail: %s", e.getLocalizedMessage()));
            }
        });
        this.assertSQLExecution(() -> {
            try {
                this.execQuery(queryAllDataSql, (Map<String, String>)new HashMap<String, String>(){
                    {
                        this.put("auth-plugin", "org.apache.pulsar.client.impl.auth.AuthenticationToken");
                        this.put("auth-params", "invalid-token");
                    }
                });
                Assert.fail((String)"Should not pass");
            }
            catch (ContainerExecException e) {
                Assert.assertEquals((long)e.getResult().getExitCode(), (long)1L);
                log.info(e.getResult().getStderr());
                Assert.assertTrue((boolean)e.getResult().getStderr().contains("Failed to authenticate"));
            }
        });
        this.assertSQLExecution(() -> {
            try {
                this.execQuery(queryAllDataSql, (Map<String, String>)new HashMap<String, String>(){
                    {
                        this.put("auth-plugin", "org.apache.pulsar.client.impl.auth.AuthenticationToken");
                        this.put("auth-params", deniedToken);
                    }
                });
                Assert.fail((String)"Should not pass");
            }
            catch (ContainerExecException e) {
                Assert.assertEquals((long)e.getResult().getExitCode(), (long)1L);
                log.info(e.getResult().getStderr());
                Assert.assertTrue((boolean)e.getResult().getStderr().contains("not authorized"));
            }
        });
    }

    @Test
    public void testCheckAuthForMultipleTopics() throws PulsarAdminException {
        String testRole = RandomStringUtils.randomAlphabetic((int)4) + "-test";
        final String testToken = AuthTokenUtils.createToken((Key)this.secretKey, (String)testRole, Optional.empty());
        String topic1 = "testCheckAuthForMultipleTopics1";
        String topic2 = "testCheckAuthForMultipleTopics2";
        this.admin.topics().grantPermission(topic1, testRole, EnumSet.of(AuthAction.consume));
        this.admin.topics().createNonPartitionedTopic(topic1);
        this.admin.topics().createPartitionedTopic(topic2, 2);
        String queryAllDataSql = String.format("select * from pulsar.\"public/default\".\"%s\", pulsar.\"public/default\".\"%s\";", topic1, topic2);
        this.assertSQLExecution(() -> {
            try {
                this.execQuery(queryAllDataSql, (Map<String, String>)new HashMap<String, String>(){
                    {
                        this.put("auth-plugin", "org.apache.pulsar.client.impl.auth.AuthenticationToken");
                        this.put("auth-params", testToken);
                    }
                });
                Assert.fail((String)"Should not pass");
            }
            catch (ContainerExecException e) {
                Assert.assertEquals((long)e.getResult().getExitCode(), (long)1L);
                log.info(e.getResult().getStderr());
            }
        });
        this.admin.topics().grantPermission(topic2, testRole, EnumSet.of(AuthAction.consume));
        this.assertSQLExecution(() -> {
            try {
                ContainerExecResult containerExecResult = this.execQuery(queryAllDataSql, (Map<String, String>)new HashMap<String, String>(){
                    {
                        this.put("auth-plugin", "org.apache.pulsar.client.impl.auth.AuthenticationToken");
                        this.put("auth-params", testToken);
                    }
                });
                Assert.assertEquals((long)containerExecResult.getExitCode(), (long)0L);
            }
            catch (ContainerExecException e) {
                Assert.fail((String)String.format("assertSQLExecution fail: %s", e.getLocalizedMessage()));
            }
        });
    }

    private void assertSQLExecution(ThrowingRunnable assertion) {
        Awaitility.await().pollDelay(Duration.ofMillis(0L)).pollInterval(Duration.ofSeconds(3L)).atMost(Duration.ofSeconds(15L)).untilAsserted(assertion);
    }
}

