/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.plugins;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.pulsar.tests.integration.containers.BrokerContainer;
import org.apache.pulsar.tests.integration.suites.PulsarTestSuite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestProtocolHandlers
extends PulsarTestSuite {
    private static final Logger LOG = LoggerFactory.getLogger(TestProtocolHandlers.class);
    private static final int PORT = 55000;
    private static final String PREFIX = "PULSAR_PREFIX_";
    public static final int DATA_LENGTH = 127;

    @Override
    public void setupCluster() throws Exception {
        this.brokerEnvs.put("PULSAR_PREFIX_messagingProtocols", "echo");
        this.brokerEnvs.put("PULSAR_PREFIX_protocolHandlerDirectory", "/pulsar/examples");
        this.brokerEnvs.put("PULSAR_PREFIX_echoServerPort", "55000");
        this.brokerAdditionalPorts.add(55000);
        super.setupCluster();
    }

    @Test
    public void test() throws Exception {
        BrokerContainer broker = this.pulsarCluster.getAnyBroker();
        String host = broker.getHost();
        String data = TestProtocolHandlers.randomName(127);
        int mappedPort = broker.getMappedPort(55000);
        LOG.debug("Sending data to {}:{}", (Object)host, (Object)mappedPort);
        try (Socket client = new Socket(host, mappedPort);
             OutputStream out = client.getOutputStream();
             InputStream in = client.getInputStream();){
            LOG.debug("Connection established");
            out.write(data.getBytes());
            LOG.debug("Data sent");
            byte[] response = in.readNBytes(127);
            Assert.assertEquals((String)new String(response), (String)data);
        }
    }
}

