/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.offload;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.tests.integration.docker.ContainerExecException;
import org.apache.pulsar.tests.integration.docker.ContainerExecResult;
import org.apache.pulsar.tests.integration.offload.TestBaseOffload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.Test;

public class TestOffloadDeletionFS
extends TestBaseOffload {
    private static final Logger log = LoggerFactory.getLogger(TestOffloadDeletionFS.class);

    @Override
    protected int getEntrySize() {
        return 512;
    }

    @Override
    protected int getNumEntriesPerLedger() {
        return 200;
    }

    @Test(dataProvider="ServiceAndAdminUrls")
    public void testDeleteOffloadedTopic(Supplier<String> serviceUrl, Supplier<String> adminUrl) throws Exception {
        super.testDeleteOffloadedTopic(serviceUrl.get(), adminUrl.get(), false, 0);
    }

    @Test(dataProvider="ServiceAndAdminUrls")
    public void testDeleteUnloadedOffloadedTopic(Supplier<String> serviceUrl, Supplier<String> adminUrl) throws Exception {
        super.testDeleteOffloadedTopic(serviceUrl.get(), adminUrl.get(), true, 0);
    }

    @Test(dataProvider="ServiceAndAdminUrls")
    public void testDeleteOffloadedTopicExistsInBk(Supplier<String> serviceUrl, Supplier<String> adminUrl) throws Exception {
        super.testDeleteOffloadedTopicExistsInBk(serviceUrl.get(), adminUrl.get(), false, 0);
    }

    @Test(dataProvider="ServiceAndAdminUrls")
    public void testDeleteUnloadedOffloadedTopicExistsInBk(Supplier<String> serviceUrl, Supplier<String> adminUrl) throws Exception {
        super.testDeleteOffloadedTopicExistsInBk(serviceUrl.get(), adminUrl.get(), true, 0);
    }

    @Test(dataProvider="ServiceAndAdminUrls")
    public void testDeleteOffloadedPartitionedTopic(Supplier<String> serviceUrl, Supplier<String> adminUrl) throws Exception {
        super.testDeleteOffloadedTopic(serviceUrl.get(), adminUrl.get(), false, 3);
    }

    @Test(dataProvider="ServiceAndAdminUrls")
    public void testDeleteUnloadedOffloadedPartitionedTopic(Supplier<String> serviceUrl, Supplier<String> adminUrl) throws Exception {
        super.testDeleteOffloadedTopic(serviceUrl.get(), adminUrl.get(), true, 3);
    }

    @Test(dataProvider="ServiceAndAdminUrls")
    public void testDeleteOffloadedPartitionedTopicExistsInBk(Supplier<String> serviceUrl, Supplier<String> adminUrl) throws Exception {
        super.testDeleteOffloadedTopicExistsInBk(serviceUrl.get(), adminUrl.get(), false, 3);
    }

    @Test(dataProvider="ServiceAndAdminUrls")
    public void testDeleteUnloadedOffloadedPartitionedTopicExistsInBk(Supplier<String> serviceUrl, Supplier<String> adminUrl) throws Exception {
        super.testDeleteOffloadedTopicExistsInBk(serviceUrl.get(), adminUrl.get(), true, 3);
    }

    @Override
    protected Map<String, String> getEnv() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("managedLedgerMaxEntriesPerLedger", String.valueOf(this.getNumEntriesPerLedger()));
        result.put("managedLedgerMinLedgerRolloverTimeMinutes", "0");
        result.put("managedLedgerOffloadDriver", "filesystem");
        result.put("fileSystemURI", "file:///");
        return result;
    }

    @Override
    protected boolean offloadedLedgerExists(String topic, int partitionNum, long ledger) {
        log.info("offloadedLedgerExists(topic = {}, partitionNum={},ledger={})", new Object[]{topic, partitionNum, ledger});
        if (partitionNum > -1) {
            topic = (String)topic + "-partition-" + partitionNum;
        }
        String managedLedgerName = TopicName.get((String)topic).getPersistenceNamingEncoding();
        String rootPath = "pulsar/";
        String dirPath = rootPath + managedLedgerName + "/";
        LinkedList result = new LinkedList();
        String[] cmds = new String[]{"ls", "-1", dirPath};
        this.pulsarCluster.getBrokers().forEach(broker -> {
            try {
                ContainerExecResult res = broker.execCmd(cmds);
                log.info("offloadedLedgerExists broker {} 'ls -1 {}' got {}", new Object[]{broker.getContainerName(), dirPath, res.getStdout()});
                Arrays.stream(res.getStdout().split("\n")).filter(x -> x.startsWith(ledger + "-")).forEach(x -> result.add(x));
            }
            catch (ContainerExecException ce) {
                log.info("offloadedLedgerExists broker {} 'ls -1 {}' got error code {}", new Object[]{broker.getContainerName(), dirPath, ce.getResult().getExitCode()});
                if (ce.getResult().getExitCode() != 2L) {
                    throw new RuntimeException(ce);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        return !result.isEmpty();
    }
}

