/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.messaging;

import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.pulsar.broker.loadbalance.extensions.ExtensibleLoadManagerImpl;
import org.apache.pulsar.broker.loadbalance.extensions.scheduler.TransferShedder;
import org.apache.pulsar.common.naming.TopicDomain;
import org.apache.pulsar.tests.integration.messaging.TopicMessagingBase;
import org.testng.ITest;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;

public class MessagingSmokeTest
extends TopicMessagingBase
implements ITest {
    private final String name;

    @Factory
    public static Object[] messagingTests() {
        List<MessagingSmokeTest> tests = List.of(new MessagingSmokeTest("Extensible Load Manager", Map.of("loadManagerClassName", ExtensibleLoadManagerImpl.class.getName(), "loadBalancerLoadSheddingStrategy", TransferShedder.class.getName())), new MessagingSmokeTest("Extensible Load Manager with TX Coordinator", Map.of("loadManagerClassName", ExtensibleLoadManagerImpl.class.getName(), "loadBalancerLoadSheddingStrategy", TransferShedder.class.getName(), "transactionCoordinatorEnabled", "true")));
        return tests.toArray();
    }

    public MessagingSmokeTest(String name, Map<String, String> brokerEnvs) {
        this.brokerEnvs.putAll(brokerEnvs);
        this.name = name;
    }

    public String getTestName() {
        return this.name;
    }

    @Test(dataProvider="serviceUrlAndTopicDomain")
    public void testNonPartitionedTopicMessagingWithExclusive(Supplier<String> serviceUrl, TopicDomain topicDomain) throws Exception {
        this.nonPartitionedTopicSendAndReceiveWithExclusive(serviceUrl.get(), TopicDomain.persistent.equals((Object)topicDomain));
    }

    @Test(dataProvider="serviceUrlAndTopicDomain")
    public void testPartitionedTopicMessagingWithExclusive(Supplier<String> serviceUrl, TopicDomain topicDomain) throws Exception {
        this.partitionedTopicSendAndReceiveWithExclusive(serviceUrl.get(), TopicDomain.persistent.equals((Object)topicDomain));
    }

    @Test(dataProvider="serviceUrlAndTopicDomain")
    public void testNonPartitionedTopicMessagingWithFailover(Supplier<String> serviceUrl, TopicDomain topicDomain) throws Exception {
        this.nonPartitionedTopicSendAndReceiveWithFailover(serviceUrl.get(), TopicDomain.persistent.equals((Object)topicDomain));
    }

    @Test(dataProvider="serviceUrlAndTopicDomain")
    public void testPartitionedTopicMessagingWithFailover(Supplier<String> serviceUrl, TopicDomain topicDomain) throws Exception {
        this.partitionedTopicSendAndReceiveWithFailover(serviceUrl.get(), TopicDomain.persistent.equals((Object)topicDomain));
    }

    @Test(dataProvider="serviceUrlAndTopicDomain")
    public void testNonPartitionedTopicMessagingWithShared(Supplier<String> serviceUrl, TopicDomain topicDomain) throws Exception {
        this.nonPartitionedTopicSendAndReceiveWithShared(serviceUrl.get(), TopicDomain.persistent.equals((Object)topicDomain));
    }

    @Test(dataProvider="serviceUrlAndTopicDomain")
    public void testPartitionedTopicMessagingWithShared(Supplier<String> serviceUrl, TopicDomain topicDomain) throws Exception {
        this.partitionedTopicSendAndReceiveWithShared(serviceUrl.get(), TopicDomain.persistent.equals((Object)topicDomain));
    }

    @Test(dataProvider="serviceUrlAndTopicDomain")
    public void testNonPartitionedTopicMessagingWithKeyShared(Supplier<String> serviceUrl, TopicDomain topicDomain) throws Exception {
        this.nonPartitionedTopicSendAndReceiveWithKeyShared(serviceUrl.get(), TopicDomain.persistent.equals((Object)topicDomain));
    }

    @Test(dataProvider="serviceUrlAndTopicDomain")
    public void testPartitionedTopicMessagingWithKeyShared(Supplier<String> serviceUrl, TopicDomain topicDomain) throws Exception {
        this.partitionedTopicSendAndReceiveWithKeyShared(serviceUrl.get(), TopicDomain.persistent.equals((Object)topicDomain));
    }
}

