/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.cli.topicpolicies;

import org.apache.pulsar.common.policies.data.SchemaCompatibilityStrategy;
import org.apache.pulsar.tests.integration.docker.ContainerExecResult;
import org.apache.pulsar.tests.integration.suites.PulsarCliTestSuite;
import org.awaitility.Awaitility;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class SchemaCompatibilityStrategyTest
extends PulsarCliTestSuite {
    @Override
    @BeforeClass(alwaysRun=true)
    public void before() throws Exception {
        this.enableTopicPolicies();
        super.before();
    }

    @Override
    @AfterClass(alwaysRun=true)
    public void after() throws Exception {
        super.after();
    }

    @Test
    public void testSchemaCompatibilityStrategyCmd() throws Exception {
        String topicName = SchemaCompatibilityStrategyTest.generateTopicName("test-schema-compatibility-strategy", true);
        this.pulsarAdmin.topics().createNonPartitionedTopic(topicName);
        ContainerExecResult result = this.pulsarCluster.runAdminCommandOnAnyBroker("topicPolicies", "get-schema-compatibility-strategy", topicName);
        Assert.assertEquals((String)result.getStdout().trim(), (String)"null");
        result = this.pulsarCluster.runAdminCommandOnAnyBroker("topicPolicies", "get-schema-compatibility-strategy", "--applied", topicName);
        Assert.assertEquals((String)result.getStdout().trim(), (String)SchemaCompatibilityStrategy.FULL.name());
        this.pulsarAdmin.topicPolicies().removeSchemaCompatibilityStrategy(topicName);
        Awaitility.await().untilAsserted(() -> Assert.assertEquals((String)this.pulsarCluster.runAdminCommandOnAnyBroker("topicPolicies", "get-schema-compatibility-strategy", topicName).getStdout().trim(), (String)"null"));
    }

    @Test
    public void testSchemaCompatibilityStrategyCmdWithNamespaceLevel() throws Exception {
        String ns = SchemaCompatibilityStrategyTest.generateNamespaceName();
        String fullNS = "public/" + ns;
        this.pulsarAdmin.namespaces().createNamespace("public/" + ns);
        String topicName = SchemaCompatibilityStrategyTest.generateTopicName(ns, "test-schema-compatibility-strategy", true);
        this.pulsarAdmin.namespaces().setSchemaCompatibilityStrategy(fullNS, SchemaCompatibilityStrategy.ALWAYS_INCOMPATIBLE);
        this.pulsarAdmin.topics().createNonPartitionedTopic(topicName);
        ContainerExecResult result = this.pulsarCluster.runAdminCommandOnAnyBroker("topicPolicies", "get-schema-compatibility-strategy", topicName);
        Assert.assertEquals((String)result.getStdout().trim(), (String)"null");
        result = this.pulsarCluster.runAdminCommandOnAnyBroker("topicPolicies", "get-schema-compatibility-strategy", "--applied", topicName);
        Assert.assertEquals((String)result.getStdout().trim(), (String)SchemaCompatibilityStrategy.ALWAYS_INCOMPATIBLE.name());
        this.pulsarAdmin.namespaces().setSchemaCompatibilityStrategy(fullNS, SchemaCompatibilityStrategy.UNDEFINED);
        result = this.pulsarCluster.runAdminCommandOnAnyBroker("topicPolicies", "get-schema-compatibility-strategy", topicName);
        Assert.assertEquals((String)result.getStdout().trim(), (String)"null");
    }
}

