/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.websocket;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import org.apache.pulsar.tests.integration.containers.BrokerContainer;
import org.apache.pulsar.tests.integration.containers.WebSocketContainer;
import org.apache.pulsar.tests.integration.topologies.PulsarClusterSpec;
import org.apache.pulsar.tests.integration.websocket.WebSocketTestSuite;
import org.testng.annotations.Test;

public class TestWebSocket
extends WebSocketTestSuite {
    public static final String WEBSOCKET = "websocket";

    @Override
    protected PulsarClusterSpec.PulsarClusterSpecBuilder beforeSetupCluster(String clusterName, PulsarClusterSpec.PulsarClusterSpecBuilder specBuilder) {
        Map<String, String> enableWebSocket = Collections.singletonMap("webSocketServiceEnabled", "true");
        specBuilder.brokerEnvs(enableWebSocket);
        specBuilder.proxyEnvs(enableWebSocket);
        specBuilder.externalService(WEBSOCKET, new WebSocketContainer(clusterName, WEBSOCKET));
        specBuilder.externalServiceEnv(WEBSOCKET, (Map<String, String>)ImmutableMap.builder().put((Object)"configurationMetadataStoreUrl", (Object)"configuration-store:2184").put((Object)"webServicePort", (Object)"8080").put((Object)"clusterName", (Object)clusterName).build());
        return super.beforeSetupCluster(clusterName, specBuilder);
    }

    @Test
    public void testExternalService() throws Exception {
        WebSocketContainer service = (WebSocketContainer)this.pulsarCluster.getExternalServices().get(WEBSOCKET);
        this.testWebSocket(service.getWSUrl());
    }

    @Test
    public void testBroker() throws Exception {
        BrokerContainer broker = this.pulsarCluster.getAnyBroker();
        String url = "ws://" + broker.getHost() + ":" + broker.getMappedPort(8080);
        this.testWebSocket(url);
    }

    @Test
    public void testProxy() throws Exception {
        String url = this.pulsarCluster.getProxy().getHttpServiceUrl().replaceFirst("http", "ws");
        this.testWebSocket(url);
    }
}

