/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.topologies;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.tests.integration.topologies.PulsarCluster;
import org.apache.pulsar.tests.integration.topologies.PulsarClusterSpec;
import org.apache.pulsar.tests.integration.topologies.PulsarTestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.DataProvider;

public abstract class PulsarClusterTestBase
extends PulsarTestBase {
    private static final Logger log = LoggerFactory.getLogger(PulsarClusterTestBase.class);
    protected final Map<String, String> brokerEnvs = new HashMap<String, String>();
    protected final Map<String, String> bookkeeperEnvs = new HashMap<String, String>();
    protected final Map<String, String> proxyEnvs = new HashMap<String, String>();
    protected final List<Integer> brokerAdditionalPorts = new LinkedList<Integer>();
    protected final List<Integer> bookieAdditionalPorts = new LinkedList<Integer>();
    protected PulsarAdmin pulsarAdmin;
    protected PulsarCluster pulsarCluster;

    protected final void setup() throws Exception {
        this.setupCluster();
    }

    protected final void cleanup() throws Exception {
        this.tearDownCluster();
    }

    @DataProvider(name="ServiceUrlAndTopics")
    public Object[][] serviceUrlAndTopics() {
        return new Object[][]{{PulsarClusterTestBase.stringSupplier(() -> this.getPulsarCluster().getPlainTextServiceUrl()), true}, {PulsarClusterTestBase.stringSupplier(() -> this.getPulsarCluster().getPlainTextServiceUrl()), false}};
    }

    @DataProvider(name="ServiceUrls")
    public Object[][] serviceUrls() {
        return new Object[][]{{PulsarClusterTestBase.stringSupplier(() -> this.getPulsarCluster().getPlainTextServiceUrl())}};
    }

    @DataProvider(name="ServiceAndAdminUrls")
    public Object[][] serviceAndAdminUrls() {
        return new Object[][]{{PulsarClusterTestBase.stringSupplier(() -> this.getPulsarCluster().getPlainTextServiceUrl()), PulsarClusterTestBase.stringSupplier(() -> this.getPulsarCluster().getHttpServiceUrl())}};
    }

    public PulsarCluster getPulsarCluster() {
        return this.pulsarCluster;
    }

    protected static Supplier<String> stringSupplier(Supplier<String> supplier) {
        return supplier;
    }

    public void setupCluster() throws Exception {
        this.setupCluster("");
    }

    public void setupCluster(String namePrefix) throws Exception {
        String clusterName = Stream.of(((Object)((Object)this)).getClass().getSimpleName(), namePrefix, PulsarClusterTestBase.randomName(5)).filter(s -> s != null && !s.isEmpty()).collect(Collectors.joining("-"));
        PulsarClusterSpec.PulsarClusterSpecBuilder specBuilder = PulsarClusterSpec.builder().clusterName(clusterName).brokerEnvs(this.brokerEnvs).proxyEnvs(this.proxyEnvs).brokerAdditionalPorts(this.brokerAdditionalPorts);
        this.setupCluster(this.beforeSetupCluster(clusterName, specBuilder).build());
    }

    protected PulsarClusterSpec.PulsarClusterSpecBuilder beforeSetupCluster(String clusterName, PulsarClusterSpec.PulsarClusterSpecBuilder specBuilder) {
        return specBuilder;
    }

    protected void beforeStartCluster() throws Exception {
    }

    protected void setupCluster(PulsarClusterSpec spec) throws Exception {
        this.incrementSetupNumber();
        log.info("Setting up cluster {} with {} bookies, {} brokers", new Object[]{spec.clusterName(), spec.numBookies(), spec.numBrokers()});
        this.pulsarCluster = PulsarCluster.forSpec(spec);
        this.beforeStartCluster();
        this.pulsarCluster.start();
        this.pulsarAdmin = PulsarAdmin.builder().serviceHttpUrl(this.pulsarCluster.getHttpServiceUrl()).build();
        log.info("Cluster {} is setup", (Object)spec.clusterName());
    }

    public void tearDownCluster() throws Exception {
        this.markCurrentSetupNumberCleaned();
        if (null != this.pulsarCluster) {
            this.pulsarCluster.stop();
        }
    }
}

