/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.topologies;

import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.Schema;
import org.testng.Assert;

public class ClientTestBase {
    private static final int RECEIVE_TIMEOUT_SECONDS = 3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetCursorCompatibility(String serviceUrl, String serviceHttpUrl, String topicName) throws Exception {
        String subName = "my-sub";
        PulsarClient pulsarClient = PulsarClient.builder().serviceUrl(serviceUrl).build();
        try {
            PulsarAdmin admin = PulsarAdmin.builder().serviceHttpUrl(serviceHttpUrl).build();
            try {
                Message message;
                Message lastMsg = null;
                Producer producer = pulsarClient.newProducer(Schema.STRING).enableBatching(false).topic(topicName).create();
                try {
                    Consumer consumer = pulsarClient.newConsumer(Schema.STRING).topic(new String[]{topicName}).subscriptionName("my-sub").subscribe();
                    try {
                        int i;
                        for (i = 0; i < 50; ++i) {
                            producer.send((Object)("msg" + i));
                        }
                        for (i = 0; i < 10; ++i) {
                            lastMsg = consumer.receive();
                            Assert.assertNotNull((Object)lastMsg);
                            consumer.acknowledge(lastMsg);
                        }
                    }
                    finally {
                        if (Collections.singletonList(consumer).get(0) != null) {
                            consumer.close();
                        }
                    }
                }
                finally {
                    if (Collections.singletonList(producer).get(0) != null) {
                        producer.close();
                    }
                }
                admin.topics().resetCursor(topicName, "my-sub", lastMsg.getMessageId());
                Consumer consumer2 = pulsarClient.newConsumer(Schema.STRING).topic(new String[]{topicName}).subscriptionName("my-sub").subscribe();
                try {
                    message = consumer2.receive(3, TimeUnit.SECONDS);
                    Assert.assertEquals((Object)message.getMessageId(), (Object)lastMsg.getMessageId());
                }
                finally {
                    if (Collections.singletonList(consumer2).get(0) != null) {
                        consumer2.close();
                    }
                }
                admin.topics().resetCursorAsync(topicName, "my-sub", lastMsg.getMessageId()).get(3L, TimeUnit.SECONDS);
                Consumer consumer3 = pulsarClient.newConsumer(Schema.STRING).topic(new String[]{topicName}).subscriptionName("my-sub").subscribe();
                try {
                    message = consumer3.receive(3, TimeUnit.SECONDS);
                    Assert.assertEquals((Object)message.getMessageId(), (Object)lastMsg.getMessageId());
                }
                finally {
                    if (Collections.singletonList(consumer3).get(0) != null) {
                        consumer3.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(admin).get(0) != null) {
                    admin.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(pulsarClient).get(0) != null) {
                pulsarClient.close();
            }
        }
    }
}

